package com.horizon.wf.rule.defa.core;

import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.rule.common.RuleUtil;

/**
 * 节点离开处理
 * 判断是否有定义的离开接口类或者规则定义
 * @author liys
 * @date 2015-06-05
 * @version 1.0
 * @since hz7.2
 * 
 */
public class LeaveRuleDefault extends BaseRuleImpl implements IBaseRule {
	private PubInfo pubInfo;
	/**
	 * 节点离开规则处理
	 */
	public boolean executeRule() {
		RunningData rd = getRunningdata();
		pubInfo = PubInfo.getPubInfo(rd.getLangInfo());
//		WorkParaBean paraBean = (WorkParaBean)rd.getHmiParaObject();
		IFlowNode curnode = (IFlowNode)getParameter(StaticVarExtend.Para_LeaveRules_IXmlNode);
		
		String className = curnode.getLeaveRulesClassName();
		if(className==null || "".equals(className)){
			String script = curnode.getLeaveRulesScript();
			try{
				boolean result = RuleUtil.executeRule(script,curnode, rd);
				if(!result){
					String msg = rd.getBackMsg();
					if(StringUtilExtend.isNull(msg)){
						rd.setBackMsg(pubInfo.getInfo("Leave_Msg0001","[|nodename|]离开规则为false，不允许离开")
															  .replace("|nodename|", curnode.getNodename()));
					}
					rd.setResultCode(StaticVarExtend.F_STATUS_LeaveRule_Error);
					return false;
				}
			}catch(Exception e){
				ActionCommon ac = StaticFunExtend.getActionCommon();
				ac.handleExceptionDelay(ac.getExceptionByCode(StaticVarExtend.Exception_Code_NodeLeaveRuleError, curnode.getExceptions()), 
							rd,curnode);
				rd.setResultCode(StaticVarExtend.F_STATUS_LeaveRule_Error);
				rd.setBackMsg(pubInfo.getInfo("Leave_Msg0002","[|nodename|]节点离开规则执行异常")
						  							  .replace("|nodename|", curnode.getNodename()));
				return false;
			}
		}
		else{
			IBaseRule br = InterfaceFactory.getNewInterface(className);
			if(br == null){
				rd.putMsgToConsole("[Err]leaveClass is null:"+className);
				rd.setResultCode(StaticVarExtend.F_STATUS_OtherError);
				rd.setBackMsg(pubInfo.getInfo("Leave_Msg0003","[|nodename|]节点离开接口类初始化异常!")
						  							  .replace("|nodename|", curnode.getNodename()));
				return false;
			}
			
			br.setRunningData(rd);
			br.setParameter(StaticVar.Para_LeaveRules_IXmlNode, curnode);
			
			boolean isLeave =br.executeRule();
			if(!isLeave){
				return false;
			}
		}
		
		return true;
	}

}
