package com.horizon.wf.rule.defa.core;

import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.bean.WorkResultBean;
import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.track.json.bean.TrackNodeJsonImpl;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.definition.pub.node.user.IUserRelation;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.entity.run.NodeUser;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.global.*;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.rule.common.RuleUtil;
import com.horizon.wf.tools.CStrUtil;

import java.util.*;
/**
 * 节点进入处理
 * 对节点处理人进行分析处理
 * @author liys
 * @version 1.0
 * @since v7.2
 *
 */
public class EntryRuleDefault extends BaseRuleImpl implements IBaseRule {
	private boolean isExitOrg = true;//初始化的字符串是否都存在于组织机构中
	private IOrganizationInterface org;
	private RunningData rd ;
	private WorkParaBean paraBean ;
	private WorkResultBean resultBean ;
	
	private boolean isReject = false;
	private INextNode taskNode;
	private IFlowNode xmlNode;
	private INodeRouter fromRouter ;
	private INodeAuthUser xmlUserAuthor;
	private Map<String,String> selectUsers = null;
	private Map<String, String> initAuthorMap = null;
	/**
	 * 定义一个返回列表,记录当前节点的所有参与者
	 */
	private	List<NodeUser> backUsers = new ArrayList<NodeUser>();
	private int nodeType ;
	private int leaveType ;
	private PubInfo pubInfo;
	
	private IFlowNode curNode;
	private String submitflag;
	/**
	 * 1按路由方向进入,2=退回的方式进入,3=跳转的方式进入
	 */
	private static int LeaveByRoute =1;
	private static int LeaveByReject =2;
	private static int LeaveByJump =3;
	/**
	 * 进入节点
	 * 需要根据节点类型,进入方式不同进行处理(此类为默认实现类)
	 * selectUsers 已经确定的参与者列表
	 * initAuthorMap	节点设置的办理人,用于需要从设置的参与者中选择时
	 * backUsers		已经确定的参与者对象列表,包含前台传入和后台配置中获取的
	 * true 可以进入(节点办理人符合),false节点不能进入,原因写入result和backMsg
	 */
	@Override
	public boolean executeRule() {
		initParam();
		//20150608liys 扩展接口或者规则判断是否允许进入
		boolean isEntry = actionInterface(leaveType);
		if(!isEntry){
			rd.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			//HZWF-695
			setBackMsg(rd.getBackMsg());
			return false;
		}
		setBackMsg(pubInfo.getInfo("Entry_Msg0001","[|nodename|]初始化成功").replace("|nodename|", taskNode.getNodename()));
		//办理人初始化....
		initAuthor();
		//跳过节点时,忽略其他执行内容
		if(taskNode.getInitResult() == StaticVarExtend.F_STATUS_JumpThisNode){
			setBackMsg(pubInfo.getInfo("Entry_Msg0007","跳过节点[|nodename|]").replace("|nodename|", taskNode.getNodename()));
			return true;
		}
		putMsgToConsole("[Msg]=====结束获取参与者:办理人=========");
		
		if(isSelectReader()){
			//读者
			initNode(StaticVarExtend.AUTH_READER);
		}
		if(isSelectSecondAuthor()){
			//协办者
			initNode(StaticVarExtend.AUTH_SECOND_AUTHOR);			
		}
		resultBean.setInitAuthorMap(initAuthorMap);
		
		setResult(backUsers);
		
		if(!isExitOrg){
			rd.setResultCode(StaticVarExtend.F_STATUS_OtherError);
			return false;
		}
		return true;
	}
	private void initParam(){
		rd = getRunningdata();
		pubInfo = PubInfo.getPubInfo(rd.getLangInfo());
		org = PluginsUtil.getMultiInstance().getOrganization(rd.getInitData().getTenantid());
//---------	执行节点(下一节点)-------------------------------
		taskNode = (INextNode)getParameter(StaticVarExtend.Para_EntryRules_ThisNode);
//		从参数中获取节点定义数据对象
		xmlNode 		= (IFlowNode)getParameter(StaticVarExtend.Para_EntryRules_IXmlNode);
//		从参数中获取指向路由定义数据对象
		fromRouter 	= (INodeRouter)getParameter(StaticVarExtend.Para_EntryRules_IXmlRouter);
		//节点进入的方式,1按路由方向进入,2=退回的方式进入,3=跳转的方式进入
		leaveType = (Integer)getParameter(StaticVarExtend.Para_EntryRules_LeaveType);
		//节点类型		
		nodeType  = xmlNode.getNodetype();//getParameter(StaticVarExtend.Para_EntryRules_NodeType);
		//办理人定义信息
		xmlUserAuthor = xmlNode.getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
		
		//判断当前节点的人员是否已经由前台传入
		resultBean 	= (WorkResultBean)rd.getWorkResultBean();
		paraBean 	= (WorkParaBean)rd.getWorkParaBean();
					
		isReject = rd.getCurTrack().getFlowstatus() == StaticVarExtend.FlowStatus_Reject;
		
		curNode = rd.getCurFlowNode();
		//前后台交互参数
		submitflag = paraBean.getSubmitflag();
		
		selectUsers = paraBean.getSelectAuthorMap();	
		initAuthorMap = resultBean.getInitAuthorMap();
	}
	//规则执行
	private boolean actionInterface(int leaveType){
		//人工方式进入时执行进入规则
		//20161115 liys 任何方式进入都应该执行规则校验
//		if(!"0".equals(xmlNode.getStartModeType())){
//			return true;
//		}
		String className = xmlNode.getEntryRulesClassName();
		if(className==null || "".equals(className)){
			String script = xmlNode.getEntryRulesStrpit();
			try{
				boolean result = "".equals(script)?true:RuleUtil.executeRule(script,xmlNode, rd);
				if(!result){
					String msg = rd.getBackMsg();
					if(StringUtilExtend.isNull(msg)){
						rd.setBackMsg(pubInfo.getInfo("Entry_Msg0002","[|nodename|]进入规则为false，不允许进入")
															  .replace("|nodename|", taskNode.getNodename()));
					}
					rd.setResultCode(StaticVarExtend.F_STATUS_EntryRule_Error);
					return false;
				}
			}catch(Exception e){
			    e.printStackTrace();
				ActionCommon ac = StaticFunExtend.getActionCommon();
				String exCode = "";
				if(ac.isEndNode(xmlNode.getNodetype())){
					exCode = StaticVarExtend.Exception_Code_NodeEndRuleError;
				}else{
					exCode = StaticVarExtend.Exception_Code_NodeEntryRuleError;
				}
				INodeException ex = ac.getExceptionByCode(exCode, xmlNode.getExceptions());
				ac.handleExceptionDelay(ex, rd,xmlNode);
				rd.setBackMsg(pubInfo.getInfo("Entry_Msg0003","|nodename|]节点进入规则执行异常")
													 .replace("|nodename|", taskNode.getNodename()));
				rd.setResultCode(StaticVarExtend.F_STATUS_EntryRule_Error);
				return false;
			}
		}
		else{
			IBaseRule entryNode = InterfaceFactory.getNewInterface(className);
			if(entryNode == null){
				rd.putMsgToConsole("[Err]EntryClass is null:"+className);
				rd.setResultCode(StaticVarExtend.F_STATUS_OtherError);
				rd.setBackMsg(pubInfo.getInfo("Entry_Msg0004","[|nodename|]节点进入接口类初始化异常!")
													  .replace("|nodename|", taskNode.getNodename()));
				return false;
			}
			String oldTrackid = (String)getParameter(StaticVarExtend.Para_EntryRules_OldTrackidForReject);
			entryNode.setRunningData(rd);
			entryNode.setParameter(StaticVar.Para_EntryRules_IXmlNode, 	xmlNode);
			entryNode.setParameter(StaticVar.Para_EntryRules_IXmlRouter, 	fromRouter);
			entryNode.setParameter(StaticVar.Para_EntryRules_LeaveType, 	leaveType);
			entryNode.setParameter(StaticVar.Para_EntryRules_OldTrackidForReject,oldTrackid);
			
			boolean isEntry =entryNode.executeRule();
			if(!isEntry){
				String msg = rd.getBackMsg();
				if(StringUtilExtend.isNull(msg)){
					rd.setBackMsg(pubInfo.getInfo("Entry_Msg0002","[|nodename|]进入规则为false，不允许进入")
														  .replace("|nodename|", taskNode.getNodename()));
				}
				rd.setResultCode(StaticVarExtend.F_STATUS_EntryRule_Error);
				return false;
			}
		}
		return true;
	}
	/**
	 * 获取办理人,有以下几种情况
	 * F_STATUS_Success:已选择人员 (交互时已经选择了办理人,也可能是不需要选择的定义人员)
	 * F_STATUS_JumpThisNode:跳过此节点(允许节点办理人为空跳过,或者只有当前人跳过)
	 * F_STATUS_SelectAuthor:选择办理人(办理人为空时允许自由选择,或者办理人需要重新选择)
	 * F_STATUS_NoAuthor:办理人为空
	 * w
	 * F_STATUS_OtherError:办理人已不在组织,直接影响runningdata结果
	 * @return
	 */
	private void initAuthor(){
		putMsgToConsole("[Msg]=====办理人获取=========NodeType:"+nodeType+",leaveType:"+leaveType);
		
		//开始节点,默认办理人为当前人
		if(nodeType == NodeTypeEnum.Node_Start){
			String userid = rd.getCurUser().getFullName();
			NodeUser user = createNodeUser(xmlUserAuthor,StaticVarExtend.AUTH_AUTHOR,userid);
			backUsers.add(user);
			//确定人员放入selectUsers中
			selectUsers.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_AUTHOR, user.getPlanid());
			//设置节点返回值,不设置则默认为F_STATUS_Success
//			taskNode.setInitResult(StaticVarExtend.F_STATUS_Success);
		}
		else if(nodeType == NodeTypeEnum.Node_Progressively && taskNode.getNodeid().equals(curNode.getNodeid())){
			//逐级审批节点,在离开之前,节点内部提交时
			initProgressivelyNode();
		}
		else if(leaveType == LeaveByReject){
			//退回时初始化参与者,仅对办理人进行处理,不考虑读者
			initReject();	
		}
		
		//自动/事件节点/子流程节点/网关在submitflag=0时进行办理人的初始化
		else if(!(StaticVarExtend.Submit_Flag.equals(submitflag))
				&&ActionCommon.getInstance().isSpecialNode(nodeType)
				){
			NodeUser user = createNodeUser(null,StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.System_Id);
			backUsers.add(user);
			//确定人员放入selectUsers中
			String keyid = taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_AUTHOR;
			selectUsers.put(keyid, user.getPlanid());
			paraBean.getSelectAuthorNameMap().put(keyid,pubInfo.getInfo("System_Name", "工作流系统"));
		}
		else{
			initNode(StaticVarExtend.AUTH_AUTHOR);
		}
	}
	/**
	 * 逐级审批节点用户初始化
	 */
	@SuppressWarnings("unchecked")
	private void initProgressivelyNode() {
		//String className = "com.horizon.wf.expand.impl.example.ProgressiceInterfaceExample";//
		//从定义信息中获取逐级审批办理人计算的实现类
		String className = xmlNode.getNodeClassName();
		if(StringUtilExtend.isNull(className)){
			putMsgToConsole("[msg] ProgressivelyClassName is null.");
			return;
		}
		IBaseRule br =  InterfaceFactory.getNewInterface(className);
		br.setParameter(StaticVarExtend.Parameter_DBWork, getRunningdata().getWork());
		br.setParameter(StaticVarExtend.Parameter_WorkParaBean, paraBean);//设置前后台对象到接口
		br.setParameter(StaticVarExtend.Parameter_Current_IFlowNode, getRunningdata().getCurFlowNode());//逐级审批节点
		br.setParameter(StaticVarExtend.Parameter_RunUser, getRunningdata().getCurUser());//当前操作者
		br.setParameter(StaticVarExtend.Parameter_Progressive_Userid, getRunningdata().getCurUser().getUserid());//(提交到逐级审批节点的人员id)
		br.setRunningData(getRunningdata());
		Map<String,String> authorMap = new LinkedHashMap<String, String>();
		if(br.executeRule()){
			authorMap = (Map<String,String>)br.getResult();
		}
		if(CollectionUtil.isMapNotEmpty(authorMap)){
			for(String key:authorMap.keySet()){
				INodeAuthUser xmluser = xmlNode.getParticipantsUser(key);
				NodeUser user = createNodeUser(xmluser,key,authorMap.get(key));
				if(null != user){
					backUsers.add(user);
					selectUsers.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+user.getAuthType(), user.getNowid());
				}
			}
		}
	}
	/**
	 * 获取退回节点的办理人
	 */
	private void initReject(){
		String funname = paraBean.getFunname();
		String userid = rd.getCurUser().getFullName();
		String authname = StaticVarExtend.AUTH_AUTHOR;
		//拿回时只生成当前办理人
		if(StaticVarExtend.OPERATOR_FUNNAME_GETBACK.equalsIgnoreCase(funname)){
			NodeUser nu = createNodeUser(null, authname, userid);
			if(null != nu){
				backUsers.add(nu);
				selectUsers.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+authname, nu.getNowid());
			}			
		}else{
			//当前实例有相关track信息以及下一节点不为空
			initRejectParticipant();
		}
	}
	/**
	 * 初始化退回的参与者
	 */
	private void initRejectParticipant(){
		String trackId = (String)getParameter(StaticVarExtend.Para_EntryRules_OldTrackidForReject);
		String authname = StaticVarExtend.AUTH_AUTHOR;
		String nodeid = taskNode.getNodeid();
		if(StringUtilExtend.isNotNull(trackId)){
			//如果是异步多人并行节点,考虑退回给原来提交的人
			int nodetype = xmlNode.getNodetype();
			int asyn = xmlNode.getAsyn();  

			//给定节点在指定路径下出现的次数
			List<Integer> nodeNums = getNodeNumByTrackid(trackId, nodeid);
			//判断给定的节点在给定的路径下是否出现过，如果没有出现过则查找该路径的上一路径
			if(CollectionUtil.isListNotEmpty(nodeNums)){
				int i = nodeNums.get(nodeNums.size()-1);
				//获取某个节点某种类型的参与者String trackid,int nodenum,String nodeid,String type
				ITrackUserJson tempUser = getRunningdata().getParticipant(trackId, i, nodeid, authname);
				String planid = tempUser.getPlanId();
				//20161221 liys 增加功能:退回时,前台可以指定选择退回给谁
				if(paraBean.isSelAuthorForReject()){
					boolean isSel = true;
					String key =taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+authname;
					if(CollectionUtil.isMapNotEmpty(selectUsers)){
					    String selAuthor = selectUsers.get(key);
					    if(StringUtilExtend.isNotNull(selAuthor)){
					    	 planid = selAuthor;
					    	 isSel = false;
					    }
			        }
					//20191211 LIYS 如果没有传入人时，让前台根据默认人进行选择（不分节点类型）
					//20161226 liys
					//判断当前人数跟节点类型是否匹配
					List<AuthUserImpl> userArr = AuthUserImpl.getAuthUserList(planid);
					if (isSel ||(userArr.size() > 1 && !(nodeType == NodeTypeEnum.Node_Multi
							|| nodeType == NodeTypeEnum.Node_Multi_Single
							|| nodeType == NodeTypeEnum.Node_Order)
					)) {
						taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
						initAuthorMap.put(key, planid);
						selectUsers.remove(key);

						return;
					}
				}
				else if(nodetype == NodeTypeEnum.Node_Progressively){
					//内部循环节点考虑只给一个人(给谁呢?暂定第一个人)
					List<AuthUserImpl>  planids =  AuthUserImpl.getAuthUserList(planid);
					planid = planids.get(0)._getFullNameWithAgent();
				}
				else if(nodetype == NodeTypeEnum.Node_Multi && asyn == 1){
					//多人并行异步时,获取原来的提交人
					//20191209 LIYS 如果是从合并节点退回时，需要获取所有办理人
					String oldUser = rd.getSubmitUserFromPreTrackXml(trackId,planid);
					//20180725如果异步只有一个人的时候,上面的方法是获取不到人员的,
					//所以还需要按照非异步的方式再获取一次
					//20180927 如果能够获取到人,则替换planid的值,否则还是planid的值
					if(CStrUtil.isNotNull(oldUser)) {
						planid = oldUser;
					}
				}
				NodeUser  nu = createNodeUser(xmlUserAuthor, authname,planid);
				if(null != nu){
					backUsers.add(nu);
					selectUsers.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+authname, nu.getNowid());
				}
				//20230415 新增获取读者身份信息
				NodeUser readerUser=getUserObjectFormXml(StaticVar.AUTH_READER);
				if(null!=readerUser){
					backUsers.add(readerUser);
					String readers=readerUser.getPlanid();
					selectUsers.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+StaticVar.AUTH_READER, readers);
				}

					
			}
		}
	}
	
	/**
	 * 判断是否需要选择读者
	 */
	private boolean isSelectReader(){
		//退回和退回提交不需要协办
		if(leaveType == LeaveByReject
				|| (leaveType == LeaveByJump && paraBean.getFunname().equals(StaticVarExtend.OPERATOR_FUNNAME_REJECT_SUBMIT))
		 ){
			return false;
		}
		//网关和引擎交互不需要选择读者,其他类型需要
		if(StaticFunExtend.getActionCommon().isGateWayNode(nodeType)
				|| NodeTypeEnum.Node_Mutual == nodeType
				){
			return false;
		}
		return true;
	}
	/**
	 * 
	 * @return
	 */
	private boolean isSelectSecondAuthor(){
		//退回和退回提交不需要协办
		if(leaveType == LeaveByReject
				|| (leaveType ==LeaveByJump && paraBean.getFunname().equals(StaticVarExtend.OPERATOR_FUNNAME_REJECT_SUBMIT))
		   ){
			return false;
		}

		return StaticFunExtend.getActionCommon().isNormalNode(nodeType);
	}
	
	/**
	 * 获取该路径的指定节点出现的次数
	 * @param trackid 路径id
	 * @param nodeid
	 * @return 给定节点出现的次数
	 */
	private List<Integer> getNodeNumByTrackid(String trackid,String nodeid){
		getRunningdata().putMsgToConsole("[msg]operator reject ");
		List<Integer> nodeNums = getRunningdata().getNodeNumByTrackid(trackid, nodeid);
		getRunningdata().putMsgToConsole("[msg]operator reject ");
		return nodeNums;
	}
	
	/**
	 * 增加初始化的人员
	 * @param type
	 */
	private void initNode(String type){
		NodeUser user =null;
		boolean isAuthor = StaticVarExtend.AUTH_AUTHOR.equals(type);
		
		if(CollectionUtil.isMapNotEmpty(selectUsers)){
			putMsgToConsole("[Msg]restore user from selecteduser");
			user = resotreUserObject(type);
			//20190510 liys 如果前端传入空值，则表明操作人员希望当前节点办理人为空，此时不再从定义中获取人员
			if(isAuthor && user != null && CStrUtil.isNull(user.getPlanid())){
				//判断是否跳过此节点
				checkXmlUser(type,null);
				return;
			}
		}
		if(user == null){
			if(isReject && isAuthor){
					user = getRejectFunNodeUser(rd.getCurTrack().getId());
			}
			else if(NodeTypeEnum.Node_Merger == nodeType){
				if(isAuthor) //需要判断合并节点是否已经离开还是处于未激活状态
				{
					user = getAuthorUserFormNodeByMergerNode(type);
				}
				else if(StaticVarExtend.AUTH_SECOND_AUTHOR.equals(type))  //协办是否需要重新选择,
				{
					user = getSecondUserFormNodeByMergerNode(type);
				}
			}
			
			if(user == null){
				putMsgToConsole("[Msg]get User Form Xml");
				user = getUserObjectFormXml(type);
				user = checkXmlUser(type,user);
			}
			//从xml中获取不到设置的办理人且为新创建时，自动把当前人赋值为第一个节点办理人
			if(user == null && rd.isNewDoc() == 0 && isAuthor ){
				user = createUserForFirst();
			}
		}
		else if(isAuthor){
			//选择的人为当前办理人,且可以跳过当前人时
			if("".equals(user.getPlanid())){
				setBackMsg(pubInfo.getInfo("Entry_Msg0005","选择的办理人只有当前办理人,且可以跳过当前人."));
				taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
				user = null;
			}
			else{
				//20161226 liys
				//判断当前人数跟节点类型是否匹配
				List<AuthUserImpl> userArr = AuthUserImpl.getAuthUserList(user.getPlanid());
				if(userArr.size()>1){
					if(!(nodeType == NodeTypeEnum.Node_Multi 
							|| nodeType == NodeTypeEnum.Node_Multi_Single
							|| nodeType == NodeTypeEnum.Node_Order
					  )){ 
						taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
						String key = taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+ StaticVarExtend.AUTH_AUTHOR;
						initAuthorMap.put(key, user.getPlanid());
						selectUsers.remove(key);
						
						user = null;
					}
				}
			}
		}
	
		if(user != null){
			backUsers.add(user);
			selectUsers.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+type, user.getPlanid());
		}
		
		if(type.equals(StaticVarExtend.AUTH_READER) 
				&& ActionCommon.getInstance().isEndNode(nodeType) 
				&& !StaticVarExtend.Submit_Flag.equals(submitflag)){//结束节点权限初始化
			//参与者指定为待阅权限
			initEndNodeParticipants(StaticVarExtend.AUTH_READER,user);
		}
	}
	
	private NodeUser createUserForFirst(){
		//返回结果为选择办理人时
		if(taskNode.getInitResult() == StaticVarExtend.F_STATUS_SelectAuthor){
			//获取是否因为设置的人需要选择
			String key = taskNode.getKeyid() +StaticVarExtend.MARK_NODE_USER + StaticVarExtend.AUTH_AUTHOR;
			String tmpUser = initAuthorMap.get(key);
			if(null == tmpUser || "".equals(tmpUser)){
				String user = paraBean.getOnlyForCreateMap().get(StaticVarExtend.AUTH_AUTHOR);
				if(!(null == user || "".equals(user))){
					putMsgToConsole("[Msg]set curUser to first node");
					selectUsers.put(key, user);
					taskNode.setInitResult(StaticVarExtend.F_STATUS_Success);
					return resotreUserObject(StaticVarExtend.AUTH_AUTHOR);
				}
			}
		}
		
		return null;
	}

	/**
	 * 从选择的结果中恢复参与者对象
	 * @param type
	 * @return 返回null表示前台没有选择办理人
	 */
	private NodeUser resotreUserObject(String type){
		String sUsers = "";
		String key = taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+type;
//		1.使用key获取办理人
		sUsers = selectUsers.get(key);
//		2.如果使用key无法获取到办理人,使用type再次获取
		//20190705 liys 为了区分时传入了空值还是没有传入,对null和""进行区分判断
		if(sUsers == null){
			sUsers = selectUsers.get(type);

			if(sUsers == null) {
				//说明当前节点还未获取过办理人
				return null;
			}
			else if("".equals(sUsers)) {
				return createNullNodeUser(); //说明前台传入了""值,而非未获取的状态
			}
			else{
				selectUsers.remove(type);//避免同一人出现多次，这样在后面发送待办的时候会重复
				selectUsers.put(key,sUsers);
			}
		}
		else if("".equals(sUsers)){
			return createNullNodeUser(); //说明前台传入了""值,而非未获取的状态
		}

		INodeAuthUser xmluser = xmlNode.getParticipantsUser(type);
		NodeUser nodeuser;
		//20150518liys 如果是主办,不允许有空格,是否跳过当前人的判断
		if(StaticVarExtend.AUTH_AUTHOR.equals(type)){
			sUsers = sUsers.trim();
			sUsers = checkPassUser(xmluser,sUsers);
			selectUsers.put(key, sUsers);
			nodeuser =  createNodeUser(xmluser,type,sUsers);
		}
		else{
			nodeuser =  createNodeUser(xmluser,type,sUsers,false);
		}
		return nodeuser;
	}
	
	//退回状态下的提交
	private NodeUser getRejectFunNodeUser(String trackid){
		String nodeid = taskNode.getNodeid();
		int num = getRejectFunNodeNum(trackid,nodeid,1);
		String tmpTrackid = trackid;
		if(num == -1){
			//合并节点退回后,执行退回提交,查找合并节点原来的办理人
			if(nodeType == NodeTypeEnum.Node_Merger){
				String[] preTrackids = rd.getPreTrackid(trackid);
				for(String preTrackid:preTrackids){
					num = getRejectFunNodeNum(preTrackid,nodeid,0);
					if(num !=-1){
						tmpTrackid = preTrackid;
						break;
					}
				}
			}
		}
		
		if(num != -1){
			ITrackUserJson tempUser = rd.getParticipant(tmpTrackid, num, nodeid, StaticVarExtend.AUTH_AUTHOR);
			INodeAuthUser xmluser = xmlNode.getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
			String planid = tempUser.getPlanId();
			return createNodeUser(xmluser,StaticVarExtend.AUTH_AUTHOR,planid);
		}
		return null;
	}
	
	/**
	 * 合并节点办理人获取
	 * @return
	 */
	private NodeUser getAuthorUserFormNodeByMergerNode(String type) {
		//允许重新选择时的处理
		boolean isReSelectAuthor = xmlNode.allowReSelectAuthorAfterReActive();
		ITrackNodeJson trackNode = getMergerTrackNode(isReSelectAuthor);
		return getUserByTrackNode(trackNode,type);
	}
	/**
	 * 合并节点协办人获取
	 * @param type
	 * @return
	 */
	private NodeUser getSecondUserFormNodeByMergerNode(String type) {
		if(HZResourceBundle.getInstance().isChgSecondAuthorForMerger()){
			return null;
		}
		ITrackNodeJson trackNode = getMergerTrackNode(false);
		return getUserByTrackNode(trackNode,type);
	}
	private ITrackNodeJson getMergerTrackNode(boolean reSel){
		List<TrackNodeJsonImpl> trackNodes = rd.getTrackNodesForMerger(taskNode.getNodeid());
		if(!(null == trackNodes || trackNodes.size()==0)){
			for(int i=0,n=trackNodes.size();i<n;i++){
				ITrackNodeJson tmpTrackNode = trackNodes.get(i);
				String tmpTrackid = tmpTrackNode.getTrackid();
				if(!rd.checkMergerNodeIsLeaved(tmpTrackid)){
					return tmpTrackNode;
				}
			}
			if(!reSel){
				//不允许重新选时,返回第一个合并节点
				return trackNodes.get(0);
			}
		}
		return null;
	}
	private NodeUser getUserByTrackNode(ITrackNodeJson trackNode,String type){
		if(null != trackNode){
			//获取节点办理人
			ITrackUserJson  trackUser = trackNode.getTrackUserImpl(type);
			if(null != trackUser ){
				String planId = trackUser.getPlanId();
				//创建一个新的节点用户
				NodeUser user = new NodeUser();
				user.setAuthType(type);
				user.setPlanid(planId);
				user.setNowid(planId);
				user.setOpenUrl("");
				user.setSendTitle("");
				user.setSendType("");
				return user;					
			}
		}
		return null;
	}
	
	//从定义xml中获取办理人信息
	private NodeUser getUserObjectFormXml(String type){
		INodeAuthUser xmluser = xmlNode.getParticipantsUser(type);
		if(null == xmluser ){
			return null;
		}
		
		StringBuilder sb = new StringBuilder(2000);//存储获取到的参与者信息

		//20150923 liys 在启动时未指定外部关键字时,节点忽略从外部获取办理人
		//是否从外部设置中获取
		String checkAttrStr = xmluser.getControlAttribute();
		String usetype = rd.getOuterSetType();
		//外部设置的办理人
		if(CStrUtil.isNotNull(usetype)
				&& checkAttrStr.indexOf(StaticVarExtend.Node_Control_OuterSelect) != -1
				&& (type.equals(StaticVarExtend.AUTH_AUTHOR) || type.equals(StaticVarExtend.AUTH_READER))){
			
			String users = "";
			if(type.equals(StaticVarExtend.AUTH_AUTHOR)){
				String[] outerUser =  RuleUtil.getOuterUsersAndLimit(StaticVarExtend.AUTH_AUTHOR.toLowerCase(), getRunningdata().getInstanceDefinition().getFlowinfo().getFlowid()
						, taskNode.getNodeid(), usetype, getRunningdata().getInitData().getFlowIdentifier());
				//20161129 liys 增加对办理时限的重置
				if(outerUser != null){
					users = outerUser[0];
					refreshNodeLimit(outerUser[1]);
				}
			
			}else if(type.equals(StaticVarExtend.AUTH_READER)){
				String[] outerUser =  RuleUtil.getOuterUsersAndLimit(StaticVarExtend.AUTH_READER.toLowerCase(), getRunningdata().getInstanceDefinition().getFlowinfo().getFlowid()
						, taskNode.getNodeid(), usetype, getRunningdata().getInitData().getFlowIdentifier());
				if(outerUser != null){
					users = outerUser[0];
				}
			}
			if(!"".equals(users)){
				sb.append(users).append(StaticVarExtend.UserSplitChar);
			}
			
			return returnGetUserObjectFormXml(xmluser,sb.toString(),type);
		}

		//从xml中获取
		getUserFromXmlSet(xmluser,sb);
		
		return returnGetUserObjectFormXml(xmluser,sb.toString(),type);
	}
	/**
	 * 重置节点时限
	 */
	private void refreshNodeLimit(String limitTime){
		if(StringUtilExtend.isNull(limitTime)){
			return;
		}
		//首先判断前台是否有重置信息,如果有则忽略,如果没有则把重新信息写入
		String nodeid = xmlNode.getNodeid();
		int[] ns = xmlNode.getNodeLimit();
		int[] tmpNs = paraBean.getNodeLimitByActionSet(nodeid);
        if(tmpNs == null){
        	tmpNs = new int[2];
        	tmpNs[0]= ns[0];
			tmpNs[1]= Integer.parseInt(limitTime);	
			paraBean.putNodeLimitSetMap(nodeid,tmpNs);
        }
	}
	/**
	 *
	 * @param xmluser xml中用户的相关设置
	 * @param sb
	 */
	private void getUserFromXmlSet(INodeAuthUser xmluser,StringBuilder sb){
		getUserFromXmlSet(sb,xmlNode,xmluser,rd,paraBean,org);
	}

	/**
	 * 从指定节点上获取设置的办理人
	 * @param xmluser
	 * @param xmlNode
	 * @param rd
	 * @param paraBean
	 * @param org
	 * @return
	 */
	public static void getUserFromXmlSet(StringBuilder sb,IFlowNode xmlNode,INodeAuthUser xmluser, RunningData rd, WorkParaBean paraBean, IOrganizationInterface org) {
		if (paraBean == null) {
			paraBean = (WorkParaBean) rd.getWorkParaBean();
		}
		if (org == null) {
			org = PluginsUtil.getMultiInstance().getOrganization(rd.getInitData().getTenantid());
		}
//		1.自定义启用,同时忽略其他设置
		if(xmluser.getCustome_Active()) {
			getUserFromCustom(sb,xmlNode,xmluser,rd,paraBean);
			return;
		}
//		2.1 通过规则获取
		getUserFromScript(sb,xmluser,rd);
//		2.2 获取节点定义人员,
		sb.append(xmluser.getUserFromOrg());

//		2.3 从字段中获取
		getUserFromField(sb,xmluser, paraBean);

//		2.4 获取变量值
		getUserFromVar(sb,xmluser, rd);

//		2.5 相对关系
		getUserFromRelation(sb,xmluser, rd, paraBean, org);
	}

	/**
	 * 从自定义中获取办理人
	 * @param xmluser
	 * @param xmlNode
	 * @param rd
	 * @param paraBean
	 * @return
	 */
	public static void getUserFromCustom(StringBuilder sb,IFlowNode xmlNode,INodeAuthUser xmluser,RunningData rd,WorkParaBean paraBean){
		try{
			IBaseRule br =  InterfaceFactory.getNewInterface(xmluser.getCustome_ClassName());
			br.setParameter(StaticVarExtend.Parameter_WorkParaBean, paraBean);//设置前后台对象到接口
			br.setParameter(StaticVarExtend.Parameter_CustomeUser_Para, xmluser.getCustome());
			br.setParameter(StaticVarExtend.Parameter_CustomeUser_IFlowNode,xmlNode);

			String custome = "";
			br.setRunningData(rd);
			if(br.executeRule()){
				Object obj = br.getResult();
				if(null != obj){
					custome = String.valueOf(obj);
				}
			}
			rd.putMsgToConsole("[msg]custome user:"+custome);
			if(StringUtilExtend.isNotNull(custome)){
				sb.append(custome).append(StaticVarExtend.UserSplitChar);
			}
		}
		catch(Exception e){
			rd.putMsgToConsole("[err]get custome user is error.");
			e.printStackTrace();
		}

	}

	/**
	 * 从规则定义中获取办理人
	 * @param xmluser
	 * @param rd
	 * @return
	 */
	public static void getUserFromScript(StringBuilder sb,INodeAuthUser xmluser,RunningData rd){
		//通过规则获取
		String script = xmluser.getRuleScript();
		try{
			String value = RuleUtil.executeRule(script, rd);
			if(!"".equals(value)){
				sb.append(value).append(StaticVarExtend.UserSplitChar);
			}
		}catch(Exception e){
			e.printStackTrace();
		}
	}

	/**
	 * 从字段中获取办理人
	 * @param xmluser
	 * @param paraBean
	 * @return
	 */
	public static void getUserFromField(StringBuilder sb,INodeAuthUser xmluser,WorkParaBean paraBean){
		String fieldName = xmluser.getFormField();
//		 2.如果指定域有设置取并集后跟1再交并计算,如果没有设置则忽略集合运算
		if (fieldName.length() > 0) {
			String[] fieldNames = fieldName.split(StaticVarExtend.UserSplitChar);
			StringBuilder tmp = new StringBuilder(2000);
			for (int i = 0,n=fieldNames.length; i < n; i++) {
				String tmpFieldValue = String.valueOf(paraBean.getOtherPara().get(fieldNames[i])); // formid.field
				if (!(tmpFieldValue ==null || tmpFieldValue.length()== 0 || "null".equals(tmpFieldValue))) {
					tmp.append(StaticVarExtend.UserSplitChar).append(tmpFieldValue);//李勇20090911修改分割符合为分号
				}
			}
			int fieldReplace = Integer.parseInt(xmluser.getFormFieldUnion());
			gather(fieldReplace,sb,tmp.toString());
		}
	}

	/**
	 * 从流程变量中获取办理人
	 * @param xmluser
	 * @param rd
	 * @return
	 */
	public static void getUserFromVar(StringBuilder sb,INodeAuthUser xmluser,RunningData rd){
		String varStr = xmluser.getFlowVar();
		if (varStr.length() > 0) {
			//注意流程定义中的分隔符号
			String[] arr = varStr.split(";");
			StringBuilder tmp = new StringBuilder(2000);
			Map<String, String> flowVarMap = rd.getInitData().getFlowVarMap();
			for (int i = 0, n = arr.length; i < n; i++) {
				String tmpUser = flowVarMap.get(arr[i]);
				if (!(tmpUser == null || tmpUser.length() == 0)) {
					tmp.append(StaticVarExtend.UserSplitChar).append(tmpUser);
				}
			}
			int fieldReplace = Integer.parseInt(xmluser.getFlowVardUnion());
			gather(fieldReplace,sb,tmp.toString());
		}
	}

	/**
	 * 从相对关系中获取节点的办理人
	 * @param xmluser
	 * @param rd
	 * @param paraBean
	 * @param org
	 * @return
	 */
	public static void getUserFromRelation(StringBuilder sb,INodeAuthUser xmluser,RunningData rd,WorkParaBean paraBean,IOrganizationInterface org){
		if(paraBean == null){
			paraBean =  (WorkParaBean)rd.getWorkParaBean();
		}
		if(org == null){
			org = PluginsUtil.getMultiInstance().getOrganization(rd.getInitData().getTenantid());
		}
		//4.相对关系
		List<IUserRelation> relationList = xmluser.getAllRelations();
		if(CollectionUtil.isListEmpty(relationList)){
			return ;
		}
		int size = relationList.size();
		String[] nodeAuthor = new String[size];//节点办理人
		String[] relations = new String[size];	//关系编号
		int[] fieldReplace = new int[size];	//交并集
		int[] base = new int[size];			//基准0=无,1=指定节点办理人,2=创建者,3=当前执行人curUser
		String[] tarRange	= new String[size];	//目标范围
		//相对节点:	0=无,1=上一节点,Node=指定节点
		//基准:		0=无,1=指定节点办理人,2=创建者
		//相对关系:	0=当前节点历史办理人,10=创建者
		String creator = rd.getCreatorFullName();
		int i=0;
		for(int k=0,m=relationList.size();k<m;k++){
			IUserRelation relation = relationList.get(k);
//			 fieldReplace[i] = 2;//Integer.parseInt(relation.getGatherType());//交并集 1:交集
			int baseTemp = Integer.parseInt(relation.getBase());//0=无,1=指定节点办理人,2=创建者,3=当前执行人curUser
			String baseNode = relation.getBaseNode();//基准节点 : 0=无,1=上一节点 2=指定节点
			String memo = relation.getRelation();

			//baseNode ==0  相对节点为无的时候
			String user = ActionCommon.getInstance().getSingleRelation(rd,sb,baseNode,baseTemp,memo,StaticVarExtend.AUTH_DONE);
			if("".equals(user)){
				continue;
			}
			base[i]=baseTemp;//关系基准
			relations[i]=memo; //关系编号
			nodeAuthor[i]=user;
			tarRange[i]=relation.getTargetRange();//相对岗位
			fieldReplace[i]=2;
			i++;
		}

		if(i==0){
			return ;
		}
		//获取所有关系的人员
		Map<String,Object> para = new HashMap<String,Object>();
		para.put("creator", creator);//
		para.put("done",arrayReduceLength(nodeAuthor,i));

		para.put("relation", arrayReduceLength(relations,i));
		para.put("gathertype", arrayReduceLength(fieldReplace,i));

		para.put("base", arrayReduceLength(base,i));
		para.put("tarRange", arrayReduceLength(tarRange,i));
		para.put("userid", rd.getCurUser().getFullName());

		String temp = org.getRelationUser(para, rd.getInitData().getFlowIdentifier());
		gather(2,sb,temp);

	}

	/**
	 * 从xml中获取参与者，拼接成带有前缀的形式U_user1;D_dept1
	 * @param xmluser
	 * @return
	 */
	private String getUserFromOrg(INodeAuthUser xmluser) {
		return xmluser.getUserFromOrg();
	}
	
	//根据xml定义获取的办理人,创建返回NodeUser
	private NodeUser returnGetUserObjectFormXml(INodeAuthUser xmluser,String setuser,String type){
		if(setuser.trim().length()==0) {
			return null;
		}
		//判断是否跳过当前人,只有办理人才会有此设置
		//20190308 增加跳过指定节点的办理人
		String userid = checkPassUser(xmluser,setuser);
		if(userid.length()==0){
			return null;
		}
		//去掉不存在的参与者id
		//校验组织机构合法性
		if (HZResourceBundle.getInstance().isCheckOrgExist()) {
			// 查看给定字符串是否存在于组织机构中
			String notExitsOrg = org
					.removeNotExitsOrg(userid,getRunningdata().getInitData().getFlowIdentifier());
			if (StringUtilExtend.isNotNull(notExitsOrg)) {
				isExitOrg = false;
				rd.setBackMsg(pubInfo.getInfo("Entry_Msg0006","给定的组织机构id不存在（|orgids|），请联系管理员。").replace("|orgids|", notExitsOrg));
				return null;
			}
		}
		
		//后台默认执行时,获取代理人(比如异常处理时,跳转到某节点)
		boolean isGetAgent = false;
		if(type.equals(StaticVarExtend.AUTH_AUTHOR)){
			String curUser = getRunningdata().getCurUser().getUserid();
			if(curUser.equals(StaticVarExtend.System_Id) 
					//submitflag==0时获取办理人,增加获取代理人
					|| paraBean.getSubmitflag().equals(StaticVarExtend.Submit_Flag_Commit)){
				isGetAgent = true;
			}
		}
		
		NodeUser nodeuser =	createNodeUser(xmluser,type,userid,isGetAgent);
		return nodeuser;
	}
	//检查定义的用户是否为空,是否需要选择
	private NodeUser checkXmlUser(String type,NodeUser user){
		String conAttStr = "";
		if(type.equals(StaticVarExtend.AUTH_AUTHOR)) {
			if(xmlUserAuthor == null){
				return null;
			}
			conAttStr = xmlUserAuthor.getControlAttribute();
		}
		else{
			INodeAuthUser xmlUserReader = xmlNode.getParticipantsUser(type);
			conAttStr = xmlUserReader.getControlAttribute();
		}
		
		if(user == null){
			if(type.equals(StaticVarExtend.AUTH_AUTHOR)){
				//HZDPW-2282,屏蔽了第一个节点的跳过此节点选项
				boolean isFirstNode = rd.isNewDoc()==0;//curNode.getNodetype() < NodeTypeEnum.Node_Single;
				if(isFirstNode){
				    taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
				}
				else if(conAttStr.indexOf(StaticVarExtend.Node_Control_AutoPass) !=-1 ){
					taskNode.setInitResult(StaticVarExtend.F_STATUS_JumpThisNode);
				}
				else if(conAttStr.indexOf(StaticVarExtend.Node_Control_FreeSelect)!=-1){
					taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
				}
				else {
					taskNode.setInitResult(StaticVarExtend.F_STATUS_NoAuthor);
				}
			}
			else{
				//读者和协办在允许自由选择时,设置为选择(如果当前节点为开始节点则忽略)
				if(curNode.getNodetype() <  NodeTypeEnum.Max_Start || !submitflag.equals(StaticVarExtend.Submit_Flag)){
					return null;
				}
				if(conAttStr.indexOf(StaticVarExtend.Node_Control_FreeSelect)!=-1){
				    //2016-08-09 liys
				    //如果主办是跳过或者没有设置办理人时,则不对状态进行重置
				    int taskNodeInitResult = taskNode.getInitResult();
				    if(!(taskNodeInitResult == StaticVarExtend.F_STATUS_NoAuthor 
				            || taskNodeInitResult == StaticVarExtend.F_STATUS_JumpThisNode)){
				        taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
				    }
				}
			}
			return null;
		}
		
		String userid = user.getPlanid();
		int userCounts = CStrUtil.TrimArray(userid.split(StaticVarExtend.UserSplitChar)).length;
		boolean isOnlyUser = (conAttStr.indexOf(StaticVarExtend.Node_Control_IsOnlyUser) !=-1);
		//20181206 liys
		//修改前:只有一个人时,忽略属性判断,前台不需要选择
		//修改后:只要设置了{从设置列表中选择}的属性,就给出选择办理人的返回选项,不论设置了几个人
		if(conAttStr.indexOf(StaticVarExtend.Node_Control_ManualSelect)!=-1){
			taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
			initAuthorMap.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+type, userid);
			return null;
		}
		else if(userCounts >1 && type.equals(StaticVarExtend.AUTH_AUTHOR)
				&& (nodeType == NodeTypeEnum.Node_Single
					|| nodeType == NodeTypeEnum.Node_Merger
					|| nodeType == NodeTypeEnum.Node_Progressively
				   )
				){
				taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
				initAuthorMap.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+type, userid);
				return null;
		}

		if(isOnlyUser){
            //如果选择到人,则判断userid是否为集合类,如果是,则返回选择
            List<AuthUserImpl> tmpLst = AuthUserImpl.getAuthUserList(userid);
            int taskNodeInitResult = taskNode.getInitResult();
            for(int i=0,n=tmpLst.size();i<n;i++){
            	AuthUserImpl tmp = tmpLst.get(i);
                if(tmp.getAuthId().equals(StaticVarExtend.NullStr)){
                	 if(!(taskNodeInitResult == StaticVarExtend.F_STATUS_NoAuthor 
 				            || taskNodeInitResult == StaticVarExtend.F_STATUS_JumpThisNode)){
	                    taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
	                    initAuthorMap.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+type, userid);
	                    return null;
                	}
                }
            }
		}
		return user;
		/*
		if(type.equals(StaticVarExtend.AUTH_AUTHOR)){
			//判断是否为确定办理人
			if( userCounts >1 
					&&(nodeType == NodeTypeEnum.Node_Single 
						|| nodeType == NodeTypeEnum.Node_Merger
						|| nodeType == NodeTypeEnum.Node_Progressively
						|| conAttStr.indexOf(StaticVarExtend.Node_Control_ManualSelect)!=-1)){
					taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
					initAuthorMap.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+type, userid);
					return null;
			}
			return user;
		}
		else{
			if(userCounts >1 && conAttStr.indexOf(StaticVarExtend.Node_Control_ManualSelect)!=-1){
				taskNode.setInitResult(StaticVarExtend.F_STATUS_SelectAuthor);
				initAuthorMap.put(taskNode.getKeyid()+StaticVarExtend.MARK_NODE_USER+type, userid);
				return null;
			}
			else{
			    
				return user;
			}
		}
		//*/
	}
	/**
	 * 结束节点,初始化流程参与者为Reader权限
	 * @param type 
	 */
	private void initEndNodeParticipants(String type, NodeUser user) {
		/*
		IXmlUser xmlUser = node.getParticipantsUser(StaticVarExtend.AUTH_READER);
		if(xmlUser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AllParticipants) >= 0){
			RunningData rd = getRunningdata();
			ActionCommon ac = StaticFunExtend.getActionCommon();
			List<DBWorkAuth> auths = ac.getAllWorkAuthList(rd.getWork().getId(), rd.getInitData().getFlowIdentifier());
			StringBuilder userid = new StringBuilder();
			if(CollectionUtil.isListNotEmpty(auths)){
				for(DBWorkAuth a : auths){
					if(a.getStatus().equals(StaticVarExtend.AUTH_CREADER)){
						continue;//忽略CReader
					}
					String tmpUser = a.getFullNameWithAgent()+StaticVarExtend.UserSplitChar;
					//去掉重复值
					if(userid.indexOf(tmpUser) ==-1){
						userid.append(tmpUser);
					}
				}
			}else{
				userid.append(getRunningdata().getCurUser().getFullName());
			}
			String readers = userid.toString();
			if(null == user){
				user = createNodeUser(xmlUser, type, readers, node);
				backUsers.add(user);			
			}else{
				user.setNowid(user.getNowid()+StaticVarExtend.UserSplitChar+readers);
				user.setPlanid(user.getPlanid() + StaticVarExtend.UserSplitChar+readers);
			}
			String key = node.getNodeid()+StaticVarExtend.MARK_NODE_USER+StaticVarExtend.AUTH_READER;
			initAuthorMap.put(key, user.getNowid());
		}
		//*/
	}
	/**
	 * 获取指定路径下指定nodeid是否在倒数第二个位置,
	 * 如果是,则表示退回节点再次提交给执行退回的节点
	 * @param trackid
	 * @param nodeid
	 * @return -1 表示不是再次提交给执行退回的节点
	 */
	private int getRejectFunNodeNum(String trackid,String nodeid,int pos){
		String nodes = getRunningdata().getNodesOfTrackid(trackid);
		if(StringUtilExtend.isNotNull(nodes)){
			String[] nodesArr = nodes.split(StaticVarExtend.UserSplitChar);
			if(nodesArr.length > pos){
				if(nodeid.equals(nodesArr[nodesArr.length - pos -1])){
					return nodesArr.length - pos -1;
				}
			}
		}
		
		return -1;
	}
	
	/**
	 * 20190308 liys 增加指定节点办理人
	 * 判断当前人(指定节点办理人)是否在指定的办理人列表中,
	 * 用于包含当前人跳过时
	 * @return 去掉当人后的办理人
	 */
	private String checkPassUser(INodeAuthUser xmluser,String authors){
		String checkAttrStr = xmluser.getControlAttribute();
		boolean isPassCurUser =
				checkAttrStr.indexOf(StaticVarExtend.Node_Control_AutoPassCurUser) != -1;
		boolean isPassNodeUser =
				checkAttrStr.indexOf(StaticVarExtend.Node_Control_AutoPassNodeUser) != -1;

		//20200303 LIYS 增加了选择部门时，指定部门负责人/接口人/领导等
		//这个处理需要放在上面执行，因为reader时，不会有跳过的处理
		StringBuilder userS = new StringBuilder(2000);
		List<AuthUserImpl> userlst = AuthUserImpl.getAuthUserList(authors);
		for(int i=0,n=userlst.size();i<n;i++) {
			AuthUserImpl user = userlst.get(i);
			//调用组织机构接口方法去获取对应的人
			if (user.getSubjectionType().length() > 1  // > 1 说明是 设置了 部门负责人/接口人/领导
					&& user.getSubjectionType().startsWith(StaticVarExtend.DeptFix)) { //前缀必须是D开头
				//20231108实现职务接口获取方式
				String deptType=user.getSubjectionType();
				String type="";
				if ("DJ".equals(deptType)){
					type = "I";
				}else if ("DL".equals(deptType)){
					type = "C";
				}else if ("DF".equals(deptType)){
					type = "F";
				}
				String authId = org.getDeptSpecialUser(user.getSubjectionId(),type ,
						rd.getInitData().getFlowIdentifier());
				if (CStrUtil.isNull(authId)) {
					authId = "";
//					System.out.println("=========>subjectId="+user.getSubjectionId());
				}
				user.setAuthId(authId);    //设置AuthId
				user.setSubjectionType(StaticVarExtend.DeptFix); //重置类型，
			}
			userS.append(user._getFullNameNoAgent()).append(StaticVarExtend.UserSplitChar);
		}

		if(!(isPassCurUser || isPassNodeUser)){
			return userS.toString();
		}

		IRunUser curUser = getRunningdata().getCurUser();
		List<AuthUserImpl> nodeusers = null;
		if(isPassNodeUser){
			//如果指定了节点,则需要去获取指定节点的办理人
			String node = xmluser.getNodeForPassNodeUser();
			if(CStrUtil.isNull(node)){
				isPassNodeUser = false;//如果没有指定节点,则标记失效
			}
			else{
				String nodeUser = rd.getNodeAuthor(node, StaticVar.AUTH_AUTHOR);
				nodeusers = AuthUserImpl.getAuthUserList(nodeUser);
			}
		}
		//清理掉原有内容（上面已经重新执行过一次遍历处理）
		userS.delete(0,userS.length());

		for(int i=0,n=userlst.size();i<n;i++){
			AuthUserImpl user = userlst.get(i);
			//去掉当前办理人
			if(isPassCurUser && user.equalsRunUser(curUser)){
				continue;
			}
			if(isPassCurUser && !"Start".equals(curNode.getNodeid()) && curUser.getUserid().equals(user.getAuthId())){
				continue;
			}
			if(isPassNodeUser && isHaveIn(user,nodeusers)){
				continue;
			}
			userS.append(user._getFullNameNoAgent()).append(StaticVarExtend.UserSplitChar);
		}
		return userS.toString();
	}
	private boolean isHaveIn(AuthUserImpl user,List<AuthUserImpl> nodeusers){
		for(int i=0,n=nodeusers.size();i<n;i++){
			if(user.isSameAuth(nodeusers.get(i))){
				return true;
			}
		}
		return  false;
	}
	/**
	 * 缩减数组长度
	 * @param oldArray
	 * @return
	 */
	private static String[] arrayReduceLength(String[] oldArray,int newLength){
		String[] newArray = new String[newLength];
		System.arraycopy(oldArray,0,newArray,0,newLength);  
		return newArray;  
	}
	private static int[] arrayReduceLength(int[] oldArray,int newLength){
		int[] newArray = new int[newLength];
		System.arraycopy(oldArray,0,newArray,0,newLength);  
		return newArray;  
	}
	
	private static void gather(int type,StringBuilder sb,String user){
		if(user.length()==0){
			return;
		}
		sb.append(StaticVarExtend.UserSplitChar);
		sb.append(user);
	}
	private NodeUser createNullNodeUser(){
		NodeUser nUser = new NodeUser();
		return nUser;
	}
	private NodeUser createNodeUser(INodeAuthUser xmluser,String type,String users){
		return createNodeUser(xmluser,type,users,true);
	}
	private NodeUser createNodeUser(INodeAuthUser xmluser,String type,String users,boolean isGetAgent){
		String sUsers = StringUtilExtend.unique(users);
		NodeUser nUser = new NodeUser();
		nUser.setAuthType(type);
		DBWork work = getRunningdata().getWork();
		
		String allcontrol = "";
		if(null != xmluser){
			allcontrol = xmluser.getControlAttribute();
		}
		int nodetype = xmlNode.getNodetype();
		if(isGetAgent && allcontrol.indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
			int pos =  sUsers.indexOf(StaticVarExtend.UserSplitChar);
			if(NodeTypeEnum.Node_Order == nodetype && pos >-1){
				//顺签节点只获取第一个人的代理人
				String aUser = sUsers.substring(0,pos);
				aUser = AgentUtil.getInstance().getAgentUser(aUser, work.getId(), work.getFlowid(), getRunningdata().getInitData().getFlowIdentifier());
				sUsers = aUser+sUsers.substring(pos);
			}
			else{
				sUsers = AgentUtil.getInstance().getAgentUser(sUsers, work.getId(), work.getFlowid(), getRunningdata().getInitData().getFlowIdentifier());
			}
		}
		//节点计划办理人
		nUser.setPlanid(sUsers);
		//多人顺序时取第一个
		String nowid = sUsers;
		if(NodeTypeEnum.Node_Order == nodetype 
				&& type.equals(StaticVarExtend.AUTH_AUTHOR) 
				){
			if(null != nowid && nowid.length() > 0){
				String[] nowids = nowid.split(StaticVarExtend.UserSplitChar);
				nowid = nowids[0];
			}
		}
		//节点当前办理人(在多人顺序执行时,跟planid不一样,此处自行区分)
		nUser.setNowid(nowid);
		
		//发送消息时使用的参数
		//自行获取中文名称
		nUser.setNowname("");
		nUser.setOpenUrl("");
		String sendType = "";
		if(null != xmluser){
			sendType = xmluser.getSendMsgFlag();
		}
		nUser.setSendType(sendType);
		nUser.setTimeLimit("");
		nUser.setLimitType("");
		nUser.setDescription("");
		
		return nUser;
	}	
}
