package com.horizon.wf.rule.defa.core;

import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.node.INodeRouter;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.rule.common.RuleUtil;
/**
 * 路由判断时的扩展规则执行,路径不可修改,引擎内部使用 
 * @author liyong
 *
 */
public class CheckRouterRuleDefault  extends BaseRuleImpl implements IBaseRule {

	public boolean executeRule() {
		RunningData rd = getRunningdata();
		boolean isPass = (Boolean)getParameter(StaticVar.Para_RouterRules_IsPass);
		INodeRouter router = (INodeRouter)getParameter(StaticVar.Para_RouterRules_Router);
		String script = router.getRuleScript(); 
		String className = router.getRuleClassName();
		if(className.length()>0){
			IBaseRule br = InterfaceFactory.getNewInterface(className);
			if(br!=null){
				putMsgToConsole("[Msg]Router rule action");
				br.setParameter(StaticVar.Para_RouterRules_Router, router);
				br.setParameter(StaticVar.Para_RouterRules_IsPass, isPass);
				br.setRunningData(rd);
				isPass = br.executeRule();
			}
		}
		else {
			if(!(null == script || "null".equals(script)||"".equals(script))){
				try{
					isPass  = RuleUtil.executeRuleForRouter(script, rd,isPass);
				}
				catch(Exception e){
					putMsgToConsole("CheckRouterRuleDefault ");
				}
			}
		}
		
		return isPass;
	}
}
