package com.horizon.wf.rule.defa.core;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.global.StaticVarExtend;
/**
 * 用于合并节点进入时是否需要激活的扩展规则执行
 * @author liys
 * 2015-11-17
 */
public class CheckMergerNodeIsActive extends BaseRuleImpl implements IBaseRule {
	
	//返回合并节点是否允许激活
	public boolean executeRule() {
		RunningData rd = getRunningdata();
		boolean isPass = false;
		try{
			WorkParaBean wpb = (WorkParaBean)rd.getWorkParaBean();
			INextNode mergerNode = (INextNode)getParameter("MergerNode");//合并节点对象
			String className = (String)getParameter("ClassName");	//合并激活规则扩展实例类
			IBaseRule br = InterfaceFactory.getNewInterface(className);
			br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);//设置前后台对象到接口
			br.setParameter(StaticVarExtend.Parameter_Current_IFlowNode, rd.getCurFlowNode());//当前节点
			br.setParameter(StaticVarExtend.Parameter_Merger_IFlowNode,mergerNode.getFlowNode());//进入的节点
			
			br.setParameter("AllTrackNum",getParameter("AllTrackNum"));
			br.setParameter("ReachedTrackNum", getParameter("ReachedTrackNum"));
			br.setRunningData(rd);
			isPass = br.executeRule();
		}catch(Exception e){
			
			isPass = false;
		}
		return isPass;
	}

}
