package com.horizon.wf.rule.defa;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.action.base.BaseAction;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.node.INextNode;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.control.INodeButton;
import com.horizon.wf.entity.db.DBLog;
import com.horizon.wf.entity.db.DBTask;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.*;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.DateUtil;

import java.util.*;


public class TrackLogDefault extends BaseRuleImpl implements IBaseRule {
	
	/**
	 * 日志记录规则
	 */
	public boolean executeRule() {
//*
 		RunningData runningdata = getRunningdata();
		//存放sql语句
 		Map<String,List<Object>> saveMap = new LinkedHashMap<String,List<Object>>();
		DBWork work = runningdata.getWork();
		DBTrack track = runningdata.getCurTrack();
		DBLog trackLog = new DBLog();
		trackLog.setActiontime(DateUtil.getNow());	//操作时间
		trackLog.setFlowid(work.getFlowid());		//流程id
		trackLog.setFlowname(work.getFlowname());	//流程name
		trackLog.setId(StaticFunExtend.getUnid());
		trackLog.setWorkid(work.getId());
		trackLog.setIsover("0");
		trackLog.setMemo("");
		//20200421 LIYS 增加一个返回值，用于在不保存数据的时候，转换JSON'对象使用
		setResult("DBLog",trackLog);

		String funname = runningdata.getFunname();
		PubInfo pubInfo = PubInfo.getPubInfo(runningdata.getLangInfo());
		if(track == null){//保存实例xml时记录日志
			saveLogWhenTrackNull(trackLog,pubInfo,saveMap);
			return true;
		}
		
		trackLog.setAction(funname);	//操作名称
		trackLog.setTitle(runningdata.getTitle());
		trackLog.setTrackid(track.getId());
		Object obj = runningdata.getWorkParaBean();
		WorkParaBean paraBean = null;
		try{
			paraBean = (WorkParaBean)obj;
		}
		catch(Exception e){
			
		}
		if(obj!=null){
			String nodeid = runningdata.getCurTaskNode().getNodeid();
			StringBuilder nextNodeIds = new StringBuilder("");
			//获取下一节点,多个用分号隔开，存入表中
			List<INextNode> nextNodes = runningdata.getCurTaskNode().getGNextNodes();
			if(null != nextNodes){
				for(int i=0,n=nextNodes.size();i<n;i++){
					INextNode node = nextNodes.get(i);
					nextNodeIds.append(node.getNodeid()).append(StaticVarExtend.StrSplitChar);
				}
			}else{
				nextNodeIds.append(nodeid).append(StaticVarExtend.StrSplitChar);
			}
			trackLog.setNextnodeids(nextNodeIds.toString());
			
			//内部循环,多人顺序执行时的办理时间怎么算呢?
			String actionname = paraBean.getActionname();
			//计算办理时长
			String nowtime  = DateUtilExtend.getNow();

			//办理时长
			String receivetime = nowtime; //接收时间默认当前
			//顺签或者内部循环节点
			//只有办理人时需要从待办获取
			if(runningdata.getCurUser().getUserid().equals(StaticVarExtend.System_Id)){
				//如果userid = HZWFSYSTEM,说明是系统自动操作,此时只计算跟最后一次执行的差值
				receivetime = getLastLogTime();
			}
			else if(runningdata.getCurUser().getAuthName().equals(StaticVarExtend.AUTH_AUTHOR)){
				//认领时不需要从待办获取,此时还木有对应的待办
				if(runningdata.getFunname().equals(StaticVarExtend.OPERATOR_FUNNAME_CLAIM)) {
					//计算认领发送和认领的差值
					receivetime = getClaimTime();
				}
				else{
					if(work.getVersion() > 0) {
						receivetime = getStartTimeForOrder();
					}
					DBTask task = getNodeTask(track.getWorkid(), track.getId(), nodeid, runningdata.getInitData().getFlowIdentifier());
					if(null != task){
						//节点办理期限
						int limitdate = task.getNodelimitdate()==0?task.getFlowlimitdate():task.getNodelimitdate();
						if(limitdate != 0){
							String limittype = getLimitTypeStr(pubInfo,task);
							trackLog.setLimittime(String.valueOf(limitdate) + limittype);
						}
						else{
							trackLog.setLimittime("");
						}
						Date nowDate = DateUtilExtend.getNowDate();
						//判断是否已经超期
						boolean isOver = DateUtilExtend.isAfter(nowDate,DateUtilExtend.getDateTime(task.getFlowlimittime()));
						if(!isOver){
							isOver = DateUtilExtend.isAfter(nowDate,DateUtilExtend.getDateTime(task.getNodelimittime()));
						}
						trackLog.setIsover(isOver?"1":"0");
					}
				}
			}

			if(receivetime.equals("")){
				receivetime = nowtime;
			}
			trackLog.setDotime(getDoTimeStr(receivetime, nowtime));
			trackLog.setDotimemin(DateUtilExtend.getTimeDifferenceMin(receivetime, nowtime));

			//正常操作需要的
			trackLog.setNodeid(nodeid);
			trackLog.setNodename(runningdata.getCurTaskNode().getNodename());
			trackLog.setUserid(runningdata.getCurUser().getUserid());
			trackLog.setUsername(runningdata.getCurUser().getUsername());
			trackLog.setSxcomments(paraBean.getSxComment());//手写意见id
			trackLog.setComments(paraBean.getComment());//流程意见
			trackLog.setMemo(paraBean.getMemo());
			
			
			if(StringUtilExtend.isNull(actionname)){
				actionname = saveLogForActionname(actionname,funname,paraBean.getFunname());
			}
			trackLog.setActionname(actionname);
		}
		else
		{
			saveLogWhenSystem(trackLog,pubInfo,track);
		}
		
		
		trackLog.getSQL(saveMap);
		setResult("CurNodeExtends","1".equals(trackLog.getIsover()));//是否超期
		if(!saveMap.isEmpty()){
			//把结果放入接口
			setResult(saveMap);
		}

//*/		
		return true;
	}
	private void saveLogWhenTrackNull(DBLog trackLog,PubInfo pubInfo,Map<String,List<Object>> saveMap){
		String funname = getRunningdata().getFunname();
		trackLog.setAction(funname);
		trackLog.setTrackid("");
		trackLog.setTitle(getRunningdata().getWork().getTitle());

		trackLog.setNodeid("");
		trackLog.setNodename("");

		trackLog.setUserid(StaticVarExtend.Manager_Log_Userid);
		trackLog.setUsername(pubInfo.getInfo("Manager_Log_Username","系统管理员"));
		trackLog.setSxcomments("");//手写意见id
		trackLog.setLimittime("");
		trackLog.setComments("");//流程意见
		if(funname.equals("UpdatesInstanceXml")){
			trackLog.setActionname(pubInfo.getInfo("Xml_Msg0001","更新实例的流程定义数据"));
		}
		else{
			trackLog.setActionname(pubInfo.getInfo("Xml_Msg0002","修改实例的流程定义数据"));
		}

		trackLog.setDotime("");
		trackLog.setDotimemin("0");
		trackLog.getSQL(saveMap);
		if(!saveMap.isEmpty()){
			//把结果放入接口
			setResult(saveMap);
		}
	}
	private void saveLogWhenSystem(DBLog trackLog,PubInfo pubInfo,DBTrack track){
		trackLog.setNodeid(track.getNodeid());
		trackLog.setNodename(track.getNodename());
		trackLog.setUserid(StaticVarExtend.Manager_Log_Userid);
		trackLog.setUsername(pubInfo.getInfo("Manager_Log_Username","系统管理员"));
		trackLog.setSxcomments("");//手写意见id
		trackLog.setLimittime("0");
		trackLog.setComments("");//流程意见
		trackLog.setActionname("");
		trackLog.setDotime(getDoTimeStr(DateUtilExtend.getNow(), DateUtilExtend.getNow()));
		trackLog.setDotimemin("0");
	}
	private String saveLogForActionname(String actionname,String funname,String funname1){
		//20151019 liys 传入的funname和实际操作的funname可能会不一致
		//为保证能获取到对应的操作名称,此处修改为按前台传入的值获取
//		String funname1 = paraBean.getFunname();
		IFlowNode node = getRunningdata().getCurFlowNode();
		if(null != node){
			String nodeAuths = getRunningdata().getCurUser().getCurNodeAuths();
			if(StringUtilExtend.isNotNull(nodeAuths)){
				String[] auths = nodeAuths.split(StaticVarExtend.StrSplitChar);
				auths = StringUtilExtend.unique(auths);
				for(String a : auths){
					if(a.indexOf(StaticVarExtend.AUTH_AUTHOR) > 0 && !a.equals(StaticVarExtend.AUTH_SECOND_AUTHOR)){
						a = StaticVarExtend.AUTH_AUTHOR;
					}
					else if(a.equals(StaticVarExtend.AUTH_READED)){
						a = StaticVarExtend.AUTH_READER;
					}
					INodeControl control = node.getParticipantsControl(a+"_DO");
					if(null != control){
						List<INodeButton> btns = control.getButton();
						if(CollectionUtil.isListNotEmpty(btns)){
							for(int i=0,n=btns.size();i<n;i++){
								INodeButton btn = btns.get(i);
								if(btn.getButtonId().equalsIgnoreCase(funname1)
										|| btn.getButtonId().equalsIgnoreCase(funname)){
									actionname = btn.getButtonReName();
									if(StringUtilExtend.isNull(actionname)){
										actionname = btn.getButtonName();
										break;
									}
								}
							}
						}
					}
				}
			}
		}
		return actionname;
	}

	/**
	 * 获取节点的任务日志
	 * @param workid
	 * @param trackid
	 * @param nodeid
	 * @param identifier
	 * @return
	 */
	private DBTask getNodeTask(String workid, String trackid, String nodeid, String identifier){
		getRunningdata().putMsgToConsole("[IO]getNodeTask...Start");

		DBTask task = DBTask.getTaskByTrackid(getRunningdata().getResultJson(),trackid,  identifier);
		
		getRunningdata().putMsgToConsole("[IO]getNodeTask...End");
		return task;
	}

	/**
	 * 获取跟当前节点相关的最后一次执行时间
	 * @return
	 */
	private String getLastLogTime(){
		String sql = "SELECT ACTIONTIME FROM " +StaticVarExtend.Table_Log
				+" WHERE NEXTNODEIDS LIKE ? AND WORKID=? ORDER BY ACTIONTIME DESC  ";
		List<Object> para = new ArrayList<Object>();
		para.add("%"+getRunningdata().getCurTrack().getNodeid()+";%");
		para.add(getRunningdata().getWork().getId());

		getRunningdata().putMsgToConsole("[IO]getLastLogTime...Start");
		List<List<Object>> result = AccessUtil.getInstance()
				.getMultiList(sql, para, getRunningdata().getInitData().getFlowIdentifier());
		getRunningdata().putMsgToConsole("[IO]getLastLogTime...End");
		if(result == null || result.size()==0){
			return "";
		}
		String startTime = (String)result.get(0).get(0);
		return startTime;
	}

	/**
	 * 获取认领任务到达时间
	 * @return
	 */
	private String getClaimTime(){
		JSONObject json = getRunningdata().getResultJson();
		if(json == null){
			return getClaimTime_DB();
		}
		return getClaimTime_JSON(json);
	}
	private String getClaimTime_DB(){
		String sql = "SELECT SENDTIME FROM "+StaticVarExtend.Table_Work_List
		+" WHERE TRACKID=? AND NODEID=? AND AUTH_ID=? AND SUBJECTION_ID=? AND STATUS=? ORDER BY SENDTIME DESC";
		List<Object> para = new ArrayList<Object>();
		para.add(getRunningdata().getCurTrack().getId());
		para.add(getRunningdata().getCurTaskNode().getNodeid());
		para.add(StaticVarExtend.NullStr);
		para.add(getRunningdata().getCurUser().getSubjectionid());
		para.add(StaticVarExtend.AUTH_AUTHOR);

		getRunningdata().putMsgToConsole("[IO]getClaimTime_DB...Start");
		List<List<Object>> result = AccessUtil.getInstance()
				.getMultiList(sql, para, getRunningdata().getInitData().getFlowIdentifier());
		getRunningdata().putMsgToConsole("[IO]getClaimTime_DB...End");
		if(result == null || result.size()==0){
			return "";
		}
		String startTime = (String)result.get(0).get(0);
		return startTime;
	}
	private String getClaimTime_JSON(JSONObject json){
		JSONArray jsonArr = json.getJSONArray("DBTodo");
		if(jsonArr == null){
			return getClaimTime_DB();
		}
		String trackid = getRunningdata().getCurTrack().getId();
		String nodeid	= getRunningdata().getCurTaskNode().getNodeid();
		IRunUser user = getRunningdata().getCurUser();

		String subjectionid = user.getSubjectionid();
		String startTime = "";
		for(int i=0,n= jsonArr.size();i<n;i++){
			JSONObject tmpObj = jsonArr.getJSONObject(i);
			if(trackid.equals(tmpObj.getString("trackid"))
					&& nodeid.equals(tmpObj.getString("nodeid"))
					&& StaticVarExtend.AUTH_AUTHOR.equals(tmpObj.getString("status"))
					&& StaticVarExtend.NullStr.equals(tmpObj.getString("authId"))
					&& subjectionid.equals(tmpObj.getString("subjectionId"))
					){
				startTime = tmpObj.getString("sendtime");
			}
		}
		return startTime;
	}


	/**
	 * 获取办理人待办接收时间
	 */
	private String getStartTimeForOrder(){
		JSONObject json = getRunningdata().getResultJson();
		if(json == null){
			return getStartTimeForOrder_DB();
		}
		return getStartTimeForOrder_JSON(json);
	}
	private String getStartTimeForOrder_JSON(JSONObject json){
		JSONArray jsonArr = json.getJSONArray("DBTodo");
		if(jsonArr == null){
			return getStartTimeForOrder_DB();
		}
		String trackid = getRunningdata().getCurTrack().getId();
		String nodeid	= getRunningdata().getCurTaskNode().getNodeid();
		IRunUser user = getRunningdata().getCurUser();
		String userid = user.getUserid();
		if(!(user.getAgentUser() == null || "".equals(user.getAgentUser()))){
			userid = user.getAgentUser();
		}
		String subjectionid = user.getSubjectionid();
		String startTime = "";
		for(int i=0,n= jsonArr.size();i<n;i++){
			JSONObject tmpObj = jsonArr.getJSONObject(i);
			if(trackid.equals(tmpObj.getString("trackid"))
					&& nodeid.equals(tmpObj.getString("nodeid"))
					&& userid.equals(tmpObj.getString("authId"))
					&& StaticVarExtend.AUTH_AUTHOR.equals(tmpObj.getString("status"))
					){
				startTime = tmpObj.getString("sendtime");
				if(subjectionid.equals(tmpObj.getString("subjectionId"))){
					return startTime;
				}
			}
		}
		return startTime;
	}
	private String getStartTimeForOrder_DB(){
		String sql = "SELECT SENDTIME,SUBJECTION_ID FROM "+StaticVarExtend.Table_Work_List
				+" WHERE TRACKID=? AND NODEID=? AND AUTH_ID=? AND STATUS=? ORDER BY SENDTIME DESC";

		String identifier = getRunningdata().getInitData().getFlowIdentifier();
		IRunUser user = getRunningdata().getCurUser();
		String agentUser = user.getAgentUser();

		List<Object> conditionList = new ArrayList<Object>();
		conditionList.add(getRunningdata().getCurTrack().getId());
		conditionList.add(getRunningdata().getCurTaskNode().getNodeid());
		if(agentUser == null || "".equals(agentUser)){
			conditionList.add(user.getUserid());
		}
		else{
			conditionList.add(agentUser);
		}
		conditionList.add(StaticVarExtend.AUTH_AUTHOR);
		getRunningdata().putMsgToConsole("[IO]getStartTimeForOrder...Start");
		List<List<Object>> result = AccessUtil.getInstance().getMultiList(sql, conditionList, identifier);
		getRunningdata().putMsgToConsole("[IO]getStartTimeForOrder...End");
		if(result.size() >1){
			String subjectionid = user.getSubjectionid();
			for(int i=0,n=result.size();i<n;i++){
				List<Object> lst = result.get(i);
				if(lst.get(1).equals(subjectionid)){
					return (String)lst.get(0);
				}
			}
		}
		if(result.size()==0){
			return "";
		}

		String startTime = (String)result.get(0).get(0);
		return startTime;
	}
	
	/**
	 * 办理期限单位转换,需要项目自行根据配置信息修改
	 * flowconfig.xml中配置的单位
	 * <LimitTypes>
     *  <LimitType data="0">工作日</LimitType>
     *  <LimitType data="1">自然天</LimitType>
     *  <LimitType data="2">小时</LimitType>
     *  <LimitType data="3">分钟</LimitType>
     * </LimitTypes>
	 * @param task
	 * @return
	 */
	private String getLimitTypeStr(PubInfo pubInfo,DBTask task){
	    String type = task.getNodelimitdate()==0?task.getFlowlimittype():task.getNodelimittype();
	    
	    return BaseAction.chgLimitType(pubInfo,type);
	}
	/**
	 * 获取给定两个日期之间的时间
	 * @param date1
	 * @param date2
	 * @return x 天 x 时 x 分
	 */
	private String getDoTimeStr(String date1,String date2){
	    return DateUtilExtend.getSubtractDHM(date1,date2);
	}
	
}
