package com.horizon.wf.rule.defa;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.definition.pub.IFlowInfo;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.plugins.PluginsUtil;

public class StartRuleDefault extends BaseRuleImpl implements IBaseRule {
	/**
	 * 流程启动校验默认规则
	 * 返回是否具有权限
	 * 默认参与者分类:
	 * 	创建者/办理人/协办人/当前节点已办理人/上一节点办理人/已办理人/管理者/读者/已阅者/
	 *  Creator,Author,SecondAuthor,CurDone,PreDone,Done,Manager,Reader,Readed
	 */
	public boolean executeRule(){
		IRunUser userObj 		= (IRunUser)getParameter(StaticVarExtend.Para_StartRules_RunUser);
		IFlowInfo flowInfo 	= (IFlowInfo)getParameter(StaticVarExtend.Para_StartRules_IXmlFlowInfo);
		
//		IXmlNode curnode = flowInfo.getNodeById(StaticVarExtend.Start_Node_Id);
				
		//从接口中获取是否有启动权限
		String flowid = flowInfo.getFlowid();
		String userid = userObj.getUserid();
		getRunningdata().putMsgToConsole("[Msg]AdapterFactory.getAuthority.....Start");
		boolean isStart = PluginsUtil.getMultiInstance().getAuthority(getRunningdata().getInitData().getTenantid()).isStart(flowid, userid);
		getRunningdata().putMsgToConsole("[Msg]AdapterFactory.getAuthority.....End");
		if(isStart){
			return returnStr(userObj,null);
		}
		
		return isStart;
	}
	/**
	 * 默认第一个
	 * @param userObj
	 * @return
	 */
	private boolean returnStr(IRunUser userObj,String curNodeAuths){
		String startParticipants = StaticVarExtend.AUTH_AUTHOR;
		String startParticipantsName = StaticVarExtend.AUTH_AUTHOR+"_DO";		
		//指定权限控制节点名称
		userObj.setControlNodeName(startParticipantsName);
		//指定当前人的权限
		userObj.setAuthName(startParticipants);
		
		if(StringUtilExtend.isNotNull(curNodeAuths)){
			startParticipants += "|"+ curNodeAuths;
		}
		userObj.setCurNodeAuths(startParticipants);
		userObj.setPreNodeAuthsOnCurTrack("");
		userObj.setLastNodeAuthsOnPreTrack("");
		userObj.setOtherNodeAuths("");
		return true;
	}



}
