package com.horizon.wf.rule.defa;

import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.track.json.bean.TrackFormJsonImpl;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.info.IFlowForm;
import com.horizon.wf.definition.pub.node.INodeControl;
import com.horizon.wf.definition.pub.node.INodeForm;
import com.horizon.wf.entity.db.DBRelation;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
/**
 * 业务数据跟流程数据关联规则实现
 * @author liyong
 *
 */
public class RelationRuleDefault extends BaseRuleImpl implements IBaseRule{

	public boolean executeRule() {
		RunningData runningdata = getRunningdata();
		putMsgToConsole("[Msg]The beginning of the application data processing");
		String[] formID = runningdata.getInitData().getFormids();
		if(CollectionUtil.isStringArrayEmpty(formID) || formID[0].length()==0){
			putMsgToConsole("[Msg]formID is null.");
		    return true;
		}
		
		IFlowNode curNode = runningdata.getCurFlowNode();
		INodeControl control = curNode.getParticipantsControl(runningdata.getCurUser().getControlNodeName());
		
		Map<String,List<Object>> saveMap = new LinkedHashMap<String,List<Object>>();
		
		for(int i=0,n=formID.length; i < n ; i++) {
			if(formID[i].trim().length()==0){
				putMsgToConsole("[Msg]formID["+i+"] is null.");
				continue;
			}
			
			if("FlowTrack".equals(formID[i].trim())){
				continue;
			}
			
			//节点属性中的表单对象
			INodeForm nodeForm = control.getNodeForm(formID[i]);
			if(nodeForm == null){
				putMsgToConsole("[Msg]formID["+i+"] object is null.");
				continue;
			}
			//流程属性中定义的表单对象
			IFlowForm flowForm = runningdata.getInstanceDefinition().getFlowinfo().getFlowForm(formID[i]);
			String group = flowForm.getFormgroup();
			String formType = flowForm.getFormtype();
			runningdata.putValueToHashMap(formID[i]+"_FormType",formType);
			putMsgToConsole("[Msg]FormID:type="+formID[i]+":"+formType);
			
			//路径XML中记录表单业务数据id的对象
			TrackFormJsonImpl trackForm = runningdata.getTrackFormInfo();
		
			if("HTML".equals(formType)){
				trackForm.setHtmlByFormid(formID[i], runningdata.getValueFromHashMap(formID[i]));
				continue;
			}
			//库表名称处理
			String tableID = runningdata.getValueFromHashMap(formID[i]+"_TABLENAME");
			if(StringUtilExtend.isNull(tableID)){
				tableID = trackForm.getTableidByFormid(formID[i]);
				if(StringUtilExtend.isNull(tableID)){
					tableID = flowForm.getTableid();
					if(StringUtilExtend.isNull(tableID)){
						putMsgToConsole("[Msg]Table name has not been:"+formID[i]+"_tablename");
						//20180328 liys 表单入口统一后,对应的表名不做校验
//						return false;
					}
				}
				runningdata.putValueToHashMap(formID[i]+"_TABLENAME", tableID);
			}
			
			//流程引擎不在对业务数据是否存在进行判断20111208
			String dataID = runningdata.getValueFromHashMap(formID[i]+"_ID");
			runningdata.putMsgToConsole("[Msg]dataid(from map data)="+dataID);
			if(StringUtilExtend.isNull(dataID)) {
				dataID = trackForm.getDataidByFormid(formID[i]);
				putMsgToConsole("[Msg]dataid(form xml)="+dataID);
			}
			
			if(StringUtilExtend.isNull(dataID)) {
				dataID = StaticFunExtend.getUnid(); 
				runningdata.putValueToHashMap(dataID+"_IsNewDoc", "1"); //标记数据为新创建
				putMsgToConsole("[Msg]dataid(new data id)="+dataID);
			}
			//关联数据写入库表中
			DBRelation	xdWorkApp = new DBRelation();
			xdWorkApp.setId(StaticFunExtend.getUnid());
			xdWorkApp.setDataid(dataID);
			xdWorkApp.setFormid(formID[i]);
			xdWorkApp.setTableid(tableID);
			xdWorkApp.setWorkid(runningdata.getInitData().getWorkid());
			xdWorkApp.getSQL(saveMap,runningdata.getResultJson());
			//关联数据写入XML中
			trackForm.setDataidAndTableidByFormid(formID[i], dataID, tableID);
			runningdata.putValueToHashMap(formID[i]+"_ID", dataID);
			//考虑分组情况下的处理20141124
			if(!"".equals(group)){
				//多数情况下是没有分组的情况.如果分组比较多,考虑性能可以放到上面
				List<IFlowForm> lstForms = runningdata.getInstanceDefinition().getFlowinfo().getAllFlowForms();
				for(int j=0,m=lstForms.size();j<m;j++){
					IFlowForm f = lstForms.get(j);
					if(f.getFormid().equals(formID[i])){
						continue;
					}
					if(f.getFormgroup().equals(group)){
						DBRelation	rApp = new DBRelation();
						rApp.setId(StaticFunExtend.getUnid());
						rApp.setDataid(dataID);
						rApp.setFormid(f.getFormid());
						rApp.setTableid(tableID);
						rApp.setWorkid(runningdata.getInitData().getWorkid());
						rApp.getSQL(saveMap,runningdata.getResultJson());
						
						trackForm.setDataidAndTableidByFormid(f.getFormid(), dataID, tableID);
					}
				}
			}
		}
		if(!saveMap.isEmpty()){
			//把结果放入接口
			setResult(saveMap);
		}
		putMsgToConsole("[Msg]The end of the application data processing");
		
		runningdata.putValueToHashMap("USERID",runningdata.getInitData().getUserid());
		runningdata.putValueToHashMap("DATAIDENTIFIER", runningdata.getInitData().getDataIdentifier());
		
		return true;
	}

}
