package com.horizon.wf.rule.defa;

import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.rule.common.RuleUtil;
import com.horizon.wf.tools.CStrUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * 实例打开时,获取当前人权限
 * 引擎内部调用
 * @author liys
 *
 */
public class CheckRoleForOpenInstanceDefault extends BaseRuleImpl implements IBaseRule {
	private StringBuilder curNodeAuths 				= new StringBuilder(200);
	private StringBuilder preNodeAuthsOnCurTrack 	= new StringBuilder(200);
	private String preNodeidOnCurTrack="";			//上一节点id
	private StringBuilder lastNodeAuthsOnPreTrack 	= new StringBuilder(200);
	private String lastNodeidOnPreTrack="";			//上一路径的最后一个节点id
	private StringBuilder otherNodeAuths 			= new StringBuilder(200);
	List<String> participants = null;
	List<String> participantsName = null;
	int curNodesLen = 0;
	IRunUser userObj ;
	IOrganizationInterface org;
	private List<DBWorkAuth> tmpOtherDB = new ArrayList<DBWorkAuth>();
	private List<DBWorkAuth> readerDB = new ArrayList<DBWorkAuth>();//记录Reader和Readed权限,用于判断到底是Reader还是Readed
	private List<DBWorkAuth> readedDB = new ArrayList<DBWorkAuth>();
	public boolean executeRule(){
		userObj 	= (IRunUser)getParameter(StaticVarExtend.Para_CheckRoleForOpenRules_RunUser);
		if(userObj.getUserid().equals(StaticVarExtend.System_Id)	//系统后台服务执行时,按照Author权限执行
				|| getRunningdata().isNewDoc() ==0){				//新建实例时,按照Author权限执行
			userObj.setAuthName(StaticVarExtend.AUTH_AUTHOR);
			userObj.setControlNodeName(StaticVarExtend.AUTH_AUTHOR+"_DO");
			userObj.setCurNodeAuths(StaticVarExtend.AUTH_AUTHOR);
			return true;
		}
		org = PluginsUtil.getMultiInstance().getOrganization(getRunningdata().getInitData().getTenantid());
		String[] tracks 	= (String[])getParameter(StaticVarExtend.Para_CheckRoleForOpenRules_Trackids);
		String[] curNodes 	= (String[])getParameter(StaticVarExtend.Para_CheckRoleForOpenRules_AllNodes);
		String preTrack =  (String)getParameter(StaticVarExtend.Para_CheckRoleForOpenRules_PreTrack);
		@SuppressWarnings("unchecked")
		Map<String,List<DBWorkAuth>> auths = (HashMap<String,List<DBWorkAuth>>)getParameter(StaticVarExtend.Para_CheckRoleForOpenRules_Auths);
		
		if(CollectionUtil.isStringArrayEmpty(tracks)) {
			return false;
		}
		if(CollectionUtil.isStringArrayEmpty(curNodes)) {
			return false;
		}
		
		curNodesLen = curNodes.length;
		participants = RuleUtil.getParticipants(getRunningdata());//ConfigUtil.getInstance().getConfig().getParticipants();
		participantsName = RuleUtil.getParticipantsName(getRunningdata());//ConfigUtil.getInstance().getConfig().getParticipantsName();
		
		IFlowNode curNode = getRunningdata().getCurFlowNode();
		if(null == curNode){
			return false;
		}
		int curPos = participants.size();

		//先获取当前路径下的所有参与者信息
		List<DBWorkAuth> list = new ArrayList<DBWorkAuth>(); 
		//结束节点
		boolean isEndNode = ActionCommon.getInstance().isEndNode(curNode.getNodetype());
		if(isEndNode){
			List<DBWorkAuth> allAuths = (List<DBWorkAuth>)getParameter(StaticVarExtend.Para_CheckRoleForOpenRules_AllAuths);
			list.addAll(allAuths);
//			list.addAll(getRunningdata().getAllAuthListForEndNode());
		}else{
			DBTrack curTrack = getRunningdata().getCurTrack();
			//结束状态,且未激活状态
			if(StaticVarExtend.FlowStatus_End == curTrack.getFlowstatus() && 0 == curTrack.getActive()){
				curNodeAuths.append(StaticVarExtend.AUTH_READER).append(StaticVarExtend.StrSplitChar);
				curPos= getRolePos(participants,StaticVarExtend.AUTH_READER,curPos);
			}else{
				list = auths.get(curTrack.getId()); //获取当前Track下的所有权限
				
				//20160218 liys 增加判断当前是否只有当前人具有Author权限
				checkIsOnlyIHaveAuthor(list);
			}
		}
		
		List<DBWorkAuth> tmpCur = new ArrayList<DBWorkAuth>();
		if(!(list == null || list.isEmpty())){
		    //首先确定列表中是否有跟当前人具有相同的权限,
		    for(int i=0,n=list.size();i<n;i++){
		    	DBWorkAuth xAuth=list.get(i);
		        if(xAuth.equalsRunUser(userObj)){
		            curPos = doCurTrackClassify(curPos,xAuth,tmpCur,false);
		        }
				//   使用userid~agentid判断                或    使用subjectionid判断[Authid为空时]
				if(isRoleByAuthId(xAuth) ){
					curPos = doCurTrackClassify(curPos,xAuth,tmpCur,true);
				}
				else if(isRoleBySubjectid(xAuth)){
					curPos = doCurTrackClassify(curPos,xAuth,tmpCur,false);
				}
		    }
		    /*if(tmpCur.isEmpty()){
		    	for(int i=0,n=list.size();i<n;i++){
			    	DBWorkAuth xAuth=list.get(i);
    				//   使用userid~agentid判断                或    使用subjectionid判断[Authid为空时]
    				if(isRoleByAuthId(xAuth) ){
    					curPos = doCurTrackClassify(curPos,xAuth,tmpCur,true);
    				}
    				else if(isRoleBySubjectid(xAuth)){
						curPos = doCurTrackClassify(curPos,xAuth,tmpCur,false);
					}
    			}
		    }*/
		}
		//获取上一路径的信息
		if(curNodesLen == 1){ //当前分支刚开始时,或者合并打开时
			doNotCurTrackClassifyForOnlyOneCurNode(tracks,preTrack,auths);
		}
		else{
			//当前路径多于一个节点时,其他路径都归类为otherNodeAuths
			doNotCurTrackClassifyForMultiNode(tracks,auths);
		}
		
		//管理员判断权限
		doFlowManger();
		
		userObj.setCurNodeAuths(CStrUtil.unique(curNodeAuths.toString(),StaticVarExtend.StrSplitChar));
		userObj.setPreNodeAuthsOnCurTrack(CStrUtil.unique(preNodeAuthsOnCurTrack.toString(),StaticVarExtend.StrSplitChar));
		userObj.setLastNodeAuthsOnPreTrack(CStrUtil.unique(lastNodeAuthsOnPreTrack.toString(),StaticVarExtend.StrSplitChar));
		userObj.setOtherNodeAuths(CStrUtil.unique(otherNodeAuths.toString(),StaticVarExtend.StrSplitChar));
		
		userObj.setPreNodeidOnCurTrack(preNodeidOnCurTrack);		
		userObj.setLastNodeidOnPreTrack(lastNodeidOnPreTrack);
		
		//获取最高权限的坐标
		curPos = getCurPos(curPos);
		
		//获取一个最高权限,用来判断具体使用那个节点的控制信息
		if(curPos == participants.size()){//无任何权限
			return false;
		}
		//
		if(isEndNode){
			if(userObj.isManager()){
				curPos =  getRolePos(participants,StaticVarExtend.AUTH_MANAGER,participants.size());
			}
			else{
				curPos =  getRolePos(participants,StaticVarExtend.AUTH_READER,participants.size());
			}
		}
		
		
		String curAuth = participants.get(curPos);
		
		if(!tmpCur.isEmpty()){
			DBWorkAuth singleAuth = null;
			DBWorkAuth userAuth = null;
			DBWorkAuth tmpAuth = null;
			for(int i=0,n=tmpCur.size();i<n;i++){
		    	DBWorkAuth xAuth=tmpCur.get(i);	
				if(xAuth.getStatus().startsWith(curAuth)){
					if(xAuth.equalsRunUser(userObj)){
						userAuth = xAuth;
					}
					else{
						tmpAuth = xAuth;
						if(xAuth.getSubjectionId().equalsIgnoreCase(userObj.getSubjectionid())){
							singleAuth = xAuth;
						}
					}
				}
			}
			if(userAuth != null){
				return returnCheck(curAuth,participantsName.get(curPos),userAuth);
			}
			if(singleAuth != null){
				return returnCheck(curAuth,participantsName.get(curPos),singleAuth);
			}
			if(tmpAuth != null){
				return returnCheck(curAuth,participantsName.get(curPos),tmpAuth);
			}
		}
		String allAuth = userObj.getCurNodeAuths();
		if(allAuth.length()>0){
			for(int i=0,n=tmpOtherDB.size();i<n;i++){
				DBWorkAuth xAuth = tmpOtherDB.get(i);
				if(xAuth.getStatus().startsWith(curAuth)){
					return returnCheck(curAuth,participantsName.get(curPos),xAuth);
				}
			}
			//管理员权限 
			return returnCheck(participants.get(curPos),participantsName.get(curPos));
		}
		
		
		return false;
	}
	private void checkIsOnlyIHaveAuthor(List<DBWorkAuth> list){
		if(list == null || list.isEmpty()){
			return ;
		}
		int authorNum =0;
		for(int i=0,n=list.size();i<n;i++){
	    	DBWorkAuth auth=list.get(i);
			if(StaticVarExtend.AUTH_AUTHOR.equals(auth.getStatus())){
				authorNum ++;
			}
		}
		userObj.setCurAuthorNum(authorNum);
	}
	/**
	 * 设置权限到当前用户对象中
	 * @param auth
	 * @param control
	 * @return
	 */
	private boolean returnCheck(String auth,String control,DBWorkAuth xAuth){
		if(auth.indexOf(StaticVarExtend.AUTH_AUTHOR)!=-1 && 
				(xAuth.getAuthId().equals(StaticVarExtend.NullStr))){
			//需要认领的情况
			userObj.setAuthObjId(xAuth.getId());
			userObj.setRdyClaim(true);
		}
		
		userObj.setIsClaim(xAuth.getIsclaim());
		userObj.setAuthName(auth);
		userObj.setControlNodeName(control);
		//如果当前人id为agentid,说明是代办人
		if(xAuth.getAgentId().equals(userObj.getUserid())){
			userObj.setAgentUser(xAuth.getAuthId());
		}
		
		
		if(StaticVarExtend.NullStr.equals(userObj.getSubjectionid())){
			userObj.setSubjectionid(xAuth.getSubjectionId());
			userObj.setSubjectiontype(xAuth.getSubjectionType());
		}
		return true;
	}
	/**
	 * 对当前track下的xAuth的getCheckId具有的权限进行归类
	 * 
	 * @param xAuth
	 * @param tmpCur
	 * @return
	 */
	private int doCurTrackClassify(int pos,DBWorkAuth xAuth,List<DBWorkAuth> tmpCur,boolean checkAuthor){
		String status = xAuth.getStatus();
		checkReader(xAuth,status);
		//是否当前节点
		int curPos = pos;
		boolean isAdd = true;
		if(xAuth.getNodenum() == curNodesLen -1){//当前节点权限一般也只有办理是处于当前节点的
			//20181107 liys 解决权限中同一用户,在带subjection和不带时的冲突
//			流程:start->Node1->Node2->.....
//			Node1的办理人为U_user1/D_dept1,提交给Node2时办理人为U_user1,也就是提交给同一人,但是不带部门
//			从U_user1的待办中打开时,因为待办中是不含部门信息的,当前办理人是U_user1,此时提交操作正常
//			如果从已办中打开时,因为已办信息中包含部门信息,所以打开的身份也是带部门的,
// 				原有的权限处理是可以显示主办身份的操作,但是在实际操作时,会因为匹配问题出现异常.
//			修改后:从已办打开时,不再包含主办的权限,也就是U_user1/D_dept1和U_user1是两个不同的人来处理权限
			if(checkAuthor) {
				//此时说明权限中没有完全匹配userObj,所以主办的权限需要过滤掉
				if(status.equals(StaticVarExtend.AUTH_AUTHOR)){
					isAdd = false;
				}
			}
			if(isAdd){
				curNodeAuths.append(StaticVarExtend.StrSplitChar).append(status);
				curPos = getRolePos(participants, status, pos);
			}
			tmpCur.add(xAuth);
		}
		else if(xAuth.getNodenum() == curNodesLen -2){//上一节点
			preNodeAuthsOnCurTrack.append(StaticVarExtend.StrSplitChar).append(status);
			preNodeidOnCurTrack = xAuth.getNodeid();
			tmpOtherDB.add(xAuth);
		}
		else{	//上一节点之前的节点
			otherNodeAuths.append(StaticVarExtend.StrSplitChar).append(status);
			tmpOtherDB.add(xAuth);
		}
		return curPos;
	}
	/**
	 * 对当前track外的其他xAuth的getCheckId权限进行分类
	 * 对当前track下只有一个节点时的处理
	 */
	private void doNotCurTrackClassifyForOnlyOneCurNode(String[] tracks,String preTrack,Map<String,List<DBWorkAuth>> auths){
	    //有上一路径时,获取最近的上一路径的权限
		if(tracks.length >1){
		    for(int i=1,n=tracks.length;i<n;i++){
		        List<DBWorkAuth> list2 = auths.get(tracks[i]);
		        if(!(null == list2 || list2.isEmpty())){
		            if(preTrack.indexOf(tracks[i]) !=-1){
		                String[] preTrackNodes = getRunningdata().getNodesOfTrackid(tracks[i]).split(StaticVarExtend.StrSplitChar);
		                int preTrackNodeLen = preTrackNodes.length - 1;
		                for(int j=0,m=list2.size();j<m;j++){
		                	DBWorkAuth xAuth= list2.get(j);
		                    //当前人具有的权限
		                    if(isRoleByAuthId(xAuth) || isRoleBySubjectid(xAuth)){
		                        //屏蔽主办和协办权限,避免当前人在当前分支上出现提交操作
		                        if(xAuth.getStatus().equals(StaticVarExtend.AUTH_AUTHOR)
                                        || xAuth.getStatus().equals(StaticVarExtend.AUTH_SECOND_AUTHOR)){
                                   xAuth.setStatus(StaticVarExtend.AUTH_CREADER);
                                }
		                        if(xAuth.getNodenum() == preTrackNodeLen){
		                            lastNodeAuthsOnPreTrack.append(StaticVarExtend.StrSplitChar).append(xAuth.getStatus());
		                            lastNodeidOnPreTrack= (xAuth.getNodeid());
		                        }
		                        else{
		                            otherNodeAuths.append(StaticVarExtend.StrSplitChar).append(xAuth.getStatus());
		                        }
		                        tmpOtherDB.add(xAuth);
		                        
		                        checkReader(xAuth,xAuth.getStatus());
		                    }
		                }       
		            }
		            else{
		            	for(int j=0,m=list2.size();j<m;j++){
		                	DBWorkAuth xAuth= list2.get(j);
    		                if(isRoleByAuthId(xAuth) ||  isRoleBySubjectid(xAuth)){
    		                    if(xAuth.getStatus().equals(StaticVarExtend.AUTH_AUTHOR)
    		                            || xAuth.getStatus().equals(StaticVarExtend.AUTH_SECOND_AUTHOR)){
    		                       xAuth.setStatus(StaticVarExtend.AUTH_CREADER);
    		                    }
    		                    otherNodeAuths.append(StaticVarExtend.StrSplitChar).append(xAuth.getStatus());
                                tmpOtherDB.add(xAuth);
                                checkReader(xAuth,xAuth.getStatus());
    	                    }
		                }
		            }
		        }
		    }
		}
	}
	
	private void checkReader(DBWorkAuth xAuth,String status){
	    if(status.equals(StaticVarExtend.AUTH_READER)){
            readerDB.add(xAuth);
        }
	    else if(status.equals(StaticVarExtend.AUTH_READED)){
            readedDB.add(xAuth);
        }
	}
	
	/**
	 * 对当前track外的其他xAuth的getCheckId权限进行分类
	 * 对当前track下有多个节点时的处理
	 */
	private void doNotCurTrackClassifyForMultiNode(String[] tracks,Map<String,List<DBWorkAuth>> auths){
		for(int i=1,n=tracks.length;i<n;i++){
			List<DBWorkAuth> list3 = auths.get(tracks[i]);
			if(!(null == list3 || list3.isEmpty())){
				for(int j=0,m=list3.size();j<m;j++){
					DBWorkAuth xAuth = list3.get(j);
					if(xAuth.getStatus().equals(StaticVarExtend.AUTH_AUTHOR)
					        || xAuth.getStatus().equals(StaticVarExtend.AUTH_SECOND_AUTHOR)){
					    xAuth.setStatus(StaticVarExtend.AUTH_CREADER);
					}
					if(isRoleByAuthId(xAuth) || isRoleBySubjectid(xAuth)){
						otherNodeAuths.append(StaticVarExtend.StrSplitChar).append(xAuth.getStatus());
						tmpOtherDB.add(xAuth);
						
						checkReader(xAuth,xAuth.getStatus());
					}
				}
			}
		}
	}
	/**
	 * 增加管理员权限
	 */
	private void doFlowManger(){
		if(userObj.isManager()){
			otherNodeAuths.append(StaticVarExtend.StrSplitChar).append(StaticVarExtend.AUTH_MANAGER);
		}
	}
	
	private int getCurPos(int pos){
		String allAuths = curNodeAuths.append(preNodeAuthsOnCurTrack)
										.append(lastNodeAuthsOnPreTrack)
										.append(otherNodeAuths).toString();
		String allAuth = CStrUtil.unique(allAuths, StaticVarExtend.StrSplitChar);
		String[] allAuthArr = allAuth.split(StaticVarExtend.StrSplitChar);
		int curPos = pos;
		boolean isReaded = false;
		boolean isReader = false;
		StringBuilder sb = new StringBuilder(200);
		for(String auth:allAuthArr){
			if(auth.equals(StaticVarExtend.AUTH_READED)){
				isReaded = true;
			}
			else if(auth.equals(StaticVarExtend.AUTH_READER)){
				isReader = true;
			}
			else{
				sb.append(StaticVarExtend.StrSplitChar).append(auth);
			}
			curPos = getRolePos(participants,auth,curPos);
		}
		//对读者和已阅进行处理,
		if(readerDB.size()>0 && readedDB.size()>0){
		    for(int i=0,n=readerDB.size();i<n;i++){
		    	DBWorkAuth readerAuth = readerDB.get(i);
		        //1.如果有Reader权限,且authid!=null 则必须为Reader
		        if(!readerAuth.getAuthId().equals(StaticVarExtend.NullStr)){
		            isReaded = false;
		            break;
		        }
		        //假定未阅
		        isReaded = false;
		        for(int j=0,m=readedDB.size();j<m;j++){
		        	DBWorkAuth readedAuth = readedDB.get(j);
		            if(readedAuth.getSubjectionId().equals(StaticVarExtend.NullStr)){
		                continue;
		            }
		            if(readedAuth.getSubjectionId().equals(readerAuth.getSubjectionId())){
		                //标记已阅
		                isReaded = true;
		                break;
		            }
		        }
		    }
		}
		
		if(isReaded){
			sb.append(StaticVarExtend.StrSplitChar).append(StaticVarExtend.AUTH_READED);
		}
		else if(isReader){
			sb.append(StaticVarExtend.StrSplitChar).append(StaticVarExtend.AUTH_READER);
		}
		
		userObj.setCurNodeAuths(sb.deleteCharAt(0).toString()); //所有的权限列表
		return curPos;
	}

	
	
	/**
	 * 获取最小值
	 * @param participants
	 * @param auth
	 * @param curPos
	 * @return
	 */
	private int getRolePos(List<String> participants,String auth,int curPos){
		for(int i=0;i<curPos;i++){
			if(auth.startsWith(participants.get(i))){
				return i;
			}
		}
		return curPos;
	}
	
	/**
	 * 设置权限到当前用户对象中
	 * @param auth
	 * @param control
	 * @return
	 */
	private boolean returnCheck(String auth,String control){
		//System.out.println("[Test]"+Thread.currentThread().getId()+"returnCheck,auth:"+auth+";control:"+control+";userid:"+userObj.getUserid());
		userObj.setAuthName(auth);
		userObj.setControlNodeName(control);
		return true;
	}

	/**
	 * 判断当前用户的权限
	 * @param auth 权限信息
	 * @return
	 */
	private boolean isRoleByAuthId(DBWorkAuth auth){
		return isRole(auth.checkId(), auth.getAuthType(),auth.getStatus());
	}
	
	private boolean isRoleBySubjectid(DBWorkAuth auth){
		//如果权限的Authid不为空则不对归属进行判断
		if(auth.getAuthId().equals(StaticVarExtend.NullStr)){
			return isRole( auth.getSubjectionId(), auth.getSubjectionType(),auth.getStatus());
		}
		return false;
	}
	
	/**
	 * 判断当前用户的权限
	 * @param authType 要判段的id类型
	 * @return
	 */
	private boolean isRole(String users,String authType,String authname){
		String user = users;
		if(user.equals(StaticVarExtend.NullStr)){
			return false;
		}
		boolean isRole = false;
		String identifier = getRunningdata().getInitData().getFlowIdentifier();
		
		//包含子部门的
		if(StaticVarExtend.DeptFix.equals(authType)){
			String subdept = org.getSubDeptIdById(user, identifier);
			if(!StaticVarExtend.NullStr.equals(subdept)){
				user = user + StaticVarExtend.UserSplitChar + subdept;
			}
		}
		
		isRole =  userIsRole(user);
		return isRole;
	}
	private boolean userIsRole(String role){
		return userObj.isRole(role);
	}
}
