package com.horizon.wf.rule.common;

import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.rule.jsr94.IRuleEngine;
import com.horizon.wf.tools.AccessUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 规则中通用的方法
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class RuleUtil {
	private RuleUtil(){}
	/**
	 * 控制信息
	 * @return
	 */
	public static List<String> getParticipantsName(RunningData runningdata) {
		//CheckRoleForOpenInstanceDefault中使用
		String[] types = null;
		String type = runningdata.getInstanceDefinition().getFlowinfo().getParticipantAuth();
		if(StringUtilExtend.isNotNull(type)){
			types = type.split(";");
		}
		List<String> typeList = new ArrayList<String>();
		if(CollectionUtil.isStringArrayNotEmpty(types)){
			typeList.add(StaticVarExtend.AUTH_AUTHOR+"_DO");
			typeList.add(StaticVarExtend.AUTH_READER+"_DO");
			typeList.addAll(Arrays.asList(types));
			typeList.add(StaticVarExtend.AUTH_READER+"_DO");
			typeList.add(StaticVarExtend.AUTH_READER+"_DO");
			typeList.add(StaticVarExtend.AUTH_READER+"_DO");
		}
		return typeList;
/*		return new String[]{StaticVarExtend.AUTH_AUTHOR,StaticVarExtend.AUTH_CREADER,StaticVarExtend.AUTH_CREATOR,StaticVarExtend.AUTH_DONE,
				StaticVarExtend.AUTH_READER,StaticVarExtend.AUTH_READER,StaticVarExtend.AUTH_READER,StaticVarExtend.AUTH_DONE_HUIQIAN,StaticVarExtend.AUTH_READER};
*/	}
	
	/**
	 * 权限信息
	 * @return
	 */
	public static List<String> getParticipants(RunningData runningdata) {
		//CheckRoleForOpenInstanceDefault,EntryRuleDefault
		String[] types = null;
		String type = runningdata.getInstanceDefinition().getFlowinfo().getParticipantIds();
		if(StringUtilExtend.isNotNull(type)){
			types = type.split(";");
		}
		List<String> typeList = new ArrayList<String>();
		if(CollectionUtil.isStringArrayNotEmpty(types)){
			typeList.add(StaticVarExtend.AUTH_HUIQIAN_AUTHOR);
			typeList.add(StaticVarExtend.AUTH_SUBFLOW_AUTHOR);
			typeList.addAll(Arrays.asList(types));
			typeList.add(StaticVarExtend.AUTH_CREADER);
			typeList.add(StaticVarExtend.AUTH_START_HUIQIAN_AUTHOR);
			typeList.add(StaticVarExtend.AUTH_READED);
		}
		return typeList;

	}
	
	/**
	 * 执行规则
	 * @return
	 * @throws Exception
	 */
	public static String executeRule(String ruleScript,RunningData rd)throws Exception{
		if(StringUtilExtend.isNotNull(ruleScript)){
			IRuleEngine du = PluginsUtil.getMultiInstance().getRuleEngine();
			du.setPara("RunningData", rd);
			Object rs = du.exctu(ruleScript);
			if(null != rs){
				String result = String.valueOf(rs);
				return result.trim();
			}		
		}
		return "";
	}
	
	public static boolean executeRule(String ruleScript, IFlowNode node, RunningData rd) throws Exception{
		//EntryRuleDefault,LeaveRuleDefault,StartRuleDefault
		String result = executeRule(ruleScript,rd);
		if(result.length()==0 || "true".equalsIgnoreCase(result)){
			return true;
		}
					
		return false;
	}
	
	public static boolean executeRuleForRouter(String ruleScript,RunningData rd,Boolean isPass) throws Exception{
		String result = executeRule(ruleScript,rd);
		if(result.length()==0){
			return isPass;
		}				
		return "true".equalsIgnoreCase(result);
	}
	
	public static String[] getOuterUsersAndLimit(String type,String flowid,String nodeid,String usetype,String identifier){
		String sql = "select "+type + ",limittime from " + StaticVarExtend.Table_Exterior_User + " " +
				" where flowid=? and nodeid=? and usetype=?";
		List<Object> conditionList = new ArrayList<Object>();
		conditionList.add(flowid);
		conditionList.add(nodeid);
		conditionList.add(usetype);
		
		List<Object> list = AccessUtil.getInstance().getSingleList(sql, conditionList, identifier);
		if(CollectionUtil.isListNotEmpty(list)){
			Object obj = list.get(0);
			if(null != obj){
				String[] result = new String[2];
				result[0] = String.valueOf(obj);
				result[1] = String.valueOf(list.get(1));
				return result;
			}
		}
		return null;
	}
	/**
	 * 获取外部设置的办理人
	 * @param type
	 * @param flowid
	 * @param nodeid
	 * @param usetype
	 * @param identifier
	 * @return
	 */
	public static String getOuterUsers(String type,String flowid,String nodeid,String usetype,String identifier){
//		StartRuleDefault,EntryRuleDefault
		String sql = "select "+type + " from " + StaticVarExtend.Table_Exterior_User + " " +
				" where flowid=? and nodeid=? and usetype=?";
		List<Object> conditionList = new ArrayList<Object>();
		conditionList.add(flowid);
		conditionList.add(nodeid);
		conditionList.add(usetype);
		List<Object> list = AccessUtil.getInstance().getSingleList(sql, conditionList, identifier);
		if(CollectionUtil.isListNotEmpty(list)){
			Object obj = list.get(0);
			if(null != obj){
				return String.valueOf(obj);
			}
		}
		return null;
	}

	/**
	 * 获取外部设置的办理期限
	 * @deprecated
	 * @param flowid
	 * @param nodeid
	 * @param usetype
	 * @param identifier
	 * @return
	 */
	 public static String getOuterLimittime(String flowid,String nodeid,String usetype,String identifier){
//		TrackLogDefault
		String sql = "select limittime from " + StaticVarExtend.Table_Exterior_User + " " +
				" where flowid=? and nodeid=? and usetype=?";
		List<Object> conditionList = new ArrayList<Object>();
		conditionList.add(flowid);
		conditionList.add(nodeid);
		conditionList.add(usetype);
		List<Object> list = AccessUtil.getInstance().getSingleList(sql, conditionList, identifier);
		if(CollectionUtil.isListNotEmpty(list)){
			Object obj = list.get(0);
			if(null != obj){
				return String.valueOf(obj);
			}
		}
		return "";
	}
	
}
