package com.horizon.wf.pool;
import java.util.List;
import java.util.Map;

import com.horizon.wf.expand.impl.ITodoInterface;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;

/**
 *发送信息类 
 * sendType
 *            发送类型（待办、待阅、消息、短信、邮件、RTF、其他）
 * @return
 */
public class XMLTodoPub  {
/*
发送待阅消息的方法可以调用:
XMLTodoStatic.sendTodo("ReadMsg",map);
map必须包含的内容:
USERID = 使用竖线|连接的ID列表
TITLE  = 标题
URL    = 打开链接地址
SENDTIME			= 发送时间
SENDUSERID			= 发送人ID(无前缀)
SENDUSERNAME		= 发送人中文名称
SENDUSERDEPTNAME	= 发送人部门名称
DATAID				= 链接数据ID
//下面的参数非必须
MODELID				= 模块ID
MODELNAME			= 模块名称
IMPORTANCE			= 重要程度
TIMELIMIT			= 时限
LIMITTYPE			= 时限类型(工作日,自然日)

 这是Oracle版本的过滤重复的已办SQL
 */
	private static ITodoInterface xmlTodo = PluginsUtil.getSingleInstance().getSendTodoInfo();
	private XMLTodoPub(){}
	/**
	 * 插入即使执行任务
	 */
	public static void startThread(String workid,List<String> tmpIdList,String identifier){
		if(tmpIdList == null || tmpIdList.isEmpty()){
			return;
		}
		PluginsUtil.getSingleInstance().getTaskInterface().addTaskForTodo(workid, tmpIdList, identifier);
	}
	
	/**
	 * 插入即使执行任务
	 */
	public static void startThreadForNoActiveMsg(String workid,String trackid,String identifier){
		PluginsUtil.getSingleInstance().getTaskInterface().addTaskForTodoNoActiveMsg(workid, trackid, identifier);
	}
	/**
	 * 供线程调用
	 * @param sendType
	 * @param lhm
	 * @return
	 */
	public static boolean sendMsg(String sendType,Map<String,Object> lhm,String tenantid){
		xmlTodo.setTenantid(tenantid);
		if (sendType.equalsIgnoreCase(StaticVarExtend.Send_Mail)) { // 发送Mail
			return xmlTodo.sendMail(lhm);
		} 
		else if (sendType.equalsIgnoreCase(StaticVarExtend.Send_Msg)) { // 发送系统消息
			return xmlTodo.sendMsg(lhm);
		} 
		else if (sendType.equalsIgnoreCase(StaticVarExtend.Send_Note)) { // 发送短信
			return xmlTodo.sendNode(lhm);
		} 
		else if (sendType.equalsIgnoreCase(StaticVarExtend.Send_RTF)) { // 发送RTF信息
			return xmlTodo.sendRTF(lhm);
		} 
		else {
			lhm.put("SENDTYPE", sendType);
			return xmlTodo.sendOther(lhm);
		}
	}

}