package com.horizon.wf.pool;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.third.ThirdAdapterFactory;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.CStrUtil;

/**
 * 代办数据访问类
 * 
 * @author mawr
 * 
 */
@SuppressWarnings("unchecked")
public class TodoManager {

    /**
     * Logger for this class
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(TodoManager.class);

    private static final String TODO_SEL_SQL = "SELECT * FROM TW_HZ_TEMPTODO";

    private static final String TODO_SEL_SQL_NOACTIVE = "select * from TW_HZ_TEMPTODO where workid=? and trackid=? and active='0'";
    
    private static final String TODO_DEL_SQL = "DELETE FROM TW_HZ_TEMPTODO WHERE ID=?";
    
    private TodoManager(){}
    /**
     * 发送待办
     * 
     * @param tempTodoIds
     * @param identifier
     */
    public static void sendTodo(List<String> tempTodoIds, String identifier) {
        List<Todo> lstTodo = getTempTodo(tempTodoIds, identifier);
        send(lstTodo,identifier);
    }

    public static void sendTodo(String workid,String trackid, String identifier) {
        List<Todo> lstTodo = getTempTodo(workid,trackid, identifier);
        send(lstTodo,identifier);
    }
    
    private static void send(List<Todo> lstTodo,String identifier){
    	 if (null == lstTodo) {
             LOGGER.error("未获得需要发送的待办数据");
             return;
         }
    	 String tenantid = ThirdAdapterFactory.getTenantidByIdentifier(identifier);
         for (Todo td : lstTodo) {
             String type = td.getSendtype();
             Map<String,Object> map = td.getSendObjMap();
             if (XMLTodoPub.sendMsg(type, map,tenantid)) {
                 td.setOk(true);
                 if (LOGGER.isDebugEnabled()) {
                     LOGGER.debug("发送待办成功的 workid：" + td.getWorkid());
                 }
             }else{
                 LOGGER.error("发送待办失败的 workid：" + td.getWorkid());
             }
         }
         deleteTodo(lstTodo, identifier);
    }
    /**
     * 代办发送成功后，删除临时代办数据
     * 
     * @param todoes
     *            已发送成功代办数据
     * @param identifier
     */
    @SuppressWarnings("rawtypes")
	private static void deleteTodo(List<Todo> todoes, String identifier) {

        LOGGER.info("删除临时待办数据...开始");

        List<List<String>> delCondition = new ArrayList<List<String>>();
        Map mapSqlParameters = new LinkedHashMap();
        for (Todo todo : todoes) {
            if (todo.isOk()) {
                List<String> list = new ArrayList<String>();
                list.add(todo.getId());
                delCondition.add(list);
                todo.getSQL(mapSqlParameters);
            }
        }

        // 删除临时代办表数据
        if (!delCondition.isEmpty()) {
            mapSqlParameters.put(TODO_DEL_SQL, delCondition);
            boolean isOk =  AccessUtil.getInstance()
            		.executeMultiUpdate(mapSqlParameters, identifier);
            LOGGER.info("删除临时待办数据... " + isOk);
        }
        
        todoes.clear();
        delCondition.clear();
        mapSqlParameters.clear();
        todoes = null;
        delCondition = null;
        mapSqlParameters = null;

        LOGGER.info("删除临时待办数据...结束");
    }

    /**
     * 获取需要发送的代办数据
     * 
     * @param tempTodoIds
     *            临时代办数据ID
     * @param identifier
     *            数据源标识符号
     * @return
     */
    private static List<Todo> getTempTodo(List<String> tempTodoIds, String identifier) {

        List<String> list = new ArrayList<String>();
        StringBuilder builder = new StringBuilder(TODO_SEL_SQL);
        builder.append(" WHERE ID IN (");

        for (String id : tempTodoIds) {
            if (CStrUtil.hasValue(id)) {
                builder.append("?,");
                list.add(id);
            }
        }
        builder.deleteCharAt(builder.lastIndexOf(","));
        builder.append(")");

        List<Todo> listTodo = null;
        if (!list.isEmpty()) {
            listTodo =  AccessUtil.getInstance()
            		.getMultiObject(builder.toString(), list, Todo.class, identifier);
        }
        return listTodo;
    }
    
    private static List<Todo> getTempTodo(String workid,String trackid, String identifier) {
    	List<String> list = new ArrayList<String>();
    	list.add(workid);
    	list.add(trackid);
    	return  AccessUtil.getInstance()
    			.getMultiObject(TODO_SEL_SQL_NOACTIVE, list, Todo.class, identifier);
    }
}
