package com.horizon.wf.pool;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.JSONUtil;

/**
 * 代办实体类
 * 
 * @author mawr
 * 
 */
@SuppressWarnings("unchecked")
public class Todo implements Serializable {

    /**
     * 当对象被声明为支持序列化时，默认的序列化版本UID
     */
    private static final long serialVersionUID = 1L;

    private String id;

	private String workid;
	
	private String trackid;
	private String sendtime;
	private String active;
	
    private String sendtype;//发送消息的类型

    private String sendobj;//发送消息的内容

    private boolean isOk = false;

    private Map<String,Object> sendObjMap;

    private Lock lock = new ReentrantLock();

    private int actionnum;
    private int sendnum;
    @SuppressWarnings("rawtypes")
	public void getSQL(Map<String,Object> saveMap){
    	String sql = "insert into "+StaticVarExtend.Table_Todo_Success+
    			" (ID,workid,trackid,active,sendtype,sendObj,ACTIONNUM,SENDNUM,sendtime) Values(?,?,?,?,?,?,?,?,?)";
    	
    	List<List> para = (List) saveMap.get(sql);
    	if(CollectionUtil.isListEmpty(para)){
    		para = new ArrayList<List>();
    		saveMap.put(sql, para);
    	}
    	
    	List<Object> tmp = new ArrayList<Object>();
    	tmp.add(getId());
    	tmp.add(workid);
    	tmp.add(trackid);
    	tmp.add(active);
    	tmp.add(sendtype);
    	tmp.add(sendobj);
    	tmp.add(new Integer(actionnum));
    	tmp.add(new Integer(sendnum+1));
    	tmp.add(sendtime);
    	para.add(tmp);
    }
    
    public Map<String,Object> getSendObjMap() {

        Map<String,Object> map = JSONUtil.jsonToMap(sendobj);
        if (CollectionUtil.isMapNotEmpty(map)) {
        	sendObjMap = new LinkedHashMap<String,Object>();
        	sendObjMap.putAll(map);
        }
        return sendObjMap;
    }
    public String getId() {

        return id;
    }

    public void setId(String id) {

        this.id = id;
    }
    public boolean isOk() {

        return isOk;
    }

    public void setOk(boolean isOk) {

        this.isOk = isOk;
    }

  

	public int getActionnum() {
		return actionnum;
	}

	public void setActionnum(int actionnum) {
		this.actionnum = actionnum;
	}

	public String getWorkid() {

        return workid;
    }

    public void setWorkid(String workid) {

        this.workid = workid;
    }

    public String getSendtype() {

        return sendtype;
    }

    public void setSendtype(String sendtype) {

        this.sendtype = sendtype;
    }

    public String getSendobj() {

        return sendobj;
    }

    public void setSendobj(String sendobj) {

        this.sendobj = sendobj;
    }

    public int getSendnum() {

        return sendnum;
    }

    public void setSendnum(int sendnum) {

        this.sendnum = sendnum;
    }

    public Lock getLock() {

        return lock;
    }

	public String getTrackid() {
		return trackid;
	}

	public void setTrackid(String trackid) {
		this.trackid = trackid;
	}

	public String getActive() {
		return active;
	}

	public void setActive(String active) {
		this.active = active;
	}

	public String getSendtime() {
		return sendtime;
	}

	public void setSendtime(String sendtime) {
		this.sendtime = sendtime;
	}
    
    
}
