package com.horizon.wf.plugins;

import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.expand.impl.IHZTransaction;
import com.horizon.wf.expand.impl.IMessageMould;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.expand.impl.ITodoInterface;
import com.horizon.wf.expand.impl.common.AdapterFactory;
import com.horizon.wf.rule.form.IFormInfo;

public class PluginsSingleDefault implements IPluginsSingle {
	/**
	 * 获取事务处理对象
	 * @return
	 */
	public IHZTransaction getHZTransaction() {
		return AdapterFactory.getHZTransaction();
	}

	/**
	 * 获取定时任务对象
	 * @return
	 */
	public ITaskInterface getTaskInterface(){
		return AdapterFactory.getTaskInterface();
	}
	
	/**
	 * 获取发送消息时的格式信息
	 * @return
	 */
	public IMessageMould getMessageMould(){
		return AdapterFactory.getMessageMould();
	}
	
	/**
	 * 获取发送系统外消息的对象
	 * @return
	 */
	public ITodoInterface getSendTodoInfo(){
		return AdapterFactory.getXMLTodo();
	}
	/**
	 * 定制工具中获取表单信息的支持对象
	 * @return
	 */
	public IFormInfo getFormInfo(){
		return InterfaceFactory
				.getNewInterface(HZResourceBundle.getInstance().getFormInfoClassName());
	}
}
