package com.horizon.wf.plugins;

import com.horizon.wf.expand.impl.IAppInterface;
import com.horizon.wf.expand.impl.IAuthority;
import com.horizon.wf.expand.impl.IHZCalendar;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.expand.impl.common.AdapterFactory;
import com.horizon.wf.rule.jsr94.IRuleEngine;


public class PluginsMultiDefault implements IPluginsMulti {
	/**
	 * 获取规则引擎对象
	 * @return
	 */
	public IRuleEngine getRuleEngine(){
		return AdapterFactory.getRuleEngine();
	}
	/**
	 * 删除实例或者恢复版本时,业务数据需要处理的实现类
	 * @return
	 */
	public IAppInterface[] getAppInterface(){
		return AdapterFactory.getAppInterface();
	}
	
	/**
	 * 获取组织信息支持对象
	 * @return
	 */
	public IOrganizationInterface getOrganization(String tenantid){
		return AdapterFactory.getOrganization(tenantid);
	}
	
	/**
	 * 权限控制支持对象
	 * @param tenantid
	 * @return
	 */
	public IAuthority getAuthority(String tenantid){
		return AdapterFactory.getAuthority(tenantid);
	}
	
	/**
	 * 日历支持对象
	 * @return
	 */
	public IHZCalendar getCalendar(String tenantid){
		return AdapterFactory.getCalendar(tenantid);
	}
}
