package com.horizon.wf.integration;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.tools.CStrUtil;

/**
 * 某系统数据交互实现类
 * 1.链接
 * 2.请求
 * 3.参数处理
 * 4.返回值处理
 * @author liys
 *
 */
public class DataForERP implements IData{
	private DataSource source;
	
	public void setDataSource(DataSource source) {
		this.source = source;
		source.connect();
	}

	public String getData(Map<String, Object> para) {
		source.getUrl();
		return null;
	}

	
	public static JSONObject sendPost(String postParam, String url, int timeout) throws Exception{
        JSONObject result = new JSONObject();
        PrintWriter out = null;
        BufferedReader in = null;
        String EVALUATION_IP="";
        try {
            if (CStrUtil.isNull(EVALUATION_IP)) {
                throw new Exception("EVALUATION_IP 不能为空");
            }
            String targetURL = "http://" + EVALUATION_IP  + url;
            URL resetServiceURL = new URL(targetURL);
            //打开url连接
            HttpURLConnection httpConnection = (HttpURLConnection) resetServiceURL.openConnection();
            //设置连接请求头信息属性       
            httpConnection.setRequestProperty("Accept", "application/json, text/javascript, */*; q=0.01");
            httpConnection.setRequestProperty("Accept-Encoding", "gzip, deflate");
            httpConnection.setRequestProperty("Accept-Language", "zh-CN,zh;q=0.9");
            httpConnection.setRequestProperty("Connection", "keep-alive");
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpConnection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.84 Safari/537.36");
            httpConnection.setRequestProperty("X-Requested-With", "XMLHttpRequest");
            //设置超时时间
            httpConnection.setConnectTimeout(timeout);
            httpConnection.setReadTimeout(timeout);
            //设置请求方式
            httpConnection.setRequestMethod("POST");
            httpConnection.setDoInput(true);
            httpConnection.setDoOutput(true);
            //POST请求不应该使用cache
            httpConnection.setUseCaches(false);
            //获取url连接
            httpConnection.connect();
            //获取UrlConnection对象的输出流，调用httpConnection.getOutputStream的时候就会设置为POST方法
            out = new PrintWriter(new OutputStreamWriter(httpConnection.getOutputStream(),"UTF-8"));
            out.write(postParam);
            //flush输出流的缓冲，将参数发送出去
            out.flush();
            //表示连接异常
            if (httpConnection.getResponseCode() != 200) {
                result.put("message", "数据获取异常，请联系系统管理员");
                result.put("result", "ERROR");
                result.put("code", null);
                result.put("object", null);
                return result;
            }
            //读取流中的内容
            in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String line = "";
            StringBuffer bf = new StringBuffer();
            while (null !=(line = in.readLine())) {
                bf.append(line);
            }

            if (CStrUtil.isNotNull(bf.toString())) {
                JSONObject evalutionResult = JSONObject.parseObject(bf.toString());
                return evalutionResult;
            }
        } catch (Exception e) {
//            logger.error("Send post Exection!",e);
            result.put("message", "数据获取异常，请联系系统管理员");
            result.put("result", "ERROR");
            result.put("code", null);
            result.put("object", null);
            return result;
        } finally {
            // 关闭流
            try {
                if (null != out) {
                    out.close();
                }
                if (null != in) {
                    in.close();
                }
            } catch (Exception e) {
//                logger.info("Send post Exection!");
                e.printStackTrace();
                result.put("message", "数据获取异常，请联系系统管理员");
                result.put("result", "ERROR");
                result.put("code", null);
                result.put("object", null);
                return result;
            }
        }
        return result;
    }
}
