package com.horizon.wf.global;

import com.horizon.wf.tools.CStrUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.action.common.ActionExtraData;
import com.horizon.wf.definition.tools.UUIDFun;


public class StaticFunExtend  {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticFunExtend.class);

	private StaticFunExtend(){}
	public static String getUnid(){
		return UUIDFun.getUnid();
	}
	
	public static void println(String msg){
		LOGGER.info("@\n"+msg);
	}
	
	/**
	 * 获取action中公用操作
	 * @return
	 */
	public static ActionCommon getActionCommon(){
		return ActionCommon.getInstance();
	}
	/**
	 * 获取action中公用操作
	 * @return
	 */
	public static ActionExtraData getActionExtraData(){
		return ActionExtraData.getInstance();
	}
	
	/**
	 * checkId 是否存在于participantid中
	 * @param checkId A~B
	 * @param participantid A or B
	 * @return
	 */
	public static boolean indexOfUser(String checkId, String participantid){
		return checkId.indexOf(participantid) != -1;
	}
	
	/**
	 * 去掉前缀,仅仅去掉指定的前缀
	 * @param org
	 * @return
	 */
	public static String subPaticipantOrg(String org) {
		if(org==null || org.trim().length()==0) {return "";}
		String[] orgs = org.split(StaticVarExtend.UserSplitChar);
		if(orgs.length==1) {
			if(org.indexOf("_") != -1){
				return org.substring(org.indexOf("_")+1);
			}
		}
		StringBuilder sb = new StringBuilder(1000);
		for(int i=0,n=orgs.length;i<n;i++) {
			if(orgs[i].length() == 0){ continue;}
			sb.append(StaticVarExtend.UserSplitChar);
			if(orgs[i].indexOf("_") != -1){
				sb.append(orgs[i].substring(orgs[i].indexOf("_")+1));
			}
			else {
				sb.append(orgs[i]);
			}
			
		}
		if(sb.length()>0) {
			sb = sb.deleteCharAt(0);
		}
		return sb.toString();
	}

	
	/**
	 * 去掉前缀,仅仅去掉指定的前缀
	 * @param org
	 * @param type
	 * @return
	 */
	public static String subUserOrg(String org,String type) {
		if(org==null || org.trim().length()==0) {return "";}
		String[] orgs = org.split(StaticVarExtend.UserSplitChar);
		if(orgs.length==1) {
			if(org.indexOf("_") == type.length() && org.substring(0,org.indexOf("_")).equalsIgnoreCase(type)) {
				return org.substring(org.indexOf("_")+1);
			}
			return org;
		}
		StringBuilder sb = new StringBuilder(1000);
		for(int i=0,n=orgs.length;i<n;i++) {
			if(orgs[i].length() == 0){ continue;}
			sb.append(StaticVarExtend.UserSplitChar);
			if(orgs[i].indexOf("_") == type.length() && orgs[i].substring(0,orgs[i].indexOf("_")).equalsIgnoreCase(type)){
				sb.append(orgs[i].substring(orgs[i].indexOf("_")+1));
			}
			else {
				sb.append(orgs[i]);
			}
			
		}
		if(sb.length()>0) {
			sb = sb.deleteCharAt(0);
		}
		return sb.toString();
	}
	
	/**
	 * 处理部门/群组/角色.以便流程引擎调用,主要是添加前缀
	 * @param org
	 * @param type
	 * @return
	 */
	public static String reUserOrg(String org,String type) {	
		if(org==null || org.trim().length()==0){ return "";}
		String[] orgs = org.split(StaticVarExtend.UserSplitChar);
		if(orgs.length==1) {
			if(org.indexOf("_") == type.length() && org.substring(0,org.indexOf("_")).equalsIgnoreCase(type)) {
				return org;
			}
			return org.length()>0?(type+"_"+org):"";
		}
		StringBuilder sb = new StringBuilder(1000);
		for(int i=0,n=orgs.length;i<n;i++) {
			if(orgs[i].length() == 0){ continue;}
			sb.append(StaticVarExtend.UserSplitChar);
			if(!(orgs[i].indexOf("_") == type.length() && orgs[i].substring(0,orgs[i].indexOf("_")).equalsIgnoreCase(type))) {
				sb.append(type);
				sb.append("_");
			}
			sb.append(orgs[i]);
		}
		if(sb.length()>0) {
			sb = sb.deleteCharAt(0);
		}
		return sb.toString();
	}
	
	/**
	 * 从列表中去掉重复的值,从前往后,使用默认的分隔符(|)
	 * @param list1
	 * @return
	 */
	public static String[] unique(String[] list1) {		
		return unique(list1,StaticVarExtend.UserSplitChar).split(StaticVarExtend.UserSplitChar);		
	}	
	
	/**
	 * 使用默认的分隔符(|),分割字符,去掉重复的值
	 * @param str1
	 * @return
	 */
	public static String unique(String str1) {
		
		return unique(str1,StaticVarExtend.UserSplitChar);
	}
	/**
	 * 使用指定的分割符号,分割字符,去掉重复的值
	 * @param str1
	 * @param split
	 * @return
	 */
	private static String unique(String str1,String split) {
		return unique(str1.split("\\\\"+split),split);
	}
	/**
	 * 从列表中去掉重复的值,从前往后,使用指定的分隔符
	 * @param list1
	 * @param split
	 * @return
	 */
	private static String unique(String[] list1,String split) {
		return CStrUtil.unique(list1,split);
//		StringBuilder sb = new StringBuilder(1000);
//		if(list1.length ==0) {		return "";		}
//		if(list1.length ==1) {		return list1[0];	}
//		int k=0;
//		for(int i= 0,n=list1.length ;i<n;i++) {
//			if(list1[i].length() > 0) {
//				sb.append(split);
//				sb.append(list1[i]);
//				sb.append(split);
//				k = i+1;
//				break;
//			}
//		}
//
//		if(k==0) {return "";}
//		for(int i= k,n=list1.length ;i<n;i++) {
//			if(list1[i].length() > 0 && sb.indexOf(split+list1[i]+split)==-1) {
//				sb.append(list1[i]);
//				sb.append(split);
//			}
//		}
//		if(sb.length()>1) {
//			sb= sb.deleteCharAt(0);
//			sb = sb.deleteCharAt(sb.length()-1);
//		}
//		return sb.toString();
	}
	/**
	 * 去除给定字符串中多余的分隔符
	 * @param userid
	 * @return 用户id,以";"分割
	 */
	public static String subOrg(String userid){
		StringBuilder temp = new StringBuilder(1000);
		if(StringUtilExtend.isNotNull(userid)){
			String[] userids = userid.split(StaticVarExtend.UserSplitChar);
			if(!(null == userids || userids.length == 0)){
				for(String u : userids){
					if(u.length()>0){
						temp.append(StaticVarExtend.UserSplitChar).append(u);
					}
				}
				if(temp.length()>1){
					return temp.substring(1);
				}
			}
		}
		return temp.toString();
	}
}
