package com.horizon.wf.global;

import java.util.Date;
import java.util.GregorianCalendar;

import com.horizon.wf.expand.impl.IHZCalendar;
import com.horizon.wf.tools.DateUtil;

public class DateUtilExtend extends DateUtil{
	 /**
     * 在某一个日期上加秒数
     * 
     * @param date
     *            起始日期
     * @param count
     *            需要计算的秒数
     * @return 结束日期
     */
    public static Date addDateSecond(Date date, int count) {

        return addDateProcessor(GregorianCalendar.SECOND, date, count);
    }

    private static Date addDateProcessor(int gregoriancalendar, Date date, int count) {

        GregorianCalendar calendar = getGregorianCalendar(date);
        calendar.add(gregoriancalendar, count);
        return calendar.getTime();
    }
    /**
     * 根据日期返回返回GregorianCalendar对象
     * 
     * @param date
     * @return
     */
    private static GregorianCalendar getGregorianCalendar(Date date) {

        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setFirstDayOfWeek(GregorianCalendar.MONDAY);
        calendar.setTime(date);
        return calendar;
    }
    /**
     * 判断是否超期
     * @param date1:当前时间
     * @param date2:流程提交到该节点的时间
     * @param adjustNum: 办理时长或警告时限
     * @param adjustType: 类型：跟flowconfig.xml中配置对应(默认:0工作日,1自然天,2小时,3分钟)
     * @param calendar 日历接口
     *  @return 是否超期
     */
    public static boolean isOverPass(String date1, String date2, int adjustNum,String adjustType,IHZCalendar calendar) {
        int days = calendar.getWorkdaysFromTwoDate(date1, date2, Integer.parseInt(adjustType));
        boolean r = Math.abs(days) > adjustNum;
        return r;
        
    }
    /**
     * 在给定的时间上增加指定单位的时间
     * @param type
     * @param num
     * @return
     */
    public static Date addDateForTask(String date,int type,int num,IHZCalendar calendar){
        if(num == 0){
            num = 365;
            type = 1;
        }
        switch(type){
        case 0: //工作日
        case 1: //自然天
        	 break;
        case 2: //小时
            return addDateHour(DateUtil.getDateTime(date), num);  
        case 3: //分钟
            return addDateMinute(DateUtil.getDateTime(date), num);  
        }
        return calendar.getDateAfter(DateUtil.getDateTime(date),type, num);  
    }
}
