package com.horizon.wf.global;

import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
	
	private CollectionUtil(){}
	/**
	 * 判断给定的字符串数组是否为空
	 * @param arr
	 * @return true:为空 false：不为空
	 */
	public static boolean isStringArrayEmpty(String[] arr){
		if(null == arr || arr.length == 0){
			return true;
		}
		return false;
	}
	/**
	 * 判断给定的字符串数组是否不为空
	 * @param arr
	 * @return true:不为空 false：为空
	 */
	public static boolean isStringArrayNotEmpty(String[] arr){
		return !isStringArrayEmpty(arr);
	}
	
	/**
	 * 判断给定的set是否为空
	 * @return true:为空 false：不为空
	 */
	public static boolean isSetEmpty(Set<? extends Object> set){
		if(null == set || set.isEmpty()){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断给定的set是否不为空
	 * @return true:不为空 false：为空
	 */
	public static boolean isSetNotEmpty(Set<? extends Object> set){
		return !isSetEmpty(set);
	}
	
	/**
	 * 判断给定的list是否为空
	 * @param list
	 * @return true:为空 false：不为空
	 */
	public static boolean isListEmpty(List<? extends Object> list){
		if(null == list || list.isEmpty()){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断给定的list是否不为空
	 * @param list
	 * @return true:不为空 false：为空
	 */
	public static boolean isListNotEmpty(List<? extends Object> list){
		return !isListEmpty(list);
	}
	
	/**
	 * 判断给定的map是否为空
	 * @param map
	 * @return true:为空 false：不为空
	 */
	public static boolean isMapEmpty(Map<? extends Object,? extends Object> map){
		if(null == map || map.isEmpty()){
			return true;
		}
		return false;
	}
	
	/**
	 * 判断给定的map是否不为空
	 * @param map
	 * @return true:不为空 false：为空
	 */
	public static boolean isMapNotEmpty(Map<? extends Object,? extends Object> map){
		return !isMapEmpty(map);
	}

}
