package com.horizon.wf.expand.signal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.action.event.ExecuteEventSubmit;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.entity.db.DBNodeSignalTrigger;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.pool.XMLTodoPub;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.DateUtil;

/**
 * 信号处理
 * @author liangjw
 * @version 1.0
 * @since hzwf v7.0
 *
 */
public class SignalProcess implements ISignalProcess{
	public Object doSignalProcess(Signal signal){
		StaticFunExtend.println("[msg]signal start.");				
		String identifier = signal.getIdentifier();
		if(StringUtilExtend.isNull(identifier)){
			StaticFunExtend.println("[msg]user default identifier system.");
			identifier = StaticVarExtend.DefaultIdentifier;
		}
		String para = signal.getSignalPara();
		if(StringUtilExtend.isNotNull(para)){
			StaticFunExtend.println("[msg]signal para:" + para + ".");
			String sql = "select * from " + StaticVarExtend.Table_Node_Signal_Trigger + " where signal_para=? and status=?";
			List<Object> conditionList = new ArrayList<Object>();
			conditionList.add(para);
			conditionList.add("1");//可执行
			List<DBNodeSignalTrigger> triggers =  AccessUtil.getInstance()
					.getMultiObject(sql, conditionList, DBNodeSignalTrigger.class, identifier);
			if(null == triggers){
				StaticFunExtend.println("[msg]signal trigger is null.");				
				return signal;
			}
			StaticFunExtend.println("[msg]signal trigger size:"+triggers.size()+".");				
			for(int i=0,n=triggers.size();i<n;i++){
				DBNodeSignalTrigger t = triggers.get(i);
				Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
				String signalType = t.getSignalType();
				StaticFunExtend.println("[msg]signalType:"+signalType+".");				
				if(signalType.equals(StaticVarExtend.Signal_Event_Type_Node)){//事件节点自动提交
					String workid = t.getWorkid();
					String trackid = t.getTrackid();
					String nodeid = t.getNodeid();
					ExecuteEventSubmit eventSubmit = new ExecuteEventSubmit(workid, trackid, nodeid, identifier);
					eventSubmit.excuteSubmit();
					int result = eventSubmit.getWorkResult().getResult();
					if(StaticVarExtend.F_STATUS_Success == result){
						deleteTrigger(t, saveMap);
						addTriggerLog(t, saveMap);
					}
				}else if(signalType.equals(StaticVarExtend.Signal_Type_Flow)){//开始节点信号启动
					if(autoSubmitFlow(t, identifier)){
						addTriggerLog(t, saveMap);
					}
				}else if(signalType.equals(StaticVarExtend.Activation_Type_Node)){//信号激活
					if(activeTrigger(t, identifier)){
						deleteTrigger(t, saveMap);
						addTriggerLog(t, saveMap);
//						makeLog(saveMap,t.getWorkid(), t.getTrackid(), "信号激活", identifier);
					}
				}
				if( AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier)){
					XMLTodoPub.startThreadForNoActiveMsg(t.getWorkid(), t.getTrackid(), identifier);
				}

			}
		}		
		StaticFunExtend.println("[msg]signal end.");				
		return signal;
	}
	
	/**
	 * 激活不活动的节点
	 * @param tb
	 * @return
	 */
	private boolean activeTrigger(DBNodeSignalTrigger t,String identifier) {
		try{
			String ic = t.getSignalClass();
			return ActionCommon.getInstance().activeTrigger(t.getWorkid(),  t.getTrackid(),"Signal", ic, identifier);
		}catch(Exception e){
			e.printStackTrace();
			return false;
		}
	}

	
	/**
	 * 删除记录
	 * @param t
	 * @param saveMap
	 */
	private void deleteTrigger(DBNodeSignalTrigger t, Map<String, List<Object>> saveMap){
		saveMap.put("delete from " + StaticVarExtend.Table_Node_Signal_Trigger +" where id='"+t.getId()+"'", null);
	}

	/**
	 * 执行成功后将记录存入succes表,并且删除原有记录
	 * @param tb
	 */
	private void addTriggerLog(DBNodeSignalTrigger log, Map<String, List<Object>> saveMap) {
		log.setTriggerTime(DateUtil.getNow());
		log.setStatus("2");
		log.setId(StaticFunExtend.getUnid());
		saveMap.putAll(log.getLogSQL());
	}
	/**
	 * 信号启动实例,自动提交流程
	 * @param identifier
	 * @return
	 */
	private boolean autoSubmitFlow(DBNodeSignalTrigger t,String identifier) {
		StaticFunExtend.println("[msg]excute signal submit start.");				
		IWorkflowOperator operator = WorkflowFactory.getWorkflowOperator();	//流程操作对象
		WorkParaBean workParaBean = new WorkParaBean();			//操作参数对象
		workParaBean.setUserId(StaticVarExtend.System_Id);
//		workParaBean.setUserName(StaticVarExtend.System_Name);
		workParaBean.setFunname("autofirst");
		workParaBean.setFlowIdentifier(identifier);			//流程数据的数据源
	  	workParaBean.setDataIdentifier(identifier);			//业务数据的数据源
	  	workParaBean.setFlowId(t.getFlowid());
	  	IWorkResult wr = operator.create(workParaBean); 
        if (wr.getResult() == 100) {
            operator.close(wr.getWorkid(), wr.getCurTrackInfo().getId(), StaticVarExtend.System_Id);
            StaticFunExtend.println("[msg]excute signal submit success.");
            return true;
        }
        try{
            //避免getCurTrackInfo()为null时出现的问题
            operator.close(wr.getWorkid(), wr.getCurTrackInfo().getId(), StaticVarExtend.System_Id);
        }
        catch(Exception e){
            e.printStackTrace();
        }
        StaticFunExtend.println("[msg]excute signal submit error,result:"+wr.getResult()+";msg:"+wr.getBackMsg());
        return false;
	}

}
