package com.horizon.wf.expand.signal;

import java.util.Observable;
import java.util.Observer;

import com.horizon.wf.global.StaticFunExtend;

/**
 * 信号处理器，负责接收信号
 * 
 * 然后根据信号要求的处理类型
 * 
 * 实时发送给引擎处理或放入线程队列处理
 * 
 * 
 *  2013-7-5
 */
public class SignalObserver implements Observer {

	public void update(Observable o, Object signalObj) {
		Signal signal = (Signal) signalObj;
		StaticFunExtend.println(">>>>>>>开始处理,执行类型：" + signal.getSignalType());
		if ("0" == signal.getSignalType()) {
			ISignalProcess isp = new SignalProcess();
			isp.doSignalProcess(signal);
		} else if("1" == signal.getSignalType()) {
			SignalStaticArea.threadPool.execute(new SignalProcessRunable(
					signal));
			signal.setResult("收到了，我一会再处理。" + signal.getSignalName());
		}
		StaticFunExtend.println(">>>>>>>处理完成,执行结果：" + signal.getResult());
	}

}
