package com.horizon.wf.expand.node;

import java.util.ArrayList;
import java.util.List;

import com.horizon.wf.core.node.base.NodeSingle;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
/**
 * 单人处理节点
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class NodeSingleImpl extends NodeSingle {

	public void setChangeRule() {
		setChangeRule(getRunningData().getCurUser().getAuthName(), StaticVarExtend.AUTH_DONE);
		setOtherChangeRule(getRunningData().getCurUser().getAuthName(), StaticVarExtend.AUTH_CREADER);
		setOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR, StaticVarExtend.AUTH_CREADER);
	}
	/**
	 * 当前节点处理
	 * 返回:true,可以离开当前节点,false当前节点处理未结束
	 */
	public boolean doCurNode() {
		setChangeRule();
		RunningData runningdata = getRunningData();
		IRunUser curUser = runningdata.getCurUser();
		//20170307 liys 一次获取数据
		List<String> authNames = new ArrayList<String>(2);
		authNames.add(curUser.getAuthName());
		authNames.add(StaticVarExtend.AUTH_SECOND_AUTHOR);
		List<DBWorkAuth> allLst = runningdata.getXsAuthListForGet(authNames);
		List<DBWorkAuth> authorLst = new ArrayList<DBWorkAuth>();
		List<DBWorkAuth> secondLst = new ArrayList<DBWorkAuth>();
		splitArray(allLst,authorLst,secondLst);
		
		if(!(authorLst == null || authorLst.isEmpty())){
			//从list中获取参与者信息,根据实际需要进行修改(比如,办理人变为已办人)
			//规则:DBWorkAuth.getStatus() 不为空表示插入新的权限,DBWorkAuth.getOldStatus()不为空表示删除旧的权限
			boolean noHaveMe = true; //在办理人为非人员的时候,可能无法记录当前人的信息
			int nodenum = 0, authno = 0;
			for(int i=0,n=authorLst.size();i<n;i++){
				DBWorkAuth auth = authorLst.get(i);
				if(auth.equalsRunUser(curUser)){
					noHaveMe = false;
					auth.setStatus(getChangeRule(auth.getStatus()));				 //添加新的权限,自动给oldStatus赋值为原来的status
				}
				else {
					auth.setStatus(getOtherChangeRule(auth.getStatus()));				//其他计划办理人,修改为读者
				}
				nodenum = auth.getNodenum();
				authno  = auth.getAuthNo();
			}
			if(noHaveMe){
				//增加当前办理人的已办记录
				DBWorkAuth newDone = addNewAuth(curUser.getUserid(),nodenum,authno,curUser.getAuthName());
				newDone.setStatus(curUser.getAuthName());
				newDone.setStatus(StaticVarExtend.AUTH_DONE);
				newDone.setAuthType(StaticVarExtend.UserFix);
				authorLst.add(newDone);
			}
		}
		//协办处理
		if(!(secondLst == null || secondLst.isEmpty())){
			for(int i=0,n=secondLst.size();i<n;i++){
				DBWorkAuth auth = secondLst.get(i);
				auth.setStatus(getOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR));
				authorLst.add(auth);
			}
		}
		
		runningdata.setCurAuthToMap(authorLst);
		runningdata.getCurTrack().setEnd(true);
		return true;
	}
	
	private void splitArray(List<DBWorkAuth> allLst,List<DBWorkAuth> authorLst,List<DBWorkAuth> secondLst){
		for(int i=0,n=allLst.size();i<n;i++){
			DBWorkAuth auth = allLst.get(i);
			if(auth.getStatus().equals(StaticVarExtend.AUTH_SECOND_AUTHOR)){
				secondLst.add(auth);
			}
			else{
				authorLst.add(auth);
			}
		}
	}
	
	/**
	 * 构造一个新的办理人
	 * @return
	 */
	private DBWorkAuth addNewAuth(String author,int nodenum, int authno,String authname) {
		DBWorkAuth newAuth = new DBWorkAuth();
		newAuth.setAuthId(author);
		newAuth.setAgentId("");
		newAuth.setAuthNo(authno);
		newAuth.setId(StaticFunExtend.getUnid());
		newAuth.setNodeid(getNodeid());
		newAuth.setOldStatus("");
		newAuth.setStatus(authname);
		newAuth.setTrackid(getRunningData().getCurTrack().getId());
		newAuth.setWorkid(getRunningData().getWork().getId());
		newAuth.setNodenum(nodenum);
		return newAuth;
	}
}
