package com.horizon.wf.expand.node;

import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.ITaskNode;
import com.horizon.wf.core.node.base.ActionNode;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.definition.tools.NodeTypeEnum;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.INodeUser;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
/**
 * 逐级审批
 * @author liys
 * @version 1.0
 * @since v7.2.3
 */
public class NodeProgressivelyImpl extends ActionNode implements ITaskNode{
	public void setChangeRule() {
		setChangeRule(getRunningData().getCurUser().getAuthName(), StaticVarExtend.AUTH_DONE);
		setOtherChangeRule(getRunningData().getCurUser().getAuthName(), StaticVarExtend.AUTH_CREADER);
		setOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR, StaticVarExtend.AUTH_CREADER);
	}

	/**
	 * 当前节点处理
	 * 返回:true,可以离开当前节点,false当前节点处理未结束
	 */
	@SuppressWarnings("unchecked")
	public boolean doCurNode() {
		setChangeRule();
		RunningData runningdata = getRunningData();
		DBTrack curTrack = runningdata.getCurTrack();
		IRunUser curUser = runningdata.getCurUser();
		WorkParaBean wpb = (WorkParaBean)runningdata.getWorkParaBean();
		List<DBWorkAuth> list = runningdata.getXAuthListForCurNode(curUser.getAuthName());
		if(CollectionUtil.isListNotEmpty(list)){
			//从list中获取参与者信息,根据实际需要进行修改(比如,办理人变为已办人)
			//规则:DBWorkAuth.getStatus() 不为空表示插入新的权限,DBWorkAuth.getOldStatus()不为空表示删除旧的权限
			for(int i=0,n=list.size();i<n;i++){
				DBWorkAuth auth = list.get(i);
				if(auth.equalsRunUser(curUser)){
					auth.setStatus(getChangeRule(curUser.getAuthName()));				 //添加新的权限,自动给oldStatus赋值为原来的status
				}
			}
		}
		Map<String,String> authorMap = new LinkedHashMap<String, String>();
		boolean isPass = true;	//是否通过
		//判断是否从前台传入了办理人,如果传入了办理人,则跟设置了处理类一样处理,
		Map<String, String> selectedUsers = wpb.getSelectAuthorMap();
		String key = getCurNode().getKeyid()+StaticVarExtend.MARK_NODE_USER+curUser.getAuthName();
		String users = selectedUsers.get(key);
		
		if(StringUtilExtend.isNotNull(users)){
			//把前台传入的map拷贝到临时map中
			authorMap.putAll(selectedUsers);
		}
		else{
			users = selectedUsers.get(curUser.getAuthName());
			if(StringUtilExtend.isNotNull(users)){
				selectedUsers.put(key, users);
				selectedUsers.remove(curUser.getAuthName());
				
				//把前台传入的map拷贝到临时map中
				authorMap.putAll(selectedUsers);
			}
			else{
				//如果前台没有传入办理人,则判断是否有接口类
				String className = getFlowNode().getProgressivelyClassName();//"com.horizon.wf.expand.impl.example.ProgressiceInterfaceExample";//
				if(StringUtilExtend.isNotNull(className)){
					IBaseRule br = InterfaceFactory.getNewInterface(className);
					br.setParameter(StaticVarExtend.Parameter_DBWork, runningdata.getWork());
					br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);//设置前后台对象到接口
					br.setParameter(StaticVarExtend.Parameter_Current_IFlowNode, getFlowNode());//逐级审批节点
					br.setParameter(StaticVarExtend.Parameter_RunUser, curUser);//当前操作者
					br.setParameter(StaticVarExtend.Parameter_Progressive_Userid, curUser.getUserid());//(提交到逐级审批节点的人员id)
					br.setRunningData(runningdata);
					
					if(br.executeRule()){
						authorMap = (Map<String,String>)br.getResult();
					}
				}
			}
		}
		if(CollectionUtil.isMapNotEmpty(authorMap)){
			isPass = false;	//说明当前节点仍然有其他办理人未处理
			List<INodeUser> ulist = new ArrayList<INodeUser>();
			//放入当前节点 参数中
			setListUserByNodeInit(ulist);
			DBWork work = runningdata.getWork();
			String identifier =runningdata.getInitData().getFlowIdentifier();
			INodeAuthUser xmluser = getFlowNode().getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
			boolean isGetAgent = false;
			if(null != xmluser && xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
				isGetAgent = true;
			}
			
			for(Map.Entry<String, String> entry : authorMap.entrySet()){
				INodeUser nUser = InterfaceFactory.getNewInterface("com.horizon.wf.entity.run.NodeUser");//创建一个新的节点用户
				ulist.add(nUser);
				String auth = entry.getKey();
				String[] authNode = auth.split(StaticVarExtend.MARK_NODE_USER);
				if(authNode.length>1){
					auth = authNode[1];
				}
				nUser.setAuthType(auth);
				String user = entry.getValue();
				
				//获取代理人20160308
				if(auth.equals(StaticVarExtend.AUTH_AUTHOR) && StringUtilExtend.isNotNull(user)){
					//20161226 liys 限定只能有一个办理人
					List<AuthUserImpl> userArr = AuthUserImpl.getAuthUserList(user);
					user = userArr.get(0)._getFullNameWithAgent();
					selectedUsers.put(key, user);
					
					if(isGetAgent){
						user = AgentUtil.getInstance().getAgentUser(user,work.getId() , work.getFlowid(),identifier);	
					}
				}
				
				nUser.setOpenUrl(wpb.getUrlApp());
				nUser.setSendTitle(runningdata.getTitle());
				nUser.setPlanid(user);
				nUser.setNowid(user);					
				//nUser.setSendType(hc.getWorkParaBean().getMsgSendFlag());
			}
			//当前节点权限处理
			doNodeUserForCurNode(list);
		}
		
		curTrack.setEnd(isPass);
		//当前路径结束时,对协办进行处理
		if(runningdata.getCurTrack()._isEnd()){
			List<DBWorkAuth> sList = runningdata.getXAuthListForGet(StaticVarExtend.AUTH_SECOND_AUTHOR);
			if(!(sList == null || sList.isEmpty())){
				for(int i=0,n=sList.size();i<n;i++){
					DBWorkAuth auth = sList.get(i);
					auth.setStatus(getOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR));
					list.add(auth);
				}
			}
			runningdata.setCurAuthToMap(list);
		}
		
		return isPass;
	}
	
	final public int getActionType() {
		return NodeTypeEnum.Node_Single;
	}
	/**
	 * 在节点进入时,需要额外处理的数据
	 * @return
	 */
	public Map<String, List<Object>> dataForCurNodeLeave() {
		return null;
	}
}
