package com.horizon.wf.expand.node;

import com.horizon.wf.api.AgentUtil;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.base.NodeOrder;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.definition.pub.node.INodeAuthUser;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.INodeUser;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;

import java.util.ArrayList;
import java.util.List;

public class NodeOrderImpl extends NodeOrder{

	private boolean isPass = true;//是否通过
	public void setChangeRule() {
		setChangeRule(getRunningData().getCurUser().getAuthName(), StaticVarExtend.AUTH_DONE);
		if(isPass){
			setOtherChangeRule(getRunningData().getCurUser().getAuthName(), StaticVarExtend.AUTH_CREADER);
			setOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR, StaticVarExtend.AUTH_CREADER);
		}
	}
	/**
	 * 当前节点处理
	 * 返回:true,可以离开当前节点,false当前节点处理未结束
	 */
	public boolean doCurNode() {
		setChangeRule();
		RunningData runningdata = getRunningData();
		IRunUser curUser = runningdata.getCurUser();
		//所有未办列表
		List<DBWorkAuth> list = runningdata.getXAuthListForCurNode(StaticVarExtend.AUTH_AUTHOR);
		DBTrack curTrack = runningdata.getCurTrack();
		
		 //拿回时,因为当前节点已经办理过,所以需要置空,避免数组越界,
		 //在从分支上拿回的到时候,由于是恢复之前的分支,所以节点所在位置没有变化,造成原来trackNode无变化
		//20161109修改了分支拿回时(7.2.2之后版本生效),重新创建分支来避免,所以下面的例外可以去掉了
//		if(curTrack.getFlowstatus() == StaticVarExtend.FlowStatus_GetBack){
//		    isPass = true;
//		}
//		else
		{
		   boolean result = checkNextAuthor(curTrack,curUser,list);
		   if(!result){
		       return false;
		   }
		}
		
		if(CollectionUtil.isListNotEmpty(list)){
            //从list中获取参与者信息,根据实际需要进行修改(比如,办理人变为已办人)
            //规则:DBWorkAuth.getStatus() 不为空表示插入新的权限,DBWorkAuth.getOldStatus()不为空表示删除旧的权限
			for(int i=0,n=list.size();i<n;i++){
				DBWorkAuth auth = list.get(i);
                if(auth.equalsRunUser(curUser)){
                    auth.setStatus(getChangeRule(curUser.getAuthName()));                //添加新的权限,自动给oldStatus赋值为原来的status
                }
            }
        }
		//当前节点是否完毕
		curTrack.setEnd(isPass);
		//当前路径结束时,对协办进行处理
		if(isPass){
			List<DBWorkAuth> sList = runningdata.getXAuthListForGet(StaticVarExtend.AUTH_SECOND_AUTHOR);
			if(CollectionUtil.isListNotEmpty(sList)){
				for(int i=0,n=sList.size();i<n;i++){
					DBWorkAuth auth = sList.get(i);
					auth.setStatus(getOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR));
					list.add(auth);
				}
			}
			runningdata.setCurAuthToMap(list);
		}
		return isPass;
	}
	
	private boolean checkNextAuthor(DBTrack curTrack,IRunUser curUser,List<DBWorkAuth> list){
		ITrackNodeJson trackNode = curTrack._getTrackNode();
        //获取所有办理人
        ITrackUserJson trackUser = trackNode.getTrackUserImpl(curUser.getAuthName());
        String allplan = trackUser.getPlanId();;
        List<AuthUserImpl> allPlanList = AuthUserImpl.getAuthUserList(allplan);
		ITrackUserJson  trackRdyUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,curUser.getAuthName());
        String rdy = trackRdyUser.getNowId();
        //获取已经办理人
        List<AuthUserImpl> rdyDoneList = AuthUserImpl.getAuthUserList(rdy);
        int m = rdyDoneList.size();//查找当前办理人位置
        if(m >= allPlanList.size()){
            setInitResult(StaticVarExtend.F_STATUS_OtherError);
            setBackMsg("已办理人数超过应办理人数.");
            return false;
        }
        AuthUserImpl pUser = allPlanList.get(m);
        AuthUserImpl rUser = AuthUserImpl.getAuthUserByStr(curUser.getFullName());
        if(!rUser.isSameAuthWithoutAgentid(pUser)){
            setInitResult(StaticVarExtend.F_STATUS_OtherError);
            setBackMsg("当前办理人位置不符合顺签顺序.");
            return false;
        }
        
        m++;
        
        //获取下一个办理人
        if(m < allPlanList.size()){
            isPass = false; //说明当前节点仍然有其他办理人未处理
            String posUser = allPlanList.get(m)._getFullNameWithAgent();
			INodeAuthUser xmluser = getFlowNode().getParticipantsUser(StaticVarExtend.AUTH_AUTHOR);
            if(null != xmluser && xmluser.getControlAttribute().indexOf(StaticVarExtend.Node_Control_AgentFlag) != -1){
                DBWork work = getRunningData().getWork();
                posUser = AgentUtil.getInstance().getAgentUser(posUser, work.getId(), work.getFlowid(), getRunningData().getInitData().getFlowIdentifier());                                
            }
            //HZWF-1424 20170524 liys
            //此处需要对是否有代理人进行处理,如果有代理人,需要对planId进行变更,
            //否则后面的程序会因为办理人不在planId中而进行追加
            //比如:原来PlanID=A;B;C,现在B代理给D那么后面的程序在A;B;C中是不能匹配到B~D的,
            //程序就会在A;B;C的后面加上B~D,然后就变成A;B;C;B~D,办理人也由3个变到4个了
            checkAgentAndChgPlanId(trackUser,allPlanList,posUser,m);
            
            List<INodeUser> ulist = new ArrayList<INodeUser>();
            //放入当前节点 参数中
            setListUserByNodeInit(ulist);

//=======================================
//  根据实际情况进行节点用户初始化     
//=======================================   
            INodeUser nUser = InterfaceFactory.getNewInterface("com.horizon.wf.entity.run.NodeUser");//创建一个新的节点用户
            ulist.add(nUser);
            
            nUser.setAuthType(curUser.getAuthName());
            nUser.setPlanid(posUser);
            nUser.setNowid(posUser);
            nUser.setOpenUrl("");
            nUser.setSendTitle("");
            nUser.setSendType("");
//=======================================           
            //当前节点权限处理
            doNodeUserForCurNode(list);
        }
        return true;
	}
	
	/**
	 * 检查获取代理人后,是否跟原来的办理人一样,如果不一致则修改planid
	 */
	private void checkAgentAndChgPlanId(ITrackUserJson  trackUser,List<AuthUserImpl> allPlanList,String posUser,int m){
		//HZWF-1424 20170524 liys
        //此处需要对是否有代理人进行处理,如果有代理人,需要对planId进行变更,
        //否则后面的程序会因为办理人不在planId中而进行追加
        //比如:原来PlanID=A;B;C,现在B代理给D那么后面的程序在A;B;C中是不能匹配到B~D的,
        //程序就会在A;B;C的后面加上B~D,然后就变成A;B;C;B~D,办理人也由3个变到4个了
		if(posUser.equals(allPlanList.get(m)._getFullNameWithAgent())){
			return;
		}
		AuthUserImpl newAuth = AuthUserImpl.getAuthUserByStr(posUser);
		allPlanList.remove(m);
		allPlanList.add(m, newAuth);
    	
    	//重新获取所有PlanId字符串
    	StringBuilder sb = new StringBuilder(200);
    	for(int i=0,n= allPlanList.size();i<n;i++){
    		sb.append(allPlanList.get(i)._getFullNameWithAgent()).append(StaticVarExtend.UserSplitChar);
    	}
    	//写回到xml中
    	getRunningData().setPlanId_ForTrackUser(trackUser, sb.toString());
	}
	
}
