package com.horizon.wf.expand.node;

import java.util.ArrayList;
import java.util.List;

import com.horizon.wf.core.node.base.NodeSingle;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.StaticVarExtend;
/**
 * 单人处理节点
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class NodeMultiSingleImpl extends NodeSingle {

	public void setChangeRule() {
		String authName = getRunningData().getCurUser().getAuthName();
		setChangeRule(authName, StaticVarExtend.AUTH_DONE);
		setOtherChangeRule(authName, StaticVarExtend.AUTH_CREADER);
		setOtherChangeRule(StaticVarExtend.AUTH_HUIQIAN+authName, StaticVarExtend.AUTH_CREADER);
		setOtherChangeRule(StaticVarExtend.AUTH_HUIQIAN_CREATOR+authName, StaticVarExtend.AUTH_CREADER);
		setOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR, StaticVarExtend.AUTH_CREADER);
	}
	/**
	 * 当前节点处理
	 * 返回:true,可以离开当前节点,false当前节点处理未结束
	 */
	public boolean doCurNode() {
		setChangeRule();
		RunningData runningdata = getRunningData();
		IRunUser curUser = runningdata.getCurUser();
		String authName = curUser.getAuthName();
		
		List<String> authNameLst = new ArrayList<String>(4);
		authNameLst.add(authName);
		authNameLst.add(StaticVarExtend.AUTH_SECOND_AUTHOR);
		authNameLst.add(StaticVarExtend.AUTH_HUIQIAN		 + authName);
		authNameLst.add(StaticVarExtend.AUTH_HUIQIAN_CREATOR + authName);
		
		List<DBWorkAuth> list = runningdata.getXsAuthListForGet(authNameLst);
		
		if(!(list == null || list.isEmpty())){
			//从list中获取参与者信息,根据实际需要进行修改(比如,办理人变为已办人)
			//规则:DBWorkAuth.getStatus() 不为空表示插入新的权限,DBWorkAuth.getOldStatus()不为空表示删除旧的权限
			for(int i=0,n=list.size();i<n;i++){
				DBWorkAuth auth = list.get(i);
				if(auth.equalsRunUser(curUser)){
					auth.setStatus(getChangeRule(auth.getStatus()));				 //添加新的权限,自动给oldStatus赋值为原来的status
				}
				else {
					auth.setStatus(getOtherChangeRule(auth.getStatus()));				//其他计划办理人,修改为读者
				}
			}
		}
		
		runningdata.setCurAuthToMap(list);
		runningdata.getCurTrack().setEnd(true);
		return true;
	}
}
