package com.horizon.wf.expand.node;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.base.NodeMulti;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.track.json.impl.ITrackNodeJson;
import com.horizon.wf.core.track.json.impl.ITrackUserJson;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.entity.user.impl.AuthUserImpl;
import com.horizon.wf.global.StaticVarExtend;

import java.util.ArrayList;
import java.util.List;

/**
 * 多人处理节点
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class NodeMultiImpl extends NodeMulti {
	private boolean isPass = true;
	public void setChangeRule() {
		String authName = getRunningData().getCurUser().getAuthName();
		setChangeRule(authName, StaticVarExtend.AUTH_DONE);
		if(isPass){
			setOtherChangeRule(authName, StaticVarExtend.AUTH_CREADER);
			setOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR, StaticVarExtend.AUTH_CREADER);
		}
	}
	
	public boolean doCurNode() {
		//setChangeRule();
		RunningData runningdata = getRunningData();
		IFlowNode xmlNode = runningdata.getCurFlowNode();
		IRunUser curUser = runningdata.getCurUser();

		//所有未办列表,包含协办
		List<DBWorkAuth> list = runningdata.getListAuthLikeAuthorByTrackid(runningdata.getCurTrack().getId());
		List<DBWorkAuth> sencondList = getSecondAuth(list);
		List<DBWorkAuth> returnAuthlist = new ArrayList<DBWorkAuth>();
		int asyn = xmlNode.getAsyn();
		if(asyn == 0){
			//同步处理
			doNormal(runningdata,xmlNode,curUser,list,returnAuthlist);
		}
		else{
			setChangeRule();
			//异步处理时
			int m = 0;
			for(int i=0,n=list.size();i<n;i++){
				DBWorkAuth auth = list.get(i);
				if(auth.equalsRunUser(curUser) && auth.getStatus().equals(StaticVarExtend.AUTH_AUTHOR)){
					auth.setStatus(getChangeRule(StaticVarExtend.AUTH_AUTHOR));				 //添加新的权限,自动给oldStatus赋值为原来的status
					returnAuthlist.add(auth);
				}
				else{
					m ++;
				}
			}
			//20170707 liys 增加对异步节点进行办理人员多少的判断,如果只有一个办理人,则不进行异步处理
			//仅在m=0时进行判断(也包含最后一个处理时)
			if(m == 0){
				DBTrack curTrack = runningdata.getCurTrack();
				ITrackNodeJson trackNode = curTrack._getTrackNode();
				int allNum = getAllParticipantNum(curTrack, curUser, trackNode);//所有参与者- 主办
				if(allNum == 1){
					//只有一个办理人时,对asyn进行重置为0,修改的目的:后面的路径不需要进行异步处理
					//修改当前节点的异步状态为0非异步执行
					runningdata.chgCurNodeAsyn(0);
				}
			}
			runningdata.getCurTrack().setEnd(m==0);
			//isPass = (m==0);
		}
		//当前路径结束时,对协办进行处理
		if(runningdata.getCurTrack()._isEnd()){
			if(!(sencondList == null || sencondList.isEmpty())){
				for(int i=0,n=sencondList.size();i<n;i++){
					DBWorkAuth auth = sencondList.get(i);
					auth.setStatus(getOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR));
					returnAuthlist.add(auth);
				}
			}
		}
		
		runningdata.setCurAuthToMap(returnAuthlist);
		return isPass;
	}
	private void doNormal(RunningData runningdata,IFlowNode xmlNode,IRunUser curUser,List<DBWorkAuth> list,List<DBWorkAuth> returnAuthlist){
		DBTrack curTrack = runningdata.getCurTrack();
		//1.获取所有计划处理人
		//多人并行节点离开:1.参与者超过X个已处理,2.指定处理人中的任意一个已处理,3.指定处理人全部处理,4.所有参与者已处,5.扩展规则
		int passtype = xmlNode.getDoPassType();
		String para  = xmlNode.getDoPassParameter();
		ITrackNodeJson trackNode = curTrack._getTrackNode();
		int m = getAllParticipantNum(curTrack, curUser, trackNode);//所有参与者- 主办
		//获取当前人是否有代办的情况
		int needAddDoneNum = getNeedAddDoneNum(curUser,list);
		
		int rdy = m - list.size() + needAddDoneNum;//已办人
		if(rdy<=0){ //因为会签的干扰,list.size可能会大于
			rdy =1;
		}
		WorkParaBean wpb = (WorkParaBean)runningdata.getWorkParaBean();
		switch(passtype){
			case 1://参与者超过X个已处理
				//转换参数设置
				int iPara = Integer.parseInt(para);
				//如果所有人都已办，但是参数设置大于所有已办，则通过
				if(m == rdy && m < iPara){
					break;
				}
				if((rdy) < iPara){
					isPass = false;break;
				}
				break;
			case 2://指定处理人中的任意一个已处理
				if(rdy == m){ //指定的人不在办理人列表中时,会出现
					setInitResult(StaticVarExtend.F_STATUS_OtherError);
					setBackMsg(PubInfo.getPubInfo(runningdata.getLangInfo())
							.getInfo("Multi_Msg0001","办理人已处理完毕，不符合提交至下一节点的条件."));
				}
				List<AuthUserImpl> pusers = AuthUserImpl.getAuthUserList(para);
				AuthUserImpl curUserAuth = AuthUserImpl.getAuthUserByStr(curUser.getFullName());
				boolean isHave = false;
				for(int i=0,n=pusers.size();i<n;i++){
					AuthUserImpl puser = pusers.get(i);
					if(curUserAuth.equalsAuth(puser)){ // 直接判断当前人是否为在设置的参与者列表中,
						isHave = true;
						break;
					}
				}
				isPass = isHave;
				
				break;
			case 3://指定参与者全部处理
				if(rdy == m){
					setInitResult(StaticVarExtend.F_STATUS_OtherError);
					setBackMsg(PubInfo.getPubInfo(runningdata.getLangInfo())
							.getInfo("Multi_Msg0001","办理人已处理完毕，不符合提交至下一节点的条件."));
				}
				//已办人员
				ITrackUserJson trackRdyUser = trackNode.getTrackUserImpl(StaticVarExtend.AUTH_DONE,curUser.getAuthName());
				String rdyuser = trackRdyUser.getNowId()+StaticVarExtend.UserSplitChar+curUser.getFullName();
				//定制工具设置的人员
				List<AuthUserImpl> pallusers = AuthUserImpl.getAuthUserList(para);
				List<AuthUserImpl> rdyusers = AuthUserImpl.getAuthUserList(rdyuser);
				for(int i=0,n=pallusers.size();i<n;i++){
					AuthUserImpl puser = pallusers.get(i);
					boolean noHave = true;
					for(int j=0,t=rdyusers.size();j<t;j++){
						AuthUserImpl rdyall = rdyusers.get(j);
						if(rdyall.equalsAuth(puser)){
							noHave =false;
							break;
						}
					}
					//puser 不在已办理列表中,则返回false
					if(noHave){
						isPass = false;
						break;
					}
				}
				break;
			case 4://参与者百分比
				//获取所有办理人
				if(Integer.parseInt(para)>getDonePresent(m, rdy)){
					isPass = false;
				}
				break;
			default:
				IBaseRule br = InterfaceFactory.getNewInterface(para);
				br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);//设置前后台对象到接口
				br.setParameter(StaticVarExtend.Parameter_Current_IFlowNode, xmlNode);//当前节点
				br.setRunningData(runningdata);
				isPass = br.executeRule();

		}
		setChangeRule();
		//从list中获取参与者信息,根据实际需要进行修改(比如,办理人变为已办人)
		//规则:DBWorkAuth.getStatus() 不为空表示插入新的权限,DBWorkAuth.getOldStatus()不为空表示删除旧的权限
		StringBuilder authors = new StringBuilder(500);//未办理的人，供前台显示
		for(int i=0,n=list.size();i<n;i++){
			DBWorkAuth auth = list.get(i);
			if(auth.equalsRunUser(curUser) && auth.getStatus().equals(StaticVarExtend.AUTH_AUTHOR)){
				auth.setStatus(getChangeRule(curUser.getAuthName()));				 //添加新的权限,自动给oldStatus赋值为原来的status
				returnAuthlist.add(auth);
			}else{
				if(isPass){
					String otherChangeRule = getOtherChangeRule(curUser.getAuthName());
					auth.setStatus(otherChangeRule);				//其他计划办理人,修改为读者
					returnAuthlist.add(auth);
				}else{
					//不显示会签人
					if(!auth.getStatus().equals(StaticVarExtend.AUTH_HUIQIAN+curUser.getAuthName())){
						authors.append(auth._getFullNameWithAgent());
						authors.append(StaticVarExtend.UserSplitChar);						
					}
					auth.setStatus(null);
					auth.setOldStatus(null);
				}
			}
		}
		if(authors.length()>0){
			wpb.putSelectAuthor(this.getNodeid()+StaticVarExtend.MARK_NODE_USER+getRunningData().getCurUser().getAuthName(),authors.toString());
		}
		curTrack.setEnd(isPass);
	}
	/**
	 * 从list中获取协办的列表,并从list中删除
	 * @param list
	 * @return
	 */
	private List<DBWorkAuth> getSecondAuth(List<DBWorkAuth> list){
	    List<DBWorkAuth> sencondLst = new ArrayList<DBWorkAuth>();
	    for(int i=0,n=list.size();i<n;i++){
			DBWorkAuth auth = list.get(i);
            if(auth.getStatus().equals(StaticVarExtend.AUTH_SECOND_AUTHOR)){
                sencondLst.add(auth);
                continue;
            }
        }
        if(!sencondLst.isEmpty()){
            for(int i=0,n=sencondLst.size();i<n;i++){
            	DBWorkAuth auth = sencondLst.get(i);
                list.remove(auth);
            }
        }
        return sencondLst;
	}
	/**
	 * 获取当前人是否有代办的情况
	 * @param curUser
	 * @param list
	 * @return
	 */
	private int getNeedAddDoneNum(IRunUser curUser,List<DBWorkAuth> list){
		int num = 0;
		for(int i=0,n=list.size();i<n;i++){
			DBWorkAuth auth = list.get(i);
		    if(auth.equalsRunUser(curUser) && auth.getStatus().equals(StaticVarExtend.AUTH_AUTHOR)){
				num ++;
			}
		}
		return num;
	}
	
	/**
	 * 获取办理人数目
	 * @param curTrack
	 * @param curUser
	 * @param trackNode
	 * @return
	 */
	private int getAllParticipantNum(DBTrack curTrack,IRunUser curUser, ITrackNodeJson trackNode){
		//获取所有办理人
		ITrackUserJson  trackUser = trackNode.getTrackUserImpl(curUser.getAuthName());
		String[] users = trackUser.getPlanId().split(StaticVarExtend.UserSplitChar);
		
		//去掉空值
		int m = 0;//所有办理人
		for(int i=0,n=users.length;i<n;i++){
			if(users[i].trim().length()> 0){
				m ++;
			}
		}
		return m;
	}
	
	private static int getDonePresent(int allParticipant, int doneParticipant){
	    if(allParticipant == 0) return 0;
		float size = (float)doneParticipant/allParticipant;
		size = size*100;
		int result = (int)size;
		return result;
	}
}
