package com.horizon.wf.expand.node;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.base.NodeMerger;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWorkAuth;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticVarExtend;

import java.util.List;
/**
 * 合并节点
 * @author liys
 * @version 8.0
 * @since hz8.0
 *
 */
public class NodeMergerImpl extends NodeMerger {
	/**
	 * 当前节点处理
	 * @return 返回:true,可以离开当前节点,false当前节点处理未结束
	 */
	public boolean doCurNode() {
		setChangeRule();
		RunningData runningdata = getRunningData();
		IRunUser curUser = runningdata.getCurUser();

		boolean isPass = checkMergerNodeLeaveRule();

		String authName = curUser.getAuthName();
		//所有未办列表
		List<DBWorkAuth> list = runningdata.getXAuthListForCurNode(authName);
		if(isPass){
			if(CollectionUtil.isListNotEmpty(list)){
				for(int i=0,n=list.size();i<n;i++){
					DBWorkAuth auth = list.get(i);
					if(auth.equalsRunUser(curUser)){
						auth.setStatus(getChangeRule(authName));				 //添加新的权限,自动给oldStatus赋值为原来的status
					}
					else {
						auth.setStatus(getOtherChangeRule(authName));				//其他计划办理人,修改为读者
					}
				}
			}
			
			//当前路径结束时,对协办进行处理
			List<DBWorkAuth> sList = runningdata.getXAuthListForGet(StaticVarExtend.AUTH_SECOND_AUTHOR);
			if(!(sList == null || sList.isEmpty())){
				for(int i=0,n=sList.size();i<n;i++){
					DBWorkAuth auth = sList.get(i);
					auth.setStatus(getOtherChangeRule(StaticVarExtend.AUTH_SECOND_AUTHOR));
					list.add(auth);
				}
			}
			runningdata.setCurAuthToMap(list);
		}
		
		runningdata.getCurTrack().setEnd(isPass);
		return isPass;
	}

	private boolean checkMergerNodeLeaveRule(){
		RunningData runningdata = getRunningData();
		IFlowNode xmlNode = runningdata.getCurFlowNode();
		DBTrack curTrack = runningdata.getCurTrack();

		//如果是退回到合并节点或者合并节点拿回，则不需要验证离开规则
		int flowstatus = curTrack.getFlowstatus();
		boolean isPass = true;	//默认通过本节点
		if(!(StaticVarExtend.FlowStatus_Reject == flowstatus || StaticVarExtend.FlowStatus_GetBack == flowstatus
				|| curTrack._getTrackJson().getReactivateMerger())){
			//离开方式:1.分支已到X个,2.指定分支中任意一个到达,3.指定分支全部到达,4.所有分支到达,5.自行确定,6.扩展规则
			int leaveType 		= xmlNode.getMergerLeaveType();
			String leavePara 	= xmlNode.getMergerLeaveParameter();
			switch(leaveType){
				case 5:
					isPass = isLeaveMergerNode();
					break;
				case 6:
					try{
						WorkParaBean wpb = (WorkParaBean)runningdata.getWorkParaBean();
						IBaseRule br = InterfaceFactory.getNewInterface(leavePara);
						br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);//设置前后台对象到接口
						br.setParameter(StaticVarExtend.Parameter_Current_IFlowNode, xmlNode);//当前节点
						br.setParameter(StaticVarExtend.Parameter_Merger_IFlowNode,	getFlowNode());//进入的节点
						br.setRunningData(runningdata);
						isPass = br.executeRule();
					}catch(Exception e){

						isPass = false;
					}
					break;
				default:
					//根据配置信息处理是否允许离开合并
					isPass = runningdata.checkMergerNodeLeaveRule();
			}
		}
		return isPass;
	}

	/**
	 * 自行确定是否离开合并节点,默认为true
	 * 如果项目上有需要,可以在此方法中增加逻辑判断
	 * @return
	 */
	public boolean isLeaveMergerNode(){
		return true;
	}
		
}
