package com.horizon.wf.expand.node;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.base.NodeGateway;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;

import java.util.Map;

/**
 * 条件分支节点
 * 
 * @author liangjw
 * @version 1.0
 * @since v7.0
 */
public class NodeConditionImpl extends NodeGateway {
	/**
	 * 网关节点内部运算,返回节点是否允许通过 停留返回false,通过返回true 默认通过true
	 * 
	 * 分支时可以在此对流程变量进行赋值,以达到对后续分支进行筛选的目的 合并时可以在此进行各路分支是否到达以及到达条件是否满足的判断
	 */
	public boolean doCurNode() {
		boolean isPass = true;
		RunningData runningdata = getRunningData();
		
		IFlowNode node = getFlowNode();
		//网关实现方式
		String className = node.getGateWayClass();//实现类
		
		if(StringUtilExtend.isNotNull(className)){//java类
			try {
				WorkParaBean wpb = (WorkParaBean)runningdata.getWorkParaBean();
				IBaseRule br = InterfaceFactory.getNewInterface(className);
				br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);//设置前后台对象到接口
				if(br.executeRule()){
					Map<String, String> flowVarMap = wpb.getFlowVarMap();
					if(null != flowVarMap){
						for(Map.Entry<String,String> e : flowVarMap.entrySet()){
							runningdata.getFlowVar().setValue(e.getKey(), e.getValue());					
						}
					}
				}
			} catch (Exception e) {
				setBackMsg(PubInfo.getPubInfo(runningdata.getLangInfo()).getInfo("Gateway_Msg0003", "分支网关节点接口类执行失败!"));
				setInitResult(StaticVarExtend.F_STATUS_OtherError);
				isPass= false;
				INodeException exception = StaticFunExtend.getActionCommon().getExceptionByCode(StaticVarExtend.Exception_Code_GateWayNodeInterfaceError, getFlowNode().getExceptions());
				StaticFunExtend.getActionCommon().handleExceptionDelay(exception, getRunningData(), getFlowNode());
				runningdata.putMsgToConsole("[err]"+e.getClass());
				
			}
		} 
		
//		hc.addJumpNode(node);
//		hc.addJumpRouter(getFromXmlRouter());

		runningdata.getCurTrack().setEnd(isPass);
		return isPass;
	}
}
