package com.horizon.wf.expand.node;

import com.horizon.wf.core.node.base.NodeAuto;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.track.json.bean.TrackFormJsonImpl;
import com.horizon.wf.definition.pub.info.IFlowVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.StaticFunCore;
import com.horizon.wf.tools.CStrUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
/**
 * 自动节点
 * @author liangjw
 * @version 1.0
 * @since hz7.0
 */
public class NodeAutoImpl extends NodeAuto {
	public boolean doCurNode() {
		RunningData runningdata = getRunningData();
		runningdata.getCurTrack().setEnd(true);
		//自动提交时,如果有从表单字段获取值的变量,需要从数据库中获取并赋值到map中
		List<IFlowVar> vars = runningdata.getInstanceDefinition().getFlowinfo().getAllVar();
		if(!(vars == null || vars.isEmpty())){
			TrackFormJsonImpl trackForm = runningdata.getTrackFormInfo();
			Map<String,Object> hashMap = runningdata.getInitData().getHashMap();
			Map<String,Map<String,Object>> dataMap = new HashMap<String,Map<String,Object>>();
			Map<String,String> isLoad = new HashMap<String,String>();
			for (IFlowVar var:vars) {
				String from = var.getVarFrom();
				if(from.length()>0){
					String value = StaticFunCore.getObjFromHashMap(hashMap,from);
					if(value == null){
						String[] formfield = from.split(StaticVarExtend.Mark_Fix);
						Map<String,Object> map = dataMap.get(formfield[0]);
						boolean isLoadThis = "1".equals(isLoad.get(formfield[0]));
						if(map == null && !isLoadThis){
							String tableid = trackForm.getTableidByFormid(formfield[0]);
							String dataid  = trackForm.getDataidByFormid(formfield[0]);
							if(CStrUtil.isNull(tableid) || CStrUtil.isNull(dataid)){
								continue;
							}
							String sql = "select * from "+tableid+" where id = ?";
							List<Object> para = new ArrayList<Object>(1);
							para.add(dataid);
							map =  AccessUtil.getInstance().getSingleMap(sql, para, runningdata.getInitData().getDataIdentifier());
							isLoad.put(formfield[0], "1");
							dataMap.put(formfield[0], map);
						}
						if(map !=null){
							value = String.valueOf(map.get(formfield[1]));
						}
					}
					runningdata.putValueToHashMap(from,value);
				}
			}
		}
		return true;
	}
}
