package com.horizon.wf.expand.node;

import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.config.PubInfo;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.node.base.NodeGateway;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.definition.pub.node.INodeException;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.rule.jsr94.IRuleEngine;
/**
 * 合并网关
 * @author liangjw
 * @version 1.0
 * @since hz7.0
 */
public class GateWayMergeImpl extends NodeGateway {
	/**
	 * 当前节点处理 返回:true,可以离开当前节点,false当前节点处理未结束
	 */
	public boolean doCurNode() {
		setChangeRule();
		//运行期对象
		RunningData rd = getRunningData();
		//前后台交互对象
		//前台参数对象
		IFlowNode node = getFlowNode();
		boolean isPass = false;//是否可以通过本节点
		//网关实现方式
		String className = node.getGateWayClass();//实现类
		String script = node.getGateWayRule();//规则
		if(StringUtilExtend.isNotNull(className)){//java类
			isPass = classAction(rd);
		}
		else if(StringUtilExtend.isNotNull(script)){//规则
			isPass = scriptAction(rd);
		}
		//20170213 liys 修改:在自定义或者规则不满足的情况下,判断是否为最后一个分支到达
		if(!isPass)
		{
			//20150604liys增加默认实现方式,在没有类和规则的情况下,
			//如果分支全部到达,默认可以流转到下一节点,避免程序死在合并网关处
			isPass = rd.isLastTrackToGateWayMerge(this);
		}
		//网关有可能会跳过,需要判断是否为当前节点
		if(rd.getCurTrack().getNodeid().equals(this.getNodeid())){
			rd.getCurTrack().setEnd(isPass);
		}
		return isPass;
	}
	/**
	 * 自行编写类的方式处理
	 * @return
	 */
	private boolean classAction(RunningData rd){
		WorkParaBean wpb = (WorkParaBean)rd.getWorkParaBean();
		IFlowNode node = getFlowNode();
		String className = node.getGateWayClass();
		boolean isPass = false;
		try{
			IBaseRule br = InterfaceFactory.getNewInterface(className);
			br.setParameter(StaticVarExtend.Parameter_WorkParaBean, wpb);//设置前后台对象到接口
			br.setParameter(StaticVarExtend.Parameter_GateWay_Alltracks,rd.getAllTrackNeedToGateway(this));//设置所有分支路径信息到接口
			br.setParameter(StaticVarExtend.Parameter_GateWay_IFlowNode, node);
			br.setParameter(StaticVarExtend.Parameter_DBTrack,rd.getCurTrack());
			br.setParameter(StaticVarExtend.Parameter_DBWork,rd.getWork());
			br.setParameter(StaticVarExtend.Parameter_RunUser, rd.getCurUser());
			br.setRunningData(rd);
			isPass = br.executeRule();
			//获取是否有需要取消的分支,不管是否通过,都允许取消其他分支
			String cancelTrackIds = (String)br.getResult();
			if(StringUtilExtend.isNotNull(cancelTrackIds)){
				for(String trackid : cancelTrackIds.split(StaticVarExtend.StrSplitChar)){
					getRunningData().setCancelTrackid(trackid);
				}
			}			
			
		}catch(Exception e){
			setBackMsg(PubInfo.getPubInfo(rd.getLangInfo()).getInfo("Gateway_Msg0001", "合并网关节点接口类执行失败!"));
			setInitResult(StaticVarExtend.F_STATUS_OtherError);
			INodeException exception = StaticFunExtend.getActionCommon().getExceptionByCode(StaticVarExtend.Exception_Code_GateWayNodeInterfaceError, getFlowNode().getExceptions());
			StaticFunExtend.getActionCommon().handleExceptionDelay(exception, getRunningData(), getFlowNode());
			rd.putMsgToConsole("[err]"+e.getClass());
			
		}
		return isPass;
	}
	
	private boolean scriptAction(RunningData rd){
		IRuleEngine du = PluginsUtil.getMultiInstance().getRuleEngine();
		IFlowNode node = getFlowNode();
		String script = node.getGateWayRule();//规则
		boolean isPass = false;
		du.setPara("RunningData", rd);
		du.setPara("ITaskNode", this);
		try {
			Object rs = du.exctu(script);
			if(null != rs){
				String result = String.valueOf(rs);
				isPass = Boolean.valueOf(result);
			}
		} catch (Exception e) {
			e.printStackTrace();
			INodeException exception = StaticFunExtend.getActionCommon().getExceptionByCode(StaticVarExtend.Exception_Code_GateWayNodeInterfaceError, getFlowNode().getExceptions());
			StaticFunExtend.getActionCommon().handleExceptionDelay(exception, getRunningData(), getFlowNode());
			rd.putMsgToConsole("[err]"+e.getClass());
			setBackMsg(PubInfo.getPubInfo(rd.getLangInfo()).getInfo("Gateway_Msg0002", "合并网关节点规则运算异常!"));
			setInitResult(StaticVarExtend.F_STATUS_OtherError);
		}
		return isPass;
	}
	
}
