package com.horizon.wf.expand.msg;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.entity.db.DBNodeMessageTrigger;
import com.horizon.wf.global.StaticVarExtend;

public class FlowStartMessage extends FlowProBase{

	//private Logger logger = Logger.getLogger(NodeActiveUtil.class);
	
	public boolean execute(DBNodeMessageTrigger tr,String identifier) {
		
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		if(createFlow(tr.getFlowid(),identifier)){//创建实例
			addTriggerLog(tr,saveMap,true);//处理完成后像记录表中插入记录
			return true;
		}else{
			addTriggerLog(tr,saveMap,false);//处理完成后像记录表中插入记录	
			return false;
		}
	}
	
	/**
	 * 消息发起创建实例
	 * @param flowid
	 * @param identifier
	 * @return
	 */
	private boolean createFlow(String flowid,String identifier) {
		IWorkflowOperator operator = WorkflowFactory.getWorkflowOperator();	//流程操作对象
		WorkParaBean workParaBean = new WorkParaBean();			//操作参数对象
		workParaBean.setUserId(StaticVarExtend.System_Id);
//		workParaBean.setUserName(StaticVarExtend.System_Name);
		workParaBean.setFunname("autofirst");
		workParaBean.setFlowIdentifier(identifier);			//流程数据的数据源
	  	workParaBean.setDataIdentifier(identifier);			//业务数据的数据源
	  	workParaBean.setFlowId(flowid);
	  	IWorkResult wr = operator.create(workParaBean); 
        if (wr.getResult() == 100) {
            operator.close(wr.getWorkid(), wr.getCurTrackInfo().getId(), StaticVarExtend.System_Id);
            return true;
        }
        try{
            //避免getCurTrackInfo()为null时出现的问题
            operator.close(wr.getWorkid(), wr.getCurTrackInfo().getId(), StaticVarExtend.System_Id);
        }
        catch(Exception e){
            e.printStackTrace();
        }
        return false;
	}
}
