package com.horizon.wf.expand.msg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.horizon.wf.entity.db.DBNodeMessageTrigger;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.DateUtil;

public class FlowProBase {

	
	/**
	 * 添加消息触发日志记录
	 * @param t
	 * @param saveMap
	 * @param isActiveSuccess 
	 */
	protected void addTriggerLog(DBNodeMessageTrigger t,
			Map<String, List<Object>> saveMap, boolean isActiveSuccess) {
		t.setId(StaticFunExtend.getUnid());
		t.setTriggerTime(DateUtil.getNow());
		t.setIssuccess(isActiveSuccess?"0":"1");//true:执行成功为0
		saveMap.putAll(t.getLogSQL());
	}


	/**
	 * 删除消息数据
	 * @param t
	 * @param saveMap
	 */
	protected void deleteTrigger(DBNodeMessageTrigger t,
			Map<String, List<Object>> saveMap) {
		List<Object> conditionList = new ArrayList<Object>(1);
		conditionList.add(t.getId());
		saveMap.put("delete from " + StaticVarExtend.Table_Node_Message_Trigger + " where id = ?", conditionList);
	}
}
