package com.horizon.wf.expand.impl.common.task;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.pool.TodoManager;

/**
 * 激活节点时,发送消息
 * @author liys
 * @version 1.0
 * @since v7.2
 *
 */
public class TodoTaskForNoActiveExe {
	private Logger logger = LoggerFactory.getLogger(getClass());
	private static TodoTaskForNoActiveExe instance ;
	private TodoTaskForNoActiveExe(){}
	
	public static TodoTaskForNoActiveExe getInstance(){
		if(instance == null){
			instance = new TodoTaskForNoActiveExe();
		}
		return instance;
	}
	public boolean execute(Object bean,Map<String,String> para,String identifier) {
		if(StringUtilExtend.isNull(identifier)){
			logger.error("todo task execute error.identifier is null;");
			return false;
		}
		
		String workid = para.get("workid");
		String trackid = para.get("trackid");
		
		TodoManager.sendTodo(workid,trackid,identifier);
		
		return true;
	}
}




