package com.horizon.wf.expand.impl.common.task;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.pool.TodoManager;

/**
 * 待办定时任务,流程实例执行过程中需要发送待办，待阅等时，调用该定时任务
 * @author liangjw
 * @version 1.0
 * @since v7.2
 *
 */
public class TodoTaskExe{
	private Logger logger = LoggerFactory.getLogger(getClass());
	private static TodoTaskExe instance ;
	private TodoTaskExe(){}
	
	public static TodoTaskExe getInstance(){
		if(instance == null){
			instance = new TodoTaskExe();
		}
		return instance;
	}
	public boolean execute(Object bean,Map<String,String> para,String identifier) {
		if(StringUtilExtend.isNull(identifier)){
			logger.error("todo task execute error.identifier is null;");
			return false;
		}
		String tmpId = para.get("tmpid");
		String[] tmpIds = tmpId.split(",");
		List<String> tmpIdLst = Arrays.asList(tmpIds);
		
		TodoManager.sendTodo(tmpIdLst, identifier);
		
		return true;
	}
}




