package com.horizon.wf.expand.impl.common.task;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.global.StaticVarExtend;


/**
 * 节点自动提交定时任务，开始节点为定时发起时调用
 * 
 * @version 1.0
 * @since v7.0
 */
public class StartFlowTaskExe {
	
	private Logger logger = LoggerFactory.getLogger(StartFlowTaskExe.class);	
	private static StartFlowTaskExe instance ;
	private StartFlowTaskExe(){}
	
	public static StartFlowTaskExe getInstance(){
		if(instance == null){
			instance = new StartFlowTaskExe();
		}
		return instance;
	}
	public boolean execute(Object bean,Map<String,String> para,String identifier) {
		String flowid = para.get("flowid");
		return activeTrigger(flowid, identifier);
	}

	private boolean activeTrigger(String flowid, String identifier) {
		logger.debug("StartFlowTask start.");
		IWorkflowOperator operator = WorkflowFactory.getWorkflowOperator(); // 流程操作对象

		WorkParaBean workParaBean = new WorkParaBean(); // 操作参数对象
		workParaBean.setUserId(StaticVarExtend.System_Id);
//		workParaBean.setUserName(StaticVarExtend.System_Name);
		// workParaBean.setDeptName("系统自动执行");
		workParaBean.setFunname("autofirst");
		workParaBean.setFlowIdentifier(identifier); // 流程数据的数据源
		workParaBean.setDataIdentifier(identifier); // 业务数据的数据源
		workParaBean.setFlowId(flowid);

		IWorkResult wr = operator.create(workParaBean); 
		if (wr.getResult() == 100) {
		    operator.close(wr.getWorkid(), wr.getCurTrackInfo().getId(), StaticVarExtend.System_Id);
			logger.debug("StartFlowTask end.");
			return true;
		}
		try{
		    //避免getCurTrackInfo()为null时出现的问题
		    operator.close(wr.getWorkid(), wr.getCurTrackInfo().getId(), StaticVarExtend.System_Id);
		}
		catch(Exception e){
		    e.printStackTrace();
		}
		logger.debug(wr.getBackMsg());
		return false;
	}
}
