package com.horizon.wf.expand.impl.common.task;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.wf.action.event.ExecuteEventSubmit;
import com.horizon.wf.definition.XmlDBUtil;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;

/**
 * 节点自动提交定时任务
 * @author liys
 * @version 1.0
 * @since v7.0
 *
 */
public class NodeEventSubmitTaskExe {
//	private IDBAccess db = ResponsibleImplFactory.getDBAccess();//数据库操作类
	private Logger logger = LoggerFactory.getLogger(NodeEventSubmitTaskExe.class);	
	private static NodeEventSubmitTaskExe instance ;
	private NodeEventSubmitTaskExe(){}
	
	public static NodeEventSubmitTaskExe getInstance(){
		if(instance == null){
			instance = new NodeEventSubmitTaskExe();
		}
		return instance;
	}
	public boolean execute(Object bean,Map<String,String> para,String identifier) { 
		logger.debug("NodeEventSubmitTask start.");
		String workid = para.get("workid");
		String trackid = para.get("trackid");
		String nodeid = para.get("nodeid");
		logger.info("workid="+workid+";trackid="+trackid+";nodeid="+nodeid);
//		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		//检查实例是否实际存在
		boolean isExist = XmlDBUtil.checkInstancExist(workid, identifier);
		if(isExist){
			ExecuteEventSubmit eventSubmit = new ExecuteEventSubmit(workid, trackid, nodeid, identifier);
			eventSubmit.excuteSubmit();
			int result = eventSubmit.getWorkResult().getResult();
			
			if(StaticVarExtend.F_STATUS_Success == result){
				logger.debug("NodeEventSubmitTask execute success.");
				ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
				ti.remove(bean);
			}
		}
		else{
			ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
			ti.remove(bean);
		}
		logger.debug("NodeEventSubmitTask end.");
//		return db.executeMultiUpdate(saveMap, identifier);
		return true;
	}	
}
