package com.horizon.wf.expand.impl.common.task;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.cache.api.HTenantCacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.wf.action.robot.ExcuteAutoSubmit;
import com.horizon.wf.definition.XmlDBUtil;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.AccessUtil;
/**
 * 节点自动提交定时任务
 * @author liys
 * @version 1.0
 * @since v7.0
 *
 */
public class NodeAutoSubmitTaskExe {
	private Logger logger = LoggerFactory.getLogger(NodeAutoSubmitTaskExe.class);	
	private static NodeAutoSubmitTaskExe instance ;
	private NodeAutoSubmitTaskExe(){}
	
	public static NodeAutoSubmitTaskExe getInstance(){
		if(instance == null){
			instance = new NodeAutoSubmitTaskExe();
		}
		return instance;
	}
	public boolean execute(Object bean,Map<String,String> para,String identifier) { 
		logger.debug("NodeAutoSubmitTask start.");

		String workid = para.get("workid");
		String trackid = para.get("trackid");
		String nodeid = para.get("nodeid");
		String tenantid = para.get("tenantid");
		logger.info("workid="+workid+";trackid="+trackid+";nodeid="+nodeid);
		ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
		ti.remove(bean);
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		
		//检查实例是否实际存在
		boolean isExist = XmlDBUtil.checkInstancExist(workid, identifier);
		if(isExist){
			if(isLock(workid,tenantid,0)){
				HTenantCacheClient.put(tenantid,"Work","isLock:"+workid,"1",200l);
				ExcuteAutoSubmit autoSubmit = new ExcuteAutoSubmit();
				int result = autoSubmit.excuteSubmit(workid, trackid, nodeid, identifier);
				HTenantCacheClient.remove(tenantid,"Work","isLock:"+workid);
				if(StaticVarExtend.F_STATUS_Success == result){
					logger.debug("NodeAutoSubmitTask execute success.");
					//成功后更新
					updateTaskList(workid, trackid, nodeid, saveMap);
				}
			}
		}
		else{
			logger.debug("NodeAutoSubmitTask instance is not existed.");
			//删除数据
			deleteTaskList(workid,saveMap);
		}
		logger.debug("NodeAutoSubmitTask end.");
		return  AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier);
	}
		
	/**
	 * 根据条件查找自动提交节点
	 * @param workid
	 * @param trackid
	 * @param nodeid
	 * @return
	 */
	private void updateTaskList(String workid, String trackid, String nodeid, Map<String, List<Object>> saveMap){
		String sql = "update "+StaticVarExtend.Table_Robot_Task +" set status=? where status=? and workid=? and trackid=? and nodeid=?";
		List<Object> conditionList = new ArrayList<Object>();
		conditionList.add("1");
		conditionList.add("0");
		conditionList.add(workid);
		conditionList.add(trackid);
		conditionList.add(nodeid);
		saveMap.put(sql, conditionList);
	}
	
	private void deleteTaskList(String workid,Map<String, List<Object>> saveMap){
		String sql = "delete from  "+StaticVarExtend.Table_Robot_Task +" where workid=?";
		List<Object> conditionList = new ArrayList<Object>();
		conditionList.add(workid);
		saveMap.put(sql, conditionList);
	}

	/**
	 *判断当前work是否有同步执行的多分支
	 * @return
	 */
	private boolean isLock(String workId,String tenantId,int index){
		try {
			index++;
			if(HTenantCacheClient.keyExists(tenantId,"Work","isLock:"+workId)){
				Thread.sleep(1000);
				if(index<=10) {
					isLock(workId, tenantId, index);
				}
			}else{
				return true;
			}
		}catch (Exception e){
			return false;
		}
		return true;
	}
}
