package com.horizon.wf.expand.impl.common.task;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.horizon.utils.StringUtil;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.core.rule.IBaseRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.horizon.wf.action.common.ActionCommon;
import com.horizon.wf.action.event.ExecuteEventSubmit;
import com.horizon.wf.definition.XmlDBUtil;
import com.horizon.wf.entity.db.DBNodeTaskTrigger;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.global.CollectionUtil;
import com.horizon.wf.global.StaticFunExtend;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.global.StringUtilExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.pool.XMLTodoPub;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.DateUtil;

/**
 * 节点激活方式定时任务
 * @author liys
 * @version 1.0
 * @since v7.0
 *
 */
public class NodeActivationTaskExe {
	private Logger logger = LoggerFactory.getLogger(NodeActivationTaskExe.class);
	private static NodeActivationTaskExe instance ;
	private NodeActivationTaskExe(){}
	
	public static NodeActivationTaskExe getInstance(){
		if(instance == null){
			instance = new NodeActivationTaskExe();
		}
		return instance;
	}
	public boolean execute(Object bean,Map<String,String> para,String identifier) {
		logger.debug("execute NodeActivationTask start.");
		
		if(StringUtilExtend.isNull(identifier)){
			identifier = StaticVarExtend.DefaultIdentifier;
		}
		String workid = para.get("workid");
		String trackid = para.get("trackid");
		String nodeid = para.get("nodeid");
		logger.info("workid="+workid+";trackid="+trackid+";nodeid="+nodeid);
		
		
		boolean isExist = XmlDBUtil.checkInstancExist(workid, identifier);
		if(!isExist){
			ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
			ti.remove(bean);
			deleteAllTrigger(workid,identifier);//处理完成后像记录表中插入记录	
			return true;
		}
		
		String sql = "select * from " + StaticVarExtend.Table_Node_Task_Trigger + " where workid=? and trackid=? and nodeid=? and status=?";
		List<String> conditionList = new ArrayList<String>();
		//conditionList.add(StaticVarExtend.Activation_Type_Node);//节点激活
		conditionList.add(workid);//workid
		conditionList.add(trackid);//trackid
		conditionList.add(nodeid);//nodeid
		conditionList.add("1");//可执行
		List<DBNodeTaskTrigger> triggers =  AccessUtil.getInstance()
				.getMultiObject(sql, conditionList, DBNodeTaskTrigger.class, identifier);
		if(CollectionUtil.isListNotEmpty(triggers)){
			for(int i=0,n= triggers.size();i<n;i++){
				DBNodeTaskTrigger t = triggers.get(i);
				ITaskInterface ti = PluginsUtil.getSingleInstance().getTaskInterface();
				Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
				boolean exeResult = false;
				int execnum = t.getExecnum();
				int modeNum = Integer.parseInt(para.get("modeNum"));
				if(modeNum>0 && modeNum <= execnum){
					logger.info("execution times more than the node set.");
					
					ti.remove(bean);
					if(!saveMap.isEmpty()){
						 AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier);
					}
					return true;
				}
				if(StaticVarExtend.Activation_Type_Node.equals(t.getTriggerType())){
					logger.debug("node activation");
					//1:定时任务
					if(activeTrigger(t,identifier)){//激活节点
						
//						Map<String,String> logPara = new HashMap<String,String>();
//						logPara.put("workid", t.getWorkid());
//						logPara.put("trackid",  t.getTrackid());
//						logPara.put("identifier", identifier);
//						logPara.put("actionname","定时激活" );
//						logPara.put("actionUserid", StaticVarExtend.System_Id);
//						logPara.put("actionUsername", StaticVarExtend.System_Name);
//						logPara.put("comments", "无");
						
//						DBLog trackLog = StaticFunExtend.getActionCommon().makeDbLogForSys(logPara);
//						trackLog.getSQL(saveMap);	
						
						exeResult = true;
					}
					

				}else if(StaticVarExtend.Signal_Event_Type_Node.equals(t.getTriggerType())){
					logger.debug("event submit.");
					String tInterface=t.getInterfaceClass();
					if(StringUtil.hasValue(tInterface)){
						IBaseRule tService=InterfaceFactory.getNewInterface(t.getInterfaceClass());
						tService.setParameter("workId",workid);
						tService.setParameter("trackId",trackid);
						tService.setParameter("nodeId",nodeid);
						tService.setParameter("identifier",identifier);
						tService.setParameter("tenantCode",para.get("tenantid"));
						if(tService.executeRule()){
							ExecuteEventSubmit eventSubmit = new ExecuteEventSubmit(workid, trackid, nodeid, identifier);
							eventSubmit.excuteSubmit();
							int result = eventSubmit.getWorkResult().getResult();
							if(StaticVarExtend.F_STATUS_Success == result){
								exeResult = true;
							}
						}else{
							exeResult = false;
						}
					}else{
						ExecuteEventSubmit eventSubmit = new ExecuteEventSubmit(workid, trackid, nodeid, identifier);
						eventSubmit.excuteSubmit();
						int result = eventSubmit.getWorkResult().getResult();
						if(StaticVarExtend.F_STATUS_Success == result){
							exeResult = true;
						}
					}

				}
				if(exeResult){
					//执行完成后从队列中删除该任务
					ti.remove(bean);
					deleteTrigger(t,saveMap);//处理完成后像记录表中插入记录					
				}else{
					updateTrigger(t, saveMap);//更新执行次数
				}
//				XMLTodoPub.updateTempTodoActive(t.getWorkid(), t.getTrackid(), saveMap);
				addTriggerLog(t,saveMap);
				if(!saveMap.isEmpty()){
					if( AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier)){
						XMLTodoPub.startThreadForNoActiveMsg(t.getWorkid(), t.getTrackid(), identifier);
					}
				}
			}
		}
		logger.debug("execute NodeActiveUtil end.");
		return true;
	}
	
	/**
	 * 激活不活动的节点
	 * @param tb
	 * @return
	 */
	private boolean activeTrigger(DBNodeTaskTrigger t,String identifier) {
		try{
			String ic = t.getInterfaceClass();
			return ActionCommon.getInstance().activeTrigger(t.getWorkid(), t.getTrackid(),"Timing", ic, identifier);					
		}catch(Exception e){
			e.printStackTrace();
			return false;
		}
	}
	
	/**
	 * 更新执行次数
	 * @param t
	 * @param identifier
	 */
	private void updateTrigger(DBNodeTaskTrigger t, Map<String, List<Object>> saveMap){
		saveMap.put("update " + StaticVarExtend.Table_Node_Task_Trigger +" set execnum=execnum+1 where id='"+t.getId()+"'",null);
	}
	/**
	 * 删除记录
	 * @param t
	 * @param saveMap
	 */
	private void deleteTrigger(DBNodeTaskTrigger t, Map<String, List<Object>> saveMap){
		saveMap.put("delete from " + StaticVarExtend.Table_Node_Task_Trigger +" where id='"+t.getId()+"'", null);
	}
	
	private boolean deleteAllTrigger(String workid,String identifier){
		Map<String, List<Object>> saveMap = new LinkedHashMap<String, List<Object>>();
		List<Object> conditionList = new ArrayList<Object>();
		conditionList.add(workid);
		saveMap.put("delete from " + StaticVarExtend.Table_Node_Task_Trigger +" where workid=?", conditionList);
		saveMap.put("delete from " + StaticVarExtend.Table_Node_Task_Trigger_log +" where workid=?", conditionList);
		if( AccessUtil.getInstance().executeMultiUpdate(saveMap, identifier)){
			return true;
		}
		return false;
	}

	/**
	 * 执行成功后将记录存入succes表,并且删除原有记录
	 * @param tb
	 */
	private void addTriggerLog(DBNodeTaskTrigger d, Map<String, List<Object>> saveMap) {
		d.setExecnum(d.getExecnum()+1);
		d.setId(StaticFunExtend.getUnid());
		d.setStatus("2");
		d.setTriggerTime(DateUtil.getNow());
		saveMap.putAll(d.getDelSQL());
	}

}




