package com.horizon.wf.expand.impl.common;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

import com.horizon.wf.config.HZResourceBundle;
import com.horizon.wf.core.factory.InterfaceFactory;
import com.horizon.wf.expand.impl.IAppInterface;
import com.horizon.wf.expand.impl.IAuthority;
import com.horizon.wf.expand.impl.IHZCalendar;
import com.horizon.wf.expand.impl.IHZTransaction;
import com.horizon.wf.expand.impl.IMessageMould;
import com.horizon.wf.expand.impl.IOrganizationInterface;
import com.horizon.wf.expand.impl.ITaskInterface;
import com.horizon.wf.expand.impl.ITodoInterface;
import com.horizon.wf.rule.jsr94.IRuleEngine;
import com.horizon.wf.tools.StringUtil;


/**
 * 
 * 适配器的构造工厂
 */
public class AdapterFactory {
	private static ITodoInterface xmlTodo;
	private static ITaskInterface task;//定时任务接口
	private static IMessageMould messageMould;
	private static IAppInterface[] appInterface;//应用接口
	private static IHZTransaction transaction;
	private static IRuleEngine ruleEngine;
	
	private static ConcurrentMap<String,IOrganizationInterface> iOrganizationInterfaceMap	= new ConcurrentHashMap<String,IOrganizationInterface>();
	private static ConcurrentMap<String,IAuthority> iAuthorityMap = new ConcurrentHashMap<String,IAuthority>();
	private static ConcurrentMap<String,IHZCalendar> iHZCalendarMap	= new ConcurrentHashMap<String,IHZCalendar>();
	
	private AdapterFactory(){}
	
//	3.多租户时,肯定会有不同实现的部分#
	public static IOrganizationInterface getOrganization(String tenantid) {
		IOrganizationInterface org = iOrganizationInterfaceMap.get(tenantid);
		if(null == org) {
			org = InterfaceFactory.getNewInterface(HZResourceBundle.getInstance().getOrganizationClassName());
			org.setTenantid(tenantid);
			iOrganizationInterfaceMap.put(tenantid,org);
		}
		return org;
	}
	public static IAuthority getAuthority(String tenantid) {
		IAuthority org = iAuthorityMap.get(tenantid);
		if(null == org) {
			org = InterfaceFactory.getNewInterface(HZResourceBundle.getInstance().getAuthorityClassName());
			org.setTenantid(tenantid);
			iAuthorityMap.put(tenantid,org);
		}
		return org;
	}
	public static IHZCalendar getCalendar(String tenantid) {
		IHZCalendar org = iHZCalendarMap.get(tenantid);
		if(null == org) {
			org = InterfaceFactory.getNewInterface(HZResourceBundle.getInstance().getCalendarClassName());
			org.setTenantid(tenantid);
			iHZCalendarMap.put(tenantid,org);
		}
		return org;
	}
	
	public static IMessageMould getMessageMould(){
		if(null == messageMould){
			messageMould = InterfaceFactory.getNewInterface(HZResourceBundle.getInstance().getMessageMoudleClassName());
		}
		return messageMould;
	}
	
	public static IAppInterface[] getAppInterface(){
		if(null == appInterface){
			String appClass=HZResourceBundle.getInstance().getAppClassName();
			if(StringUtil.hasValue(appClass)){
				String[] appArr=appClass.split(";");
				appInterface= new IAppInterface[appArr.length];
				for(int i=0;i<appArr.length;i++){
					appInterface[i]= InterfaceFactory.getNewInterfaceIgnoreExp(appArr[i]);
				}
			}
		}
		return appInterface;
	}
	
	public static ITodoInterface getXMLTodo() {
		if(xmlTodo == null) {
			xmlTodo =  InterfaceFactory.getNewInterface(HZResourceBundle.getInstance().getTodoClassName());
		}
		return xmlTodo;
	}
	
			
	public static ITaskInterface getTaskInterface(){
		if(null == task){
			task = InterfaceFactory.getNewInterface(HZResourceBundle.getInstance().getTaskClassName());
		}
		return task;
	}
	public static IHZTransaction getHZTransaction(){
		if(null == transaction){
			transaction = InterfaceFactory.getNewInterface(HZResourceBundle.getInstance().getTransactionClassName());
		}
		return transaction;
	}
	
	public static IRuleEngine getRuleEngine(){
		if(null == ruleEngine){
			ruleEngine = InterfaceFactory.getNewInterface(HZResourceBundle.getInstance().getRuleEngineClassName());
		}
		return ruleEngine;
	}
	
}
