package com.horizon.wf.expand.impl;

import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;

import java.util.List;
import java.util.Map;

/**
 * 添加定时任务的接口
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public interface ITaskInterface {
	/**
	 * 根据任务列表,把任务添加到执行队列中
	 * @param taskList
	 */
	public void addTask(List<Object> taskList) ;
	/**
	 * 生成一条立即执行发送待办信息的任务对象并添加到执行队列中
	 * @param workid
	 * @param tmpIdList
	 * @param identifier
	 * @return
	 */
	public void addTaskForTodo(String workid,List<String> tmpIdList,String identifier);
	public void addTaskForTodoNoActiveMsg(String workid,String trackid,String identifier);
	/**
	 * 生成一条定时任务所需要的对象
	 * @param rd 实例运行期数据
	 * @param node 要添加定时任务的节点
	 * @param saveMap 保存sql的map
	 * @param track 路径对象
	 * @return 添加好的定时任务对象
	 */
	public Object makeTaskBean(RunningData rd , IFlowNode node, Map<String, List<Object>> saveMap, DBTrack track);
	/**
	 * 只对自动节点和立即执行的任务
	 * NodeTypeEnum.Node_Event_Intermediate 中间事件
	 * NodeTypeEnum.Node_Event_Signal_Throw  信号抛出
	 * NodeTypeEnum.Node_Auto系列
	 * @param saveMap 需要保存的sql和对应的参数
	 * @param para:传入的参数
	 * String flowname = para.get("flowname");
	 * String nodename = para.get("nodename");
	 * String nodeid	= para.get("nodeid");
	 * String workid	= para.get("workid");
	 * int version		= Integer.parseInt(para.get("version"));
	 * String trackid 	= para.get("trackid");
	 * String tenantid = para.get("tenantid");
	 * String identifier=para.get("identifier");
	 * String jbClassName= para.get("jbClassName");
	 */
	public Object makeTaskBeanForAutoSubmit(Map<String, List<Object>> saveMap,Map<String,String> para);
	/**
	 * 引擎交互节点接收数据后,自动提交失败时,添加一条定时任务
	 * @param work
	 * @param track
	 * @param tenantid
	 * @param identifier
	 * @return
	 */
	public boolean addTaskForMutualReceive(DBWork work,DBTrack track,String tenantid,String identifier);
	/**
	 * 暂停定时任务状态.
	 * @param workids 实例id
	 * @param saveMap 存放sql语句的map
	 * @param identifier 数据库标识符
	 */
	public void pause(String[] workids, Map<String, List<Object>> saveMap, String identifier);

	/**
	 * 暂停定时任务状态
	 * @param taskId 任务id
	 * @param saveMap 存放sql语句的map
	 */
//	public void pause(TaskParaBean bean, LinkedHashMap<String, List<Object>> saveMap) ;

	/**
	 * 暂停定时任务状态
	 * @param saveMap 存放sql语句的map
	 */
	public void pause(String workid, String nodeid, Map<String, List<Object>> saveMap, String identifier) ;	
	
	/**
	 * 恢复暂停的定时任务
	 * @param workids 实例id
	 * @param saveMap 存放sql语句的map
	 * @param identifier 数据库标识符
	 */
	public void restore(String[] workids, Map<String, List<Object>> saveMap, String identifier);

	/**
	 * 恢复暂停的定时任务
	 * @param workid 实例id
	 * @param nodeid 节点id
	 * @param saveMap 存放sql语句的map
	 * @param identifier 数据库标识符
	 */
	public void restore(String workid,String nodeid, Map<String, List<Object>> saveMap, String identifier);
	/**
	 * 恢复指定实例版本的定时任务
	 * @param workid 实例id
	 * @param version 实例版本
	 * @param saveMap 存放sql语句的map
	 * @param identifier 数据库标识符
	 */
	public void restore(String workid, int version, Map<String, List<Object>> saveMap, String identifier);
	/**
	 * 从队列中移除定时任务
	 */
	public void remove(Object bean);
	//======================以下定制工具使用==========================================
	/**
	 * 删除流程启动任务
	 * @param flowid 流程Id
	 * @return 成功或者失败
	 */
	public boolean deleteFlowStartTask(String flowid) ;
	/**
	 * 增加流程启动任务
	 * @param map key: flowid 流程Id,startTime 开始时间, repeatInterval 执行周期，默认毫秒  ,startflowclass:流程启动的类
	 * @return 成功或者失败
	 */
	public boolean addFlowStartTask(Map<String,Object> map) ;
}