package com.horizon.wf.expand.impl;

import java.util.List;
import java.util.Map;

/**
 * 流程组织机构接口
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public interface IOrganizationInterface {
	/**
	 * 设置租户id
	 * @param tenantid
	 */
	public void setTenantid(String tenantid);
	/**
	 * 去掉orgs中不存在的组织机构id
	 * com.horizon.wf.rule.defa.core.EntryRuleDefault 使用
	 * @param orgs 组织机构id字符串
	 * @return
	 */
	public String removeNotExitsOrg(String orgs,String identifier);

	/**
	 * 根据给定的部门id获取部门下的用户
	 * com.horizon.wf.third.hz.rule.drools.RuleFun 	使用
	 * @param deptid ：多个部门id以";"隔开
	 * @param identifier 数据库标识
	 * @param isHaveSubDept 是否含有子部门
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromDept(String deptid,boolean isHaveSubDept,String identifier);
	
	/**
	 * 根据给定的群组id获取群组下的用户
	 * com.horizon.wf.third.hz.rule.drools.RuleFun 	使用
	 * @param groupid 多个群组id以";"隔开
	 * @param identifier 数据库标识
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromGroup(String groupid,String identifier);
	
	/**
	 * 根据给定的岗位id获取岗位下的用户
	 * com.horizon.wf.third.hz.rule.drools.RuleFun 	使用
	 * @param postionid 多个岗位id以";"隔开
	 * @param identifier 数据库标识
	 * @return 用户id组成的字符串，多个以";"隔开
	 */
	public String getAllUserFromPosition(String postionid,String identifier);
	
	/**
	 * 根据组织机构中的人员之间的关系获取人员(比如根据userid来获取直接领导,下属)
    * @param para map中的key和value说明如下
    * key = userID 	value = String 流程当前办理用户id
    * key = creator value = String 流程创建用户id
    * key = done 	value = String[] 目标节点历史办理人id
    * key = base 	value = int[] 1当前办理人员，2流程创建者 （当关系基准人为“无”时，此参数可以忽略）
    * key = tarRange 	value = String[] 相对岗位
    * key = gathertype  value = int[]  交集并集默认2并集
    * key = relation	value = String[] 人员关系定义
    * @return 返回用户id，当有多个用户id时，';'隔开
	 */
	public String getRelationUser(Map<String,Object> para,String identifier);
	/**
	 * 获取人员的所属ID，包含部门所有上级部门id，群组id角色id
	 * com.horizon.wf.api.WorkflowOperator 使用
	 * @param userid
	 * @return
	 */
	public String getAllUserids(String userid,String identifier);
	
	/**
	 * 获取给定部门deptid的下级子部门id
	 * com.horizon.wf.rule.defa.CheckRoleForOpenInstanceDefault 使用
	 * @param deptid
	 * @param identifier
	 * @return
	 */
	public String getSubDeptIdById(String deptid,String identifier);
	/**
	 * 获取指定userid所在的直属部门id
	 * com.horizon.wf.api.WorkflowManager使用
	 * @param userid
	 * @param identifier
	 * @return
	 */
	public String getDeptIdByUserid(String userid,String identifier);

	/**
	 * 根据部门id和类型，获取对应的人
	 * @param deptid
	 * @param type
	 * @param identifier
	 * @return
	 */
	public String getDeptSpecialUser(String deptid,String type,String identifier);
	
	/**
	 * 获取指定id的中文名称,id可能是任何组织类型
	 * com.horizon.wf.autotest.AutoTestMain使用
	 * @param orgids
	 * @param identifier
	 * @return
	 */
	public String getNameByIds(String orgids, String identifier);
	/**
	 * 根据userid获取用户相关信息
	 * com.horizon.wf.autotest.AutoTestMain 使用
	 * @param userid
	 * @param identifier
	 * @return
	 */
	public Map<String,String> getUserById(String userid ,String identifier);
	/**
	 * 根据userids获取多个用户的相关信息
	 * com.horizon.workflow.designer.wf.XMLFlowUtil.getCNNameByID
	 * @param userids
	 * @param identifier
	 * @return
	 */
	public List<Map<String,String>> getUserByIDs(String[] userids,String identifier);
	/**
	 * 根据deptids获取多个部门的相关信息
	 * com.horizon.workflow.designer.wf.XMLFlowUtil.getCNNameByID
	 * @param deptids
	 * @param identifier
	 * @return
	 */
	public List<Map<String,String>> getDeptsByIDs(String[] deptids,String identifier);
	/**
	 * 根据groupids获取多个群组的相关信息
	 * com.horizon.workflow.designer.wf.XMLFlowUtil.getCNNameByID
	 * @param groupids
	 * @param identifier
	 * @return
	 */
	public List<Map<String,String>> getGroupByIDs(String[] groupids,String identifier);
	/**
	 * 根据positionids获取多个岗位的相关信息
	 * com.horizon.workflow.designer.wf.XMLFlowUtil.getCNNameByID
	 * @param positionids
	 * @param identifier
	 * @return
	 */
	public List<Map<String,String>> getPositionByIDs(String[] positionids,String identifier);
}
