package com.horizon.wf.expand.impl;

import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.definition.pub.IFlowNode;
/**
 * 获取默认的待办发送标题
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public interface IMessageMould {
	/**
	 * 获取发送消息的的标题
	 * @param trackid 发送消息的trackid
	 * @param node 发送到哪个节点
	 * @param rd 运行期对象
	 * @param msgType 消息类型
	 * @param authType 权限名称
	 * @return 处理好后的标题
	 */
	public String getTodoTitle(String trackid, IFlowNode node, RunningData rd, String msgType, String authType);

	/**
	 * 根据msgType获取消息格式,并把title按照格式进行格式化返回
	 * @param title
	 * @param rd
	 * @param msgType
	 * @return
	 */
	public String getTodoTitle(String title,RunningData rd,String msgType);
}
