package com.horizon.wf.expand.impl;

import java.util.Date;

public interface IHZCalendar {
	/**
	 * 设置租户id
	 * @param tenantid
	 */
	public void setTenantid(String tenantid);
	
	/**
	 * 获取给定两个日期之间的工作日
	 * @param date1(2015-03-23)
	 * @param date2(2015-03-21)
	 * date1 > date2 返回2
	 * datatype=0工作日1自然日
	 * @return date1>date2 返回正数,date1<date2 返回负数
	 */
	public int getWorkdaysFromTwoDate(Date date1,Date date2,int datetype);
	/**
	 * 获取给定两个日期之间的工作日
	 * @param date1
	 * @param date2
	 * @param datetype=0工作日1自然日
	 * @return
	 */
	public int getWorkdaysFromTwoDate(String date1,String date2,int datetype);
	/**
	 * 根据日期date获取days后的日期(按照datetype指定方式)
	 * @param date			(2015-03-20)
	 * @param datetype		=0工作日		1自然日
	 * @param days			2			
	 * @return				2015-03-24 	2015-03-22
	 */
	public Date getDateAfter(Date date,int datetype,int days);
	
	
}
