package com.horizon.wf.expand.impl;

import java.util.List;
import java.util.Map;

/**
 * 业务数据删除接口
 * @author liangjw
 * @version 1.0
 * @since hzwf v7.0
 *
 */
public interface IAppInterface {
	/**
	 * 设置租户id
	 * @param tenantid
	 */
	public void setTenantid(String tenantid);
	/**
	 * 实例删除时，业务数据的删除
	 * @param workids 实例id
	 * @param identifier 数据库标识
	 * @return
	 */
	public Map<String,Map<String, List<Object>>> deleteAppData(String[] workids,String identifier);
	/**
	 * 实例恢复时，业务数据的恢复
	 * @param workid 实例id
	 * @param version 实例版本
	 * @param saveMap 存放sql语句的map
	 */
	public void replaceAppData(String workid,int version,Map<String, List<Object>> saveMap);
}
