package com.horizon.wf.example;

import java.util.ArrayList;
import java.util.List;

import com.horizon.wf.IWorkResult;
import com.horizon.wf.IWorkflowOperator;
import com.horizon.wf.WorkflowFactory;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.factory.ResponsibleImplFactory;
import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.core.work.IExtendAction;
import com.horizon.wf.entity.db.DBTodo;
import com.horizon.wf.global.StaticVarExtend;
/**
 * 自定义操作执行范例
 * @author liys
 *
 */
public class ReduceTrack implements IExtendAction{
	WorkParaBean workParaBean;
	IWorkResult resultBean ;
	int result;
	String backMsg;
	RunningData runningdata;
	public void setWorkParaBean(Object paraBean) {
		this.workParaBean = (WorkParaBean)paraBean;
	}
	
	public void doAction(){
		IWorkflowOperator operator = WorkflowFactory.getWorkflowOperator();
		String workid = workParaBean.getWorkId();
		String userid = workParaBean.getUserId();
		String identifier = workParaBean.getFlowIdentifier();
		
//		根据虚拟人id获取对应的待办信息以便获取到trackid信息
		String vUserid = "HZ28821856ef63420156ef6342a20003";	//虚拟人的id,应该是个固定值
		String sql = "SELECT TRACKID FROM TW_HZ_WORKLIST WHERE AUTH_ID=? AND WORKID=? AND STATUS=?";
		List<Object> para = new ArrayList<Object>(3);
		para.add(vUserid);
		para.add(workid);
		para.add("Author");
		List<DBTodo> todoLst = ResponsibleImplFactory.getDBAccess().getMultiObject(sql, para,DBTodo.class, identifier);
		if(todoLst == null || todoLst.isEmpty()){
			result = StaticVarExtend.F_STATUS_OtherError;
			backMsg = "获取虚拟人的待办失败";
			return ;
		}
		String trackid = todoLst.get(0).getTrackid();
		
//		创建加签操作需要的参数对象
		WorkParaBean paraBean = new WorkParaBean();
		//固定虚拟人id
		paraBean.setUserId("U_HZ28821856ef63420156ef6342a20003/D_HZ28821856ef63420156ef6342a20001");
		
		paraBean.setTenantCode(workParaBean.getTenantCode());
		paraBean.setFlowIdentifier(identifier);
		paraBean.setWorkId(workid);
		paraBean.setActionClass("com.horizon.wf.action.ActionJiaQian");
		paraBean.setTrackId(trackid);
		//用于记录在流程跟踪记录中的信息
		paraBean.setActionname("补发分支");
		paraBean.setUserName(workParaBean.getUserName());
		//加签的人(当前人)
		paraBean.putSelectAuthor("Node2-Author",userid);
		
		resultBean  = operator.operator(paraBean);
		result = resultBean.getResult();
		backMsg = resultBean.getBackMsg();
		runningdata =  resultBean.getRunningdata();
//		if(resultBean.getResult() == StaticVarExtend.F_STATUS_Success){
//			//切换到当前人
//			paraBean.setUserId(user.getFullName());
//			paraBean.setActionClass("com.horizon.wf.action.ActionSubmit");
//			paraBean.setTrackId(resultBean.getCurTrackInfo().getId());
//			
//			resultBean = operator.operator(paraBean);
//		}
		
	}

	public int getResultCode() {
		return result;
	}
	
	public String getBackMsg(){
		return backMsg;
	}
	
	public RunningData getRunningdata(){
		return runningdata;
	}
}
