package com.horizon.wf.example;

import com.horizon.common.collect.Lists;
import com.horizon.db.Access;
import com.horizon.wf.bean.WorkParaBean;
import com.horizon.wf.core.rule.BaseRuleImpl;
import com.horizon.wf.core.rule.IBaseRule;
import com.horizon.wf.definition.xml.IXmlNode;
import com.horizon.wf.entity.db.DBTrack;
import com.horizon.wf.entity.db.DBWork;
import com.horizon.wf.entity.run.RunUser;
import com.horizon.wf.global.StaticVarExtend;

import java.util.LinkedHashMap;
import java.util.List;

/**
 * 节点进入/离开事件范例
 *com.horizon.example.NodeEvent
 */
public class NodeEvent extends BaseRuleImpl implements IBaseRule {

	public boolean executeRule() {
		//流程相关信息
		WorkParaBean workParaBean = (WorkParaBean) getParameter(StaticVarExtend.Parameter_WorkParaBean);//前后台交互参数
		DBWork work = (DBWork) getParameter(StaticVarExtend.Parameter_DBWork);//实例对象
		RunUser curUser = (RunUser) getParameter(StaticVarExtend.Parameter_RunUser);//当前用户对象
		DBTrack curTrack = (DBTrack) getParameter(StaticVarExtend.Parameter_DBTrack);//当前路径
		IXmlNode curNode = (IXmlNode) getParameter(StaticVarExtend.Parameter_Current_IFlowNode);//当前节点

		LinkedHashMap<String, List<Object>> saveMap = (LinkedHashMap<String, List<Object>>) getParameter(StaticVarExtend.Parameter_SaveMap);//存放sql语句参数
		//获取流程审批页内的信息，页面内所哦呦input的值都在OtherPara中
		LinkedHashMap otherMap = (LinkedHashMap) workParaBean.getOtherPara();
		String pageID = otherMap.get("FORMID") == null ? "" : otherMap.get("FORMID").toString();
		String formID = otherMap.get(pageID + "_FORMID") != null ? otherMap.get(pageID + "_FORMID").toString() : "";
		//获取业务数据id
		String dataId = otherMap.get(formID + "_ID") != null ? otherMap.get(formID + "_ID").toString() : "";
		//执行sql
		String updateSql = "update T_ZHUBIAO set a6=123,a5=222 where id  = ?";
		List para = Lists.newArrayList();
		para.add(dataId);
		//直接数据库执行↓
		//Access.executeUpdate(updateSql,para);
		//放到map中同流程一起执行↓ 二选一
		saveMap.put(updateSql,para);
		System.out.println("nextnodeid : "+workParaBean.getNextNodeId());
		System.out.println("dataId : "+dataId);
		//返回结果决定事件是否执行成功
		return true;
	}
}
