package com.horizon.wf.entity.run;

import com.horizon.wf.core.runtime.RunningData;
import com.horizon.wf.entity.user.IRunUser;
import com.horizon.wf.global.StaticVar;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.plugins.PluginsUtil;
import com.horizon.wf.tools.CStrUtil;

/**
 * 当前操作者信息对象
 * @author liyong
 * 2012-11-30
 *
 */
public class RunUser implements IRunUser{
	private String subjectionid=StaticVarExtend.NullStr;	//归属id
	private String subjectiontype="";	//归属类型
	
	private String userid; // 当前执行人UNID
	private String username; // 当前人中文名
	private String userdeptname;
	private String alluserid;	//人员所有id,包含部门所有上级部门id，群组id角色id,逗号分隔
	private String agentUser ;	//被代理的人(agentUser~userid)
	
	private String controlNodeName; //控制信息节点名称
	private String authName;	//当前使用权限名称
	
	private String curAuths; 
	private String preNodeidOnCurTrack="";//当前路径下的上一节点id
	private String preAuthsOnCurTrack; 
	private String lastAuthsOnPreTrack;
	private String lastNodeidOnPreTrack="";//上一路径的最后一个节点id
	private String otherAuths; 
	private String authObjId; //记录对应auth对象的数据id
	private String isClaim = "0";	//标记是否为认领的任务处理
	private boolean rdyClaim = false;	//是否需要认领处理,
	private int curAuthorNum = 0;//用于判断是否能执行抢单操作
	private RunningData runningdata;
	public String forServiceString(){ 
		StringBuilder sb = new StringBuilder(2000);
		sb.append("<IRunUser>");
		CStrUtil.appendTo(sb, "userid", userid);
		CStrUtil.appendTo(sb, "subjectionid", subjectionid);
		CStrUtil.appendTo(sb, "subjectiontype", subjectiontype);
		CStrUtil.appendTo(sb, "subjectionidWithMark", getSubjectionidWithMark());
		CStrUtil.appendTo(sb, "useridWithMark", getUseridWithMark());
		CStrUtil.appendTo(sb, "userWithAgent", getUserWithAgent());
		CStrUtil.appendTo(sb, "fullName", getFullName());
		
		CStrUtil.appendTo(sb, "username", username);
		CStrUtil.appendTo(sb, "userdeptname", userdeptname);
		CStrUtil.appendTo(sb, "alluserid", alluserid);
		CStrUtil.appendTo(sb, "agentUser", agentUser);
		CStrUtil.appendTo(sb, "controlNodeName", controlNodeName);
		CStrUtil.appendTo(sb, "authName", authName);
		CStrUtil.appendTo(sb, "curNodeAuths", curAuths);
		
		CStrUtil.appendTo(sb, "preAuthsOnCurTrack", preAuthsOnCurTrack);
		CStrUtil.appendTo(sb, "lastAuthsOnPreTrack", lastAuthsOnPreTrack);
		CStrUtil.appendTo(sb, "otherAuths", otherAuths);
		CStrUtil.appendTo(sb, "isClaim", isClaim);
		
		CStrUtil.appendTo(sb, "isManager", isManager());
		sb.append("</IRunUser>");
		return sb.toString();
	}
	public String getSubjectionid() {
		return subjectionid;
	}
	public void setSubjectionid(String subjectionid) {
		this.subjectionid = subjectionid;
	}
	public String getSubjectiontype() {
		return subjectiontype;
	}
	public void setSubjectiontype(String subjectiontype) {
		this.subjectiontype = subjectiontype;
	}
	public String getSubjectionidWithMark(){
		if(subjectionid.equals(StaticVarExtend.NullStr)){
			return "";
		}
		else{
			if(null == subjectiontype || "".equals(subjectiontype)){
				return StaticVar.SubjectionFix +subjectionid;
			}
			else{
				return StaticVar.SubjectionFix +subjectiontype+StaticVar.Mark_Fix+subjectionid;
			}
		}
		
	}
	
	public String getUserid() {
		return userid;
	}
	public void setUserid(String userid) {
		this.userid = userid;
	}
	public String getUsername() {
		return username;
	}
	public void setUsername(String username) {
		this.username = username;
	}
	public String getUserdeptname() {
		return userdeptname;
	}
	public void setUserdeptname(String userdeptname) {
		this.userdeptname = userdeptname;
	}
	public String getAlluserid() {
		return (alluserid == null || alluserid.length()==0)?userid:alluserid;
	}
	public void setAlluserid(String alluserid) {
		this.alluserid = alluserid;
	}
	public String getAgentUser() {
		return agentUser;
	}
	public void setAgentUser(String agentUser) {
		this.agentUser = agentUser;
	}
	/**
	 * 获取带前缀的userid
	 * @return
	 */
	public String getUseridWithMark(){
		return StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix +userid;
	}
	
	public String getUserWithAgent(){
		if(agentUser ==null || "".equals(agentUser) || agentUser.equals(StaticVarExtend.NullStr)){
			return getUseridWithMark();
		}
		
		return StaticVarExtend.UserFix + StaticVarExtend.Mark_Fix +agentUser 
				+ StaticVarExtend.AgentUserSplitChar + userid;
	}
	
	/**
	 * 获取完整的人员信息
	 * @return
	 */
	public String getFullName(){
		String tmp = getSubjectionidWithMark();
		String user = getUserWithAgent();
		if("1".equals(isClaim)){
			user = "["+ user +"]";
		}
		if("".equals(tmp)){
			return user;
		}
		
		return user + getSubjectionidWithMark();
		
	}
	/**
	 * 获取参与者id,优先jobid
	 */
	public String getParticipantid() {
		return userid;
	}
	
	/**
	 * 根据当前办理人是否代理返回
	 * @return
	 */
	public String curSetDoUser(){
		if(agentUser == null || agentUser.length()==0){
			return getParticipantid();
		}
		return agentUser+"~"+getParticipantid();
	}
	
	public String getCurNodeAuths() {
		return curAuths;
	}
	public void setCurNodeAuths(String curAuths) {
		this.curAuths = curAuths;
	}
	
	public String getPreNodeAuthsOnCurTrack(){
		return preAuthsOnCurTrack;
	}
	public void setPreNodeAuthsOnCurTrack(String preAuths){
		this.preAuthsOnCurTrack = preAuths;
	}
	
	public String getPreNodeidOnCurTrack() {
		return preNodeidOnCurTrack;
	}

	public void setPreNodeidOnCurTrack(String preNodeidOnCurTrack) {
		this.preNodeidOnCurTrack = preNodeidOnCurTrack;
	}

	/**
	 * 上一路径下的最后节点权限
	 * @return
	 */
	public String getLastNodeAuthsOnPreTrack(){
		return lastAuthsOnPreTrack;
	}
	public void setLastNodeAuthsOnPreTrack(String preAuths){
		this.lastAuthsOnPreTrack = preAuths;
	}
	
	public String getLastNodeidOnPreTrack() {
		return lastNodeidOnPreTrack;
	}
	public void setLastNodeidOnPreTrack(String lastNodeidOnPreTrack) {
		this.lastNodeidOnPreTrack = lastNodeidOnPreTrack;
	}
	public String getOtherNodeAuths() {
		return otherAuths;
	}
	public void setOtherNodeAuths(String otherAuths) {
		this.otherAuths = otherAuths;
	}
	public String getControlNodeName() {
		return (controlNodeName==null||controlNodeName.length()==0)? "Reader_DO":controlNodeName;
	}
	public void setControlNodeName(String controlNodeName) {
		this.controlNodeName = controlNodeName;
	}
	public String getAuthName() {
		return authName;
	}
	public void setAuthName(String authName) {
		this.authName = authName;
	}
	
	public String getAuthObjId() {
		return authObjId;
	}
	public void setAuthObjId(String authObjId) {
		this.authObjId = authObjId;
	}
		
	public String getIsClaim() {
		return isClaim;
	}
	public void setIsClaim(String isClaim) {
		this.isClaim = isClaim;
	}
	public boolean isRdyClaim() {
		return rdyClaim;
	}
	public void setRdyClaim(boolean rdyClaim) {
		this.rdyClaim = rdyClaim;
	}
	
	public boolean isAllowGrab(){
		return curAuthorNum > 1 && StaticVarExtend.AUTH_AUTHOR.equals(authName);
	}
	public void setCurAuthorNum(int num){
		curAuthorNum = num;
	}
	
	/**
	 * 判断当前人是否具有指定的权限
	 * @return
	 */
	public boolean isRole(String userrole){//不带前缀
//		String[] users = alluserid.split(StaticVarExtend.UserSplitChar);
		//alluserid 默认是逗号分隔,userrole默认是StaticVarExtend.UserSplitChar分隔
		//StringUtil.indexOf默认拆分第一个参数,跟第二个参数indexof
		return CStrUtil.indexOfUser(userrole,getAlluserid());
	}
	
	public void setRunndingdata(RunningData runningdata){
		this.runningdata = runningdata;
	}
	
	private boolean isHaveMagr = false;
	private boolean isLoad = false;
	/**
	 * 是否具有管理员权限
	 * @return
	 */
	public boolean isManager(){
		if(isLoad){
			return isHaveMagr;
		}
		isLoad = true;
		if(runningdata ==null){
			return false;
		}
		//20150701liys userid = StaticVarExtend.System_Id 时默认管理员权限
		if(getUserid().equals(StaticVarExtend.System_Id) 
				|| getUserid().equals(StaticVarExtend.Manager_Log_Userid)){
			isHaveMagr = true;
			return true;
		}
		
		String flowid = runningdata.getInstanceDefinition().getFlowinfo().getFlowid();
		isHaveMagr = PluginsUtil.getMultiInstance().getAuthority(runningdata.getInitData().getTenantid()).isManager(flowid, getUserid());
		return isHaveMagr;
	}
	
	/**
	 * 检查指定类型权限是否在列表中
	 * @param auths
	 * @param type
	 * @return
	 */
	public boolean checkHave(String auths,String type){
		String[] authArr = auths.split(StaticVarExtend.StrSplitChar);
		for(String auth:authArr){
			if(auth.equalsIgnoreCase(type)){
				return true;
			}
		}
		return false;
	}
	
}
