package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.AccessUtil;

/**
 * 子流程记录表
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */

/**
 * create table TW_HZ_SUBFLOW_RECORD(
 		id varchar2(32) not null,
 		parentworkid varchar2(32),
 		parenttrackid varchar2(32),
 		parentnodeid varchar2(10),
 		subworkid varchar2(32),
 		subtrackid varchar2(32),
 		subnodeid varchar2(10),
 		subflowvardata clob,
 		subtoparentdata clob,
 		version number,
 		savetime varchar2(25)
 	);
   create table TW_HZ_SUBFLOW_RECORD_VER(
 		id varchar2(32) not null,
 		parentworkid varchar2(32),
 		parenttrackid varchar2(32),
 		parentnodeid varchar2(10),
 		subworkid varchar2(32),
 		subtrackid varchar2(32),
 		subnodeid varchar2(10),
 		subflowvardata clob,
 		subtoparentdata clob,
 		version number,
 		recordid varchar2(32),
 		savetime varchar2(25)
 	);
 */
 public class DBSubflowRecord extends BaseEntity{
	private static final long serialVersionUID = 1L;
	private String recordid;		//记录id
	private String parentworkid;	//父流程实例id
	private String parenttrackid;	//父流程路径id
	private String parentnodeid;	//发起子流程的节点id
	private String subworkid;		//子流程实例id
	private String subtrackid;		//子流程路径id
	private String subnodeid;		//子流程节点id
	private String subflowvardata;	//子流程流程变量数据
	private String subtoparentdata;	//子流程到父流程的变量
	private int version;
	private String savetime;		//保存时间
	private String subflowend = "0";//子流程是否结束0=未结束,1=结束
	private static String INSERT_SQL ="INSERT INTO "+StaticVarExtend.Table_Subflow_Record
			+ "(ID,PARENTWORKID,PARENTTRACKID,PARENTNODEID,SUBWORKID,SUBFLOWVARDATA,"
			+ "SUBTOPARENTDATA,VERSION,SAVETIME,SUBFLOWEND) VALUES (?,?,?,?,?,?,?,?,?,?)";
	protected void getSQL(Map<String, List<Object>> saveMap) {
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(getId());
		dlst.add(parentworkid);
		dlst.add(parenttrackid);
		dlst.add(parentnodeid);
		dlst.add(subworkid);

		dlst.add(subflowvardata);
		dlst.add(subtoparentdata);
		dlst.add(version);
		dlst.add(savetime);
		dlst.add(subflowend);
		saveMap.put(INSERT_SQL,dlst);	//此处不需要考虑多值时的情况,在外围会处理
	}

	/**
	 * 主流程打开时,获取当前节点所有已结束的子流程的返回数据
	 * com.horizon.wf.api.WorkflowOperator.doWithSubflowRecord(Map<String, String>, String, String, String)
	 * @param trackid
	 * @param nodeid
	 * @param identifier
	 * @return
	 */
	public static List<DBSubflowRecord> getListByParentTrackidAndNodeid(String trackid,String nodeid,String identifier){
		String sql = "SELECT SUBFLOWEND,SUBTOPARENTDATA,SUBFLOWVARDATA FROM "+ StaticVarExtend.Table_Subflow_Record
				+ " WHERE PARENTTRACKID=? AND PARENTNODEID=? ";
		List<Object> conditionList = new ArrayList<Object>();
		conditionList.add(trackid);
		conditionList.add(nodeid);
		List<DBSubflowRecord> srList = AccessUtil.getInstance().getMultiObject(sql, conditionList,
				DBSubflowRecord.class, identifier);
		return srList;
	}
	
	public String getSavetime() {
		return savetime;
	}
	public void setSavetime(String savetime) {
		this.savetime = savetime;
	}
	public String getSubtoparentdata() {
		return subtoparentdata;
	}

	public void setSubtoparentdata(String subtoparentdata) {
		this.subtoparentdata = subtoparentdata;
	}

	public String getParentworkid() {
		return parentworkid;
	}
	public void setParentworkid(String parentworkid) {
		this.parentworkid = parentworkid;
	}
	public String getParenttrackid() {
		return parenttrackid;
	}
	public void setParenttrackid(String parenttrackid) {
		this.parenttrackid = parenttrackid;
	}
	public String getParentnodeid() {
		return parentnodeid;
	}
	public void setParentnodeid(String parentnodeid) {
		this.parentnodeid = parentnodeid;
	}
	public String getSubworkid() {
		return subworkid;
	}
	public void setSubworkid(String subworkid) {
		this.subworkid = subworkid;
	}
	public String getSubtrackid() {
		return subtrackid;
	}
	public void setSubtrackid(String subtrackid) {
		this.subtrackid = subtrackid;
	}
	public String getSubnodeid() {
		return subnodeid;
	}
	public void setSubnodeid(String subnodeid) {
		this.subnodeid = subnodeid;
	}
	public String getSubflowvardata() {
		return subflowvardata;
	}
	public void setSubflowvardata(String subflowvardata) {
		this.subflowvardata = subflowvardata;
	}
	public int getVersion() {
		return version;
	}
	public void setVersion(int version) {
		this.version = version;
	}
	public String getSubflowend() {
		return subflowend;
	}
	public void setSubflowend(String subflowend) {
		this.subflowend = subflowend;
	}

	public String getRecordid() {
		return recordid;
	}
	public void setRecordid(String recordid) {
		this.recordid = recordid;
	}
	
	
}
