package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.horizon.wf.global.StaticVarExtend;

/**
 * 
drop table TW_HZ_Relation_Timer;
   create table TW_HZ_Relation_Timer(
       id varchar(32) not null,
       workid varchar(32),
       taskid varchar(32),
       nodeid varchar(20),
       savetime varchar(25),
       version number
   );
 
 */

/**
 * 定时任务和实例关联表
 * @author liangjw
 * @version 1.0
 * @since v7.0
 *
 */
public class DBRelationTimer extends BaseEntity{
	private static final long serialVersionUID = 1L;
	private String workid;
	private String taskid;
	private String nodeid;
	private int version;
	private String tablename = StaticVarExtend.Table_Relation_Timer;
	private String tablenameLog = StaticVarExtend.Table_Relation_Timer_Log;

	public void getSQL(Map<String, List<Object>> saveMap) {
		String sql ="INSERT INTO "+tablename+"(ID,WORKID,TASKID,NODEID,VERSION) VALUES ('"+getId()+"',?,?,?,?)";
		List<Object> dlst = new ArrayList<Object>();
		
		saveMap.put("DELETE FROM " + tablename + " WHERE ID='"+getId()+"'", null);
		dlst.add(workid);
		dlst.add(taskid);
		dlst.add(nodeid);
		dlst.add(version);
		saveMap.put(sql,dlst);
	}
	public void getDelSQL(Map<String, List<Object>> saveMap) {
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(workid);
		dlst.add(nodeid);
		dlst.add(taskid);
		saveMap.put("DELETE FROM " + tablename + " WHERE WORKID=? AND NODEID=? AND TASKID=?", dlst);
		String sql ="INSERT INTO "+tablenameLog+"(ID,WORKID,NODEID,TASKID,VERSION) VALUES ('"+getId()+"',?,?,?,?)";
		dlst.add(version);
		saveMap.put(sql,dlst);
	}

	public String getWorkid() {
		return workid;
	}

	public void setWorkid(String workid) {
		this.workid = workid;
	}

	public String getTaskid() {
		return taskid;
	}

	public void setTaskid(String taskid) {
		this.taskid = taskid;
	}

	public String getNodeid() {
		return nodeid;
	}

	public void setNodeid(String nodeid) {
		this.nodeid = nodeid;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

}
