package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.global.StaticVarExtend;
import com.horizon.wf.tools.AccessUtil;
import com.horizon.wf.tools.CStrUtil;

/**
 * 主子流程关联表
 * @author liangjw
 * @version 1.0
 * @since v7.2
 *
 */
/**
 *
   drop table TWR_HZ_SUBFLOW;
   create table TWR_HZ_SUBFLOW(
       id varchar(32) not null,
       workid varchar(32),
       nodeid varchar(20),
       flowid varchar(32),
       trackid varchar(32),
       subworkid varchar(32),
       subflowend varchar(2),
       waitreturn varchar(2),
       subflowid varchar(32)
   );

 */
public class DBRelationSubflow extends BaseEntity{
	private static final long serialVersionUID = 1L;
	private String workid;			//主流程id
	private String nodeid;			//主流程节点id
	private String flowid;			//主流程流程id
	private String trackid;			//主流程路径id
	private String waitreturn = "0";//主流程是否等待子流程返回  0:不等待  1：等待
	private int version;

	private String subworkid;		//子流程id
	private String subflowend = "0";//子流程是否结束    0:未结束 1：结束
	private String subflowid;		//子流程流程id

	private String title="";		//子流程标题,从instance表中关联获取
	private String subflowname="";	//子流程名称,从instance表中关联获取

	private String nodename;		//主流程节点名称
	private String flowname="";		//主流程名称


	private static String TABLENAME = StaticVarExtend.Table_Relation_Subflow;
	private static String INSERT_SQL = "INSERT INTO " + TABLENAME
			+ "(ID,WORKID,NODEID,FLOWID,SUBWORKID,TRACKID,SUBFLOWEND,WAITRETURN,SUBFLOWID,VERSION,TITLE,SUBFLOWNAME)"
			+ " VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
	protected void exeJSON(JSONObject json){
		//此json为主流程数据,记录的目的是为了判断
		JSONArray jsonArr = json.getJSONArray("DBRelationSubflow");
		if(jsonArr == null){
			jsonArr = new JSONArray();
			json.put("DBRelationSubflow", jsonArr);
		}

		Object thisObj = JSON.toJSON(this);
		jsonArr.add(thisObj);
	}

	protected void getSQL(Map<String, List<Object>> saveMap) {
		List<Object> dlst = new ArrayList<Object>();
		dlst.add(getId());
		dlst.add(workid);
		dlst.add(nodeid);
		dlst.add(flowid);
		dlst.add(subworkid);

		dlst.add(trackid);
		dlst.add(subflowend);
		dlst.add(waitreturn);
		dlst.add(subflowid);
		dlst.add(new Integer(version));

		dlst.add(title);
		dlst.add(subflowname);
		saveMap.put(INSERT_SQL,dlst);//此处不需要考虑多值时的情况,在外围会处理
	}
	/**
	 * 从数据库中获取对象,供子流程结束时,获取主流程信息
	 * com.horizon.wf.action.base.SubflowEnd.doWithSubFlowEnd()
	 * @param subworkid
	 * @param identifier
	 * @return
	 */
	public static DBRelationSubflow getRelationBySubworkid(String subworkid,String identifier){
		String sql = "SELECT A.* FROM "+ TABLENAME +" A WHERE  A.SUBWORKID=?";
		List<Object> para = new ArrayList<Object>();
		para.add(subworkid);
		DBRelationSubflow db =  AccessUtil.getInstance().getSingleObject(sql, para, DBRelationSubflow.class, identifier);

		return db;
	}
	/**
	 * 判断主流程的当前分支是否有其他子流程,是否已经都结束
	 * @param identifier
	 * @return
	 */
	public boolean checkSubFlowIsAllEnd(String identifier){
		String checkSQL = "SELECT ID FROM " + TABLENAME +" WHERE TRACKID=? AND NODEID=? AND SUBFLOWEND='0'";

		List<Object> para = new ArrayList<Object>();
		para.add(trackid);		//主流转的路径id
		para.add(nodeid);
		int counts = AccessUtil.getInstance().getRsCount(checkSQL.toUpperCase(), para,identifier);
		return counts <= 1;
	}

	/**
	 * 主流程启动子流程时获取所有已经启动的子流程信息
	 * com.horizon.wf.action.ActionStartMultiSubFlow.getSubFlowWorks
	 * @param trackid
	 * @param nodeid
	 * @param identifier
	 * @return
	 */
	public static List<DBRelationSubflow> getListByTrackidAndNodeid(JSONObject json,String trackid,String nodeid,String identifier){
		if(json == null){
			return getListByTrackidAndNodeid(trackid,nodeid,identifier);
		}
		List<DBRelationSubflow> list = new ArrayList<DBRelationSubflow>();
		JSONArray jsonArr = json.getJSONArray("DBRelationSubflow");
		if(jsonArr == null){
			//判断json是否为新打开时临时生成的
			String isNew = json.getString("IsNew");
			if("1".equals(isNew)){
				String workid = json.getString("workid");
				List<DBRelationSubflow> allLst = getRelationByWorkid(workid,identifier);
				json.put("DBRelationSubflow", JSON.toJSON(allLst));
				jsonArr = json.getJSONArray("DBRelationSubflow");
			}
			else{
				return list;
			}
		}

		for(int i=0,n=jsonArr.size();i<n;i++){
			JSONObject tmpObj = jsonArr.getJSONObject(i);
			if(trackid.equals(tmpObj.getString("trackid"))
					&& nodeid.equals(tmpObj.getString("nodeid"))){
				DBRelationSubflow rs = JSON.toJavaObject(tmpObj, DBRelationSubflow.class);
				list.add(rs);
			}
		}
		return list;
	}
	private static List<DBRelationSubflow> getListByTrackidAndNodeid(String trackid,String nodeid,String identifier){
		String sql = "SELECT A.* FROM "+TABLENAME+  " A WHERE A.TRACKID=? AND A.NODEID=?";

		List<String> lstConditions = new ArrayList<String>();
		lstConditions.add(trackid);
		lstConditions.add(nodeid);
		return AccessUtil.getInstance().getMultiObject(sql, lstConditions, DBRelationSubflow.class, identifier);
	}

	/**
	 * 获取指定workid实例的所有子流程实例列表
	 * @param workid
	 * @param identifier
	 * @return
	 */
	private static List<DBRelationSubflow> getRelationByWorkid(String workid,String identifier){
		String sql = "SELECT A.* FROM " + TABLENAME +" A WHERE A.WORKID=?";
		List<Object> para = new ArrayList<Object>();
		para.add(workid);
		List<DBRelationSubflow> list =  AccessUtil.getInstance()
				.getMultiObject(sql, para, DBRelationSubflow.class, identifier);
		return list;
	}


	public HashMap<String,String> forServiceMap(){
		HashMap<String,String> map = new HashMap<String,String>();
		map.put("id", getId());
		map.put("workid", workid);
		map.put("nodeid", nodeid);
		map.put("flowid", flowid);
		map.put("subworkid", subworkid);
		map.put("trackid", trackid);
		map.put("subflowend", subflowend);
		map.put("waitreturn", waitreturn);
		map.put("subflowid", subflowid);

		map.put("title", title);
		map.put("flowname", flowname);
		map.put("subflowname", subflowname);
		map.put("nodename", nodename);
		map.put("version", String.valueOf(version));
		return map;
	}

	public String forServiceString(){
		StringBuilder sb = new StringBuilder(1000);
		sb.append("<DBRelationSubflow>");
		CStrUtil.appendTo(sb, "workid", workid);
		CStrUtil.appendTo(sb, "nodeid", nodeid);
		CStrUtil.appendTo(sb, "flowid", flowid);
		CStrUtil.appendTo(sb, "subworkid", subworkid);
		CStrUtil.appendTo(sb, "trackid", trackid);
		CStrUtil.appendTo(sb, "subflowend", subflowend);
		CStrUtil.appendTo(sb, "waitreturn", waitreturn);
		CStrUtil.appendTo(sb, "subflowid", subflowid);

		CStrUtil.appendTo(sb, "title", title);
		CStrUtil.appendTo(sb, "flowname", flowname);
		CStrUtil.appendTo(sb, "subflowname", subflowname);
		CStrUtil.appendTo(sb, "nodename", nodename);
		CStrUtil.appendTo(sb, "version", version);
		sb.append("</DBRelationSubflow>");
		return sb.toString();
	}

	public String getWorkid() {
		return workid;
	}

	public void setWorkid(String workid) {
		this.workid = workid;
	}

	public String getNodeid() {
		return nodeid;
	}

	public void setNodeid(String nodeid) {
		this.nodeid = nodeid;
	}

	public String getSubworkid() {
		return subworkid;
	}

	public void setSubworkid(String subworkid) {
		this.subworkid = subworkid;
	}

	public String getTrackid() {
		return trackid;
	}

	public void setTrackid(String trackid) {
		this.trackid = trackid;
	}

	public String getSubflowend() {
		return subflowend;
	}

	public void setSubflowend(String subflowend) {
		this.subflowend = subflowend;
	}

	public String getWaitreturn() {
		return waitreturn;
	}

	public void setWaitreturn(String waitreturn) {
		this.waitreturn = waitreturn;
	}

	public String getFlowid() {
		return flowid;
	}

	public void setFlowid(String flowid) {
		this.flowid = flowid;
	}

	public String getSubflowid() {
		return subflowid;
	}

	public void setSubflowid(String subflowid) {
		this.subflowid = subflowid;
	}

	public String getTitle() {
		return title;
	}
	public void setTitle(String title) {
		this.title = title;
	}
	public String getFlowname() {
		return flowname;
	}
	public void setFlowname(String flowname) {
		this.flowname = flowname;
	}

	public String getSubflowname() {
		return subflowname;
	}

	public void setSubflowname(String subflowname) {
		this.subflowname = subflowname;
	}

	public String getNodename() {
		return nodename;
	}

	public void setNodename(String nodename) {
		this.nodename = nodename;
	}

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}
	
	
}
