package com.horizon.wf.entity.db;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.horizon.wf.global.StaticVarExtend;

/*
create table TWR_HORIZON_INSTANCE
(
  ID      VARCHAR(32)) CHARACTER SET utf8 COLLATE utf8_bin not null,
  WORKID  VARCHAR(32) CHARACTER SET utf8 COLLATE utf8_bin,
  TABLEID VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_bin,
  DATAID  VARCHAR(32) CHARACTER SET utf8 COLLATE utf8_bin,
  FORMID  VARCHAR(32) CHARACTER SET utf8 COLLATE utf8_bin,
  F1		 VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_bin,
  F2		 VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_bin,
  F3		 VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_bin,
  F4		 VARCHAR(100) CHARACTER SET utf8 COLLATE utf8_bin, 
  constraint PK_TWR_HORIZON_INSTANCE primary key (ID)
)ENGINE=InnoDB DEFAULT CHARSET=utf8;
*/

/**
 * 流程实例和业务数据的关系对应表
 * @author liyong
 *  2012-11-10
 *
 */
public class DBRelation extends BaseEntity{
	private static final long serialVersionUID = 1L;
	private String workid;
	private String tableid;
	private String formid;
	private String dataid;
	
	private final static String TABLENAME = StaticVarExtend.Table_WorkApp;
	public void getSQL(Map<String,List<Object>> saveMap,JSONObject jsonObj){
		int isDel = 1;//1,没有json,2=有json且已有数据,3=有json且无数据
		if(jsonObj != null){
			isDel = exeJSONFirst(jsonObj);
		}
		getSQL(saveMap,isDel);
	}
	private int exeJSONFirst(JSONObject json){
		JSONArray jsonArr = json.getJSONArray("DBRelation");
		if(jsonArr == null){
			jsonArr = new JSONArray();
			json.put("DBRelation", jsonArr);
		}
		else{
			JSONObject tmpObj;
			for(int i=0,n=jsonArr.size();i<n;i++){
				tmpObj = jsonArr.getJSONObject(i);
				if(workid.equals(tmpObj.getString("workid"))
						//&& tableid.equals(tmpObj.getString("tableid"))
						&& dataid.equals(tmpObj.getString("dataid"))
						&& formid.equals(tmpObj.getString("formid"))){
					return 2;
				}
			}
		}
		Object thisObj = JSON.toJSON(this);
		jsonArr.add(thisObj);
		return 3;
	}
	private void getSQL(Map<String,List<Object>> saveMap,int isDel){
		List<Object> tmpLst = new ArrayList<Object>(4);
		tmpLst.add(workid);
		tmpLst.add(tableid);
		tmpLst.add(formid);
		tmpLst.add(dataid);

		if(isDel == 1) {
			List<Object> delLst = new ArrayList<Object>(3);
			delLst.add(workid);
			delLst.add(dataid);

			saveMap.put("DELETE FROM " + TABLENAME + " WHERE WORKID=? AND FORMID='" + formid + "' AND DATAID=?", delLst);
		}
		if(isDel !=2) {
			saveMap.put("INSERT INTO " + TABLENAME + "(ID,WORKID,TABLEID,FORMID,DATAID) VALUES('" + getId() + "',?,?,?,?)", tmpLst);
		}
	}
	
	
	public String getWorkid() {
		return workid;
	}

	public void setWorkid(String workid) {
		this.workid = workid;
	}

	public String getTableid() {
		return tableid;
	}

	public void setTableid(String tableid) {
		this.tableid = tableid;
	}

	public String getFormid() {
		return formid;
	}

	public void setFormid(String formid) {
		this.formid = formid;
	}

	public String getDataid() {
		return dataid;
	}

	public void setDataid(String dataid) {
		this.dataid = dataid;
	}
	
	public static void main(String[] args){
		String a = "";
		JSONObject json = JSON.parseObject(a);
		
		System.out.println(json.toJSONString());
	}
	
	
}
